/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.AbstractAssumption;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import com.oracle.truffle.api.impl.FrameWithoutBoxing;
import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.LayoutFactory;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Executable;
import java.nio.Buffer;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.stack.InspectedFrame;
import jdk.vm.ci.code.stack.InspectedFrameVisitor;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleDebugJavaMethod;
import org.graalvm.compiler.truffle.common.TruffleOutputGroup;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.BaseOSRRootNode;
import org.graalvm.compiler.truffle.runtime.CompilationTask;
import org.graalvm.compiler.truffle.runtime.EngineCacheSupport;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.FixedPointMath;
import org.graalvm.compiler.truffle.runtime.FloodControlHandler;
import org.graalvm.compiler.truffle.runtime.GraalFrameInstance;
import org.graalvm.compiler.truffle.runtime.GraalOSRFrameInstance;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeServiceProvider;
import org.graalvm.compiler.truffle.runtime.GraalTVMCI;
import org.graalvm.compiler.truffle.runtime.GraalTestTVMCI;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListenerDispatcher;
import org.graalvm.compiler.truffle.runtime.InlineDecision;
import org.graalvm.compiler.truffle.runtime.LoopNodeFactory;
import org.graalvm.compiler.truffle.runtime.ModuleUtil;
import org.graalvm.compiler.truffle.runtime.OptimizedAssumption;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.OptimizedIndirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleCallBoundary;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleSplittingStrategy;
import org.graalvm.compiler.truffle.runtime.TruffleTreeDumper;
import org.graalvm.compiler.truffle.runtime.TruffleTypes;
import org.graalvm.compiler.truffle.runtime.debug.JFRListener;
import org.graalvm.compiler.truffle.runtime.debug.StatisticsListener;
import org.graalvm.compiler.truffle.runtime.debug.TraceASTCompilationListener;
import org.graalvm.compiler.truffle.runtime.debug.TraceCompilationListener;
import org.graalvm.compiler.truffle.runtime.debug.TraceCompilationPolymorphismListener;
import org.graalvm.compiler.truffle.runtime.debug.TraceSplittingListener;
import org.graalvm.compiler.truffle.runtime.serviceprovider.TruffleRuntimeServices;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

public abstract class GraalTruffleRuntime
implements TruffleRuntime,
TruffleCompilerRuntime {
    private static final int JAVA_SPECIFICATION_VERSION = Runtime.version().feature();
    private final GraalTruffleRuntimeListenerDispatcher listeners = new GraalTruffleRuntimeListenerDispatcher();
    protected volatile TruffleCompiler truffleCompiler;
    protected KnownMethods knownMethods;
    private final GraalTVMCI tvmci = new GraalTVMCI();
    private volatile GraalTestTVMCI testTvmci;
    private final LoopNodeFactory loopNodeFactory;
    private final EngineCacheSupport engineCacheSupport;
    private final UnmodifiableEconomicMap<String, Class<?>> lookupTypes;
    private final OptionDescriptors engineOptions;
    private final FloodControlHandler floodControlHandler;
    private int compilationThresholdScale = FixedPointMath.toFixedPoint(1.0);

    protected void clearState() {
        assert (TruffleOptions.AOT) : "Must be called only in AOT mode.";
        this.knownMethods = null;
    }

    public static GraalTruffleRuntime getRuntime() {
        return (GraalTruffleRuntime)Truffle.getRuntime();
    }

    public GraalTruffleRuntime(Iterable<Class<?>> extraLookupTypes) {
        this.lookupTypes = GraalTruffleRuntime.initLookupTypes(extraLookupTypes);
        ArrayList<OptionDescriptors> options = new ArrayList<OptionDescriptors>();
        this.loopNodeFactory = GraalTruffleRuntime.loadGraalRuntimeServiceProvider(LoopNodeFactory.class, options, true);
        EngineCacheSupport support = GraalTruffleRuntime.loadGraalRuntimeServiceProvider(EngineCacheSupport.class, options, false);
        this.engineCacheSupport = support == null ? new EngineCacheSupport.Disabled() : support;
        options.add(PolyglotCompilerOptions.getDescriptors());
        this.engineOptions = OptionDescriptors.createUnion((OptionDescriptors[])options.toArray(new OptionDescriptors[options.size()]));
        this.floodControlHandler = GraalTruffleRuntime.loadGraalRuntimeServiceProvider(FloodControlHandler.class, null, false);
    }

    public boolean isLatestJVMCI() {
        return true;
    }

    public abstract ThreadLocalHandshake getThreadLocalHandshake();

    public String getName() {
        String suffix;
        String compilerConfigurationName = this.getCompilerConfigurationName();
        assert (compilerConfigurationName != null);
        if (compilerConfigurationName == null) {
            suffix = "Unknown";
        } else if (compilerConfigurationName.equals("community")) {
            suffix = "CE";
        } else if (compilerConfigurationName.equals("enterprise")) {
            suffix = "EE";
        } else {
            assert (false) : "unexpected compiler configuration name: " + compilerConfigurationName;
            suffix = compilerConfigurationName;
        }
        return "GraalVM " + suffix;
    }

    public final Iterable<Class<?>> getLookupTypes() {
        return this.lookupTypes.getValues();
    }

    protected abstract String getCompilerConfigurationName();

    protected GraalTVMCI getTvmci() {
        return this.tvmci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TVMCI.Test<?, ?> getTestTvmci() {
        if (this.testTvmci == null) {
            GraalTruffleRuntime graalTruffleRuntime = this;
            synchronized (graalTruffleRuntime) {
                if (this.testTvmci == null) {
                    this.testTvmci = new GraalTestTVMCI(this);
                }
            }
        }
        return this.testTvmci;
    }

    @Override
    public CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        return this.asObject(OptimizedCallTarget.class, constant);
    }

    @Override
    public JavaConstant getCallTargetForCallNode(JavaConstant callNodeConstant) {
        OptimizedDirectCallNode callNode = this.asObject(OptimizedDirectCallNode.class, callNodeConstant);
        return this.forObject(callNode.getCallTarget());
    }

    @Override
    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
        OptimizedAssumption optimizedAssumption = this.asObject(OptimizedAssumption.class, optimizedAssumptionConstant);
        return optimizedAssumption.registerDependency();
    }

    protected abstract JavaConstant forObject(Object var1);

    protected abstract <T> T asObject(Class<T> var1, JavaConstant var2);

    protected abstract boolean isPrintGraphEnabled();

    public abstract TruffleCompiler newTruffleCompiler();

    private static <T> T loadServiceProvider(Class<T> clazz, boolean failIfNotFound) {
        Iterable<T> providers = ImageInfo.inImageBuildtimeCode() ? ServiceLoader.load(clazz) : TruffleRuntimeServices.load(clazz);
        boolean priorityService = GraalRuntimeServiceProvider.class.isAssignableFrom(clazz);
        T bestFactory = null;
        int bestPriority = 0;
        for (T factory : providers) {
            int currentPriority = priorityService ? ((GraalRuntimeServiceProvider)factory).getPriority() : 0;
            if (bestFactory != null && currentPriority <= bestPriority) continue;
            bestFactory = factory;
            bestPriority = currentPriority;
        }
        if (bestFactory == null && failIfNotFound) {
            throw new IllegalStateException("Unable to load a factory for " + clazz.getName());
        }
        return bestFactory;
    }

    private static <T extends GraalRuntimeServiceProvider> T loadGraalRuntimeServiceProvider(Class<T> clazz, List<OptionDescriptors> descriptors, boolean failIfNotFound) {
        OptionDescriptors serviceOptions;
        GraalRuntimeServiceProvider bestFactory = (GraalRuntimeServiceProvider)GraalTruffleRuntime.loadServiceProvider(clazz, failIfNotFound);
        if (descriptors != null && bestFactory != null && (serviceOptions = bestFactory.getEngineOptions()) != null) {
            descriptors.add(serviceOptions);
        }
        return (T)bestFactory;
    }

    @Override
    public TruffleCompilerRuntime.ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField field) {
        if (field.isAnnotationPresent(Node.Child.class)) {
            return TruffleCompilerRuntime.ConstantFieldInfo.CHILD;
        }
        if (field.isAnnotationPresent(Node.Children.class)) {
            return TruffleCompilerRuntime.ConstantFieldInfo.CHILDREN;
        }
        CompilerDirectives.CompilationFinal cf = (CompilerDirectives.CompilationFinal)field.getAnnotation(CompilerDirectives.CompilationFinal.class);
        if (cf != null) {
            int dimensions = GraalTruffleRuntime.actualStableDimensions(field, cf.dimensions());
            return TruffleCompilerRuntime.ConstantFieldInfo.forDimensions(dimensions);
        }
        return null;
    }

    private static int actualStableDimensions(ResolvedJavaField field, int dimensions) {
        if (dimensions == 0) {
            return 0;
        }
        int arrayDim = GraalTruffleRuntime.getArrayDimensions(field.getType());
        if (dimensions < 0) {
            if (dimensions != -1) {
                throw new IllegalArgumentException("Negative @CompilationFinal dimensions");
            }
            return arrayDim;
        }
        if (dimensions > arrayDim) {
            throw new IllegalArgumentException(String.format("@CompilationFinal(dimensions=%d) exceeds declared array dimensions (%d) of field %s", dimensions, arrayDim, field));
        }
        return dimensions;
    }

    private static int getArrayDimensions(JavaType type) {
        int dimensions = 0;
        JavaType componentType = type;
        while (componentType.isArray()) {
            ++dimensions;
            componentType = componentType.getComponentType();
        }
        return dimensions;
    }

    @Override
    public TruffleCompilerRuntime.LoopExplosionKind getLoopExplosionKind(ResolvedJavaMethod method) {
        ExplodeLoop explodeLoop = GraalTruffleRuntime.getAnnotation(ExplodeLoop.class, method);
        if (explodeLoop == null) {
            return TruffleCompilerRuntime.LoopExplosionKind.NONE;
        }
        switch (explodeLoop.kind()) {
            case FULL_UNROLL: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_UNROLL;
            }
            case FULL_UNROLL_UNTIL_RETURN: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN;
            }
            case FULL_EXPLODE: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_EXPLODE;
            }
            case FULL_EXPLODE_UNTIL_RETURN: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN;
            }
            case MERGE_EXPLODE: {
                return TruffleCompilerRuntime.LoopExplosionKind.MERGE_EXPLODE;
            }
        }
        throw new InternalError(String.format("Unknown Truffle LoopExplosionKind %s", explodeLoop.kind()));
    }

    private static UnmodifiableEconomicMap<String, Class<?>> initLookupTypes(Iterable<Class<?>> extraTypes) {
        String className;
        EconomicMap m = EconomicMap.create();
        for (Class c : new Class[]{Node.class, RootNode.class, UnexpectedResultException.class, SlowPathException.class, OptimizedCallTarget.class, OptimizedDirectCallNode.class, OptimizedAssumption.class, CompilerDirectives.class, InlineDecision.class, CompilerAsserts.class, ExactMath.class, ArrayUtils.class, FrameDescriptor.class, FrameSlotKind.class, MethodHandle.class, ArrayList.class, FrameSlotKind.class, AbstractAssumption.class, MaterializedFrame.class, FrameWithoutBoxing.class, BranchProfile.class, ConditionProfile.class, Objects.class, TruffleSafepoint.class, BaseOSRRootNode.class, TruffleString.class, AbstractTruffleString.class, Buffer.class}) {
            m.put((Object)c.getName(), (Object)c);
        }
        for (Class clazz : extraTypes) {
            m.put((Object)clazz.getName(), (Object)clazz);
        }
        for (TruffleTypes truffleTypes : TruffleRuntimeServices.load(TruffleTypes.class)) {
            for (Class<?> c : truffleTypes.getTypes()) {
                m.put((Object)c.getName(), c);
            }
        }
        if (JAVA_SPECIFICATION_VERSION >= 16 && JAVA_SPECIFICATION_VERSION < 19) {
            className = "jdk.internal.access.foreign.MemorySegmentProxy";
            try {
                Class<?> clazz = Class.forName(className);
                m.put((Object)clazz.getName(), clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(className);
            }
        }
        if (JAVA_SPECIFICATION_VERSION >= 19) {
            className = "jdk.internal.foreign.Scoped";
            try {
                Class<?> clazz = Class.forName(className);
                m.put((Object)clazz.getName(), clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(className);
            }
        }
        for (String className2 : new String[]{"com.oracle.truffle.api.strings.TStringOps", "com.oracle.truffle.object.UnsafeAccess"}) {
            try {
                Class<?> c = Class.forName(className2);
                m.put((Object)c.getName(), c);
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(className2);
            }
        }
        return m;
    }

    @Override
    public ResolvedJavaType resolveType(MetaAccessProvider metaAccess, String className, boolean required) {
        Class c = (Class)this.lookupTypes.get((Object)className);
        if (c == null) {
            if (!required) {
                return null;
            }
            throw new NoClassDefFoundError(className);
        }
        ResolvedJavaType type = metaAccess.lookupJavaType(c);
        type.link();
        return type;
    }

    protected void installDefaultListeners() {
        TraceCompilationListener.install(this);
        TraceCompilationPolymorphismListener.install(this);
        TraceSplittingListener.install(this);
        StatisticsListener.install(this);
        TraceASTCompilationListener.install(this);
        JFRListener.install(this);
        TruffleSplittingStrategy.installListener(this);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    public final void initializeKnownMethods(MetaAccessProvider metaAccess) {
        this.knownMethods = new KnownMethods(metaAccess);
    }

    public void markFrameMaterializeCalled(FrameDescriptor descriptor) {
        GraalRuntimeAccessor.FRAME.markMaterializeCalled(descriptor);
    }

    public boolean getFrameMaterializeCalled(FrameDescriptor descriptor) {
        return GraalRuntimeAccessor.FRAME.getMaterializeCalled(descriptor);
    }

    public LoopNode createLoopNode(RepeatingNode repeatingNode) {
        if (!(repeatingNode instanceof Node)) {
            throw new IllegalArgumentException("Repeating node must be of type Node.");
        }
        return this.getLoopNodeFactory().create(repeatingNode);
    }

    protected final LoopNodeFactory getLoopNodeFactory() {
        return this.loopNodeFactory;
    }

    public final EngineCacheSupport getEngineCacheSupport() {
        return this.engineCacheSupport;
    }

    public final DirectCallNode createDirectCallNode(CallTarget target) {
        if (target instanceof OptimizedCallTarget) {
            OptimizedCallTarget optimizedTarget = (OptimizedCallTarget)target;
            OptimizedDirectCallNode directCallNode = new OptimizedDirectCallNode(optimizedTarget);
            optimizedTarget.addDirectCallNode(directCallNode);
            return directCallNode;
        }
        throw new IllegalStateException(String.format("Unexpected call target class %s!", target.getClass()));
    }

    public final IndirectCallNode createIndirectCallNode() {
        return new OptimizedIndirectCallNode();
    }

    public final VirtualFrame createVirtualFrame(Object[] arguments, FrameDescriptor frameDescriptor) {
        return OptimizedCallTarget.createFrame(frameDescriptor, arguments);
    }

    public final MaterializedFrame createMaterializedFrame(Object[] arguments) {
        return this.createMaterializedFrame(arguments, new FrameDescriptor());
    }

    public final MaterializedFrame createMaterializedFrame(Object[] arguments, FrameDescriptor frameDescriptor) {
        return new FrameWithoutBoxing(frameDescriptor, arguments);
    }

    public final Assumption createAssumption() {
        return this.createAssumption(null);
    }

    public final Assumption createAssumption(String name) {
        return new OptimizedAssumption(name);
    }

    public final GraalTruffleRuntimeListener getListener() {
        return this.listeners;
    }

    @CompilerDirectives.TruffleBoundary
    public final <T> T iterateFrames(FrameInstanceVisitor<T> visitor, int skipFrames) {
        if (skipFrames < 0) {
            throw new IllegalArgumentException("The skipFrames parameter must be >= 0.");
        }
        return this.iterateImpl(visitor, skipFrames);
    }

    public final int compilationThresholdScale() {
        return this.compilationThresholdScale;
    }

    final void setCompilationThresholdScale(int scale) {
        this.compilationThresholdScale = scale;
    }

    private <T> T iterateImpl(FrameInstanceVisitor<T> visitor, int skip) {
        KnownMethods methods = this.getKnownMethods();
        FrameVisitor<T> jvmciVisitor = new FrameVisitor<T>(visitor, methods, skip);
        return (T)this.getStackIntrospection().iterateFrames(methods.anyFrameMethod, methods.anyFrameMethod, 0, jvmciVisitor);
    }

    protected abstract StackIntrospection getStackIntrospection();

    public <T> T getCapability(Class<T> capability) {
        if (capability == TVMCI.class) {
            return capability.cast((Object)this.tvmci);
        }
        if (capability == LayoutFactory.class) {
            LayoutFactory layoutFactory = GraalTruffleRuntime.loadObjectLayoutFactory();
            ModuleUtil.exportTo(layoutFactory.getClass());
            return capability.cast(layoutFactory);
        }
        if (capability == TVMCI.Test.class) {
            return capability.cast(this.getTestTvmci());
        }
        try {
            return GraalTruffleRuntime.loadServiceProvider(capability, false);
        }
        catch (ServiceConfigurationError e) {
            return null;
        }
    }

    public abstract SpeculationLog createSpeculationLog();

    protected abstract OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget var1, RootNode var2);

    public void addListener(GraalTruffleRuntimeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GraalTruffleRuntimeListener listener) {
        this.listeners.remove(listener);
    }

    private void shutdown() {
        this.getListener().onShutdown();
        TruffleCompiler tcp = this.truffleCompiler;
        if (tcp != null) {
            tcp.shutdown();
        }
    }

    protected final void doCompile(OptimizedCallTarget callTarget, TruffleCompilationTask task) {
        this.doCompile(null, callTarget, task);
    }

    protected final void doCompile(TruffleDebugContext debug, OptimizedCallTarget callTarget, TruffleCompilationTask task) {
        Objects.requireNonNull(callTarget, "Cannot compile null call target.");
        Objects.requireNonNull(task, "Compilation task required.");
        List<OptimizedCallTarget> oldBlockCompilations = callTarget.blockCompilations;
        if (oldBlockCompilations != null) {
            for (OptimizedCallTarget blockTarget : oldBlockCompilations) {
                if (blockTarget.isValid()) continue;
                this.listeners.onCompilationQueued(blockTarget, task.tier());
                int nodeCount = blockTarget.getNonTrivialNodeCount();
                if (nodeCount > (Integer)callTarget.engine.getEngineOptions().get(PolyglotCompilerOptions.PartialBlockMaximumSize)) {
                    this.listeners.onCompilationDequeued(blockTarget, null, "Partial block is too big to be compiled.", task.tier());
                    continue;
                }
                this.compileImpl(debug, blockTarget, task);
            }
        }
        this.compileImpl(debug, callTarget, task);
        if (oldBlockCompilations == null && callTarget.blockCompilations != null) {
            ((CompilationTask)task).reset();
            this.listeners.onCompilationQueued(callTarget, task.tier());
            this.doCompile(callTarget, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileImpl(TruffleDebugContext initialDebug, OptimizedCallTarget callTarget, TruffleCompilationTask task) {
        boolean compilationStarted = false;
        try {
            TruffleCompiler compiler = this.getTruffleCompiler(callTarget);
            try (TruffleCompilation compilation = compiler.openCompilation(callTarget);){
                Map<String, Object> optionsMap = GraalTruffleRuntime.getOptionsForCompiler(callTarget);
                TruffleDebugContext debug = initialDebug;
                if (debug == null) {
                    debug = compiler.openDebugContext(optionsMap, compilation);
                }
                this.listeners.onCompilationStarted(callTarget, task);
                compilationStarted = true;
                try {
                    compiler.doCompile(debug, compilation, optionsMap, task, this.listeners.isEmpty() ? null : this.listeners);
                }
                finally {
                    if (initialDebug == null) {
                        debug.close();
                    }
                }
                TruffleInlining inlining = (TruffleInlining)task.inliningData();
                this.truffleDump(callTarget, compiler, compilation, optionsMap, inlining);
                inlining.dequeueTargets();
            }
        }
        catch (OptimizationFailedException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.notifyCompilationFailure(callTarget, e, compilationStarted, task.tier());
            throw e;
        }
        catch (Throwable e) {
            this.notifyCompilationFailure(callTarget, e, compilationStarted, task.tier());
            throw new InternalError(e);
        }
    }

    private void truffleDump(OptimizedCallTarget callTarget, TruffleCompiler compiler, TruffleCompilation compilation, Map<String, Object> optionsMap, TruffleInlining inlining) throws Exception {
        try (TruffleDebugContext debug = compiler.openDebugContext(optionsMap, compilation);
             AutoCloseable s = debug.scope("Truffle", new TruffleDebugJavaMethod(callTarget));
             TruffleOutputGroup o = this.isPrintGraphEnabled() ? TruffleOutputGroup.openCallTarget(debug, callTarget, Collections.singletonMap("truffle.compilation.id", compilation)) : null;){
            if (!debug.isDumpEnabled()) {
                return;
            }
            if (inlining.inlinedTargets().length > 1) {
                TruffleTreeDumper.dump(debug, callTarget, inlining);
            }
            TruffleTreeDumper.dump(debug, callTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCompilationFailure(OptimizedCallTarget callTarget, Throwable t, boolean compilationStarted, int tier) {
        block3: {
            try {
                if (compilationStarted) {
                    this.listeners.onCompilationFailed(callTarget, t.toString(), false, false, tier);
                    break block3;
                }
                this.listeners.onCompilationDequeued(callTarget, this, String.format("Failed to create Truffle compiler due to %s.", t.getMessage()), tier);
            }
            catch (Throwable throwable) {
                Supplier<String> serializedException = () -> CompilableTruffleAST.serializeException(t);
                callTarget.onCompilationFailed(serializedException, this.isSuppressedTruffleRuntimeException(t) || this.isSuppressedFailure(callTarget, serializedException), false, false, false);
                throw throwable;
            }
        }
        Supplier<String> serializedException = () -> CompilableTruffleAST.serializeException(t);
        callTarget.onCompilationFailed(serializedException, this.isSuppressedTruffleRuntimeException(t) || this.isSuppressedFailure(callTarget, serializedException), false, false, false);
    }

    public abstract BackgroundCompileQueue getCompileQueue();

    public CompilationTask submitForCompilation(OptimizedCallTarget optimizedCallTarget, boolean lastTierCompilation) {
        BackgroundCompileQueue.Priority priority = new BackgroundCompileQueue.Priority(optimizedCallTarget.getCallAndLoopCount(), lastTierCompilation ? BackgroundCompileQueue.Priority.Tier.LAST : BackgroundCompileQueue.Priority.Tier.FIRST);
        return this.getCompileQueue().submitCompilation(priority, optimizedCallTarget);
    }

    private static boolean assertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public void finishCompilation(OptimizedCallTarget optimizedCallTarget, CompilationTask task, boolean mayBeAsynchronous) {
        block4: {
            if (!mayBeAsynchronous) {
                try {
                    GraalTruffleRuntime.uninterruptibleWaitForCompilation(task);
                }
                catch (ExecutionException e) {
                    if (optimizedCallTarget.engine.compilationFailureAction == PolyglotCompilerOptions.ExceptionAction.Throw) {
                        throw new RuntimeException(e.getCause());
                    }
                    if (!GraalTruffleRuntime.assertionsEnabled()) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    private static void uninterruptibleWaitForCompilation(CompilationTask task) throws ExecutionException {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    task.awaitCompletion();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void waitForCompilation(OptimizedCallTarget optimizedCallTarget, long timeout) throws ExecutionException, TimeoutException {
        CompilationTask task = optimizedCallTarget.getCompilationTask();
        if (task != null) {
            try {
                task.awaitCompletion(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public int getCompilationQueueSize() {
        BackgroundCompileQueue compileQueue = this.getCompileQueue();
        return compileQueue == null ? 0 : compileQueue.getQueueSize();
    }

    public void bypassedInstalledCode(OptimizedCallTarget target) {
    }

    public KnownMethods getKnownMethods() {
        return this.knownMethods;
    }

    protected static EngineData getEngineData(RootNode rootNode) {
        return GraalTVMCI.getEngineData(rootNode);
    }

    private static LayoutFactory loadObjectLayoutFactory() {
        return GraalTruffleRuntime.selectObjectLayoutFactory(GraalTruffleRuntime.loadService(LayoutFactory.class));
    }

    private static <T> List<ServiceLoader<T>> loadService(Class<T> service) {
        ServiceLoader<T> graalLoader = ServiceLoader.load(service, GraalTruffleRuntime.class.getClassLoader());
        ServiceLoader<T> appLoader = ServiceLoader.load(service, service.getClassLoader());
        return Arrays.asList(graalLoader, appLoader);
    }

    private static LayoutFactory selectObjectLayoutFactory(Iterable<? extends Iterable<LayoutFactory>> availableLayoutFactories) {
        String layoutFactoryImplName = (String)Services.getSavedProperties().get("truffle.object.LayoutFactory");
        LayoutFactory bestLayoutFactory = null;
        for (Iterable<LayoutFactory> iterable : availableLayoutFactories) {
            for (LayoutFactory currentLayoutFactory : iterable) {
                if (layoutFactoryImplName != null) {
                    if (!currentLayoutFactory.getClass().getName().equals(layoutFactoryImplName)) continue;
                    return currentLayoutFactory;
                }
                if (bestLayoutFactory == null) {
                    bestLayoutFactory = currentLayoutFactory;
                    continue;
                }
                if (currentLayoutFactory.getPriority() < bestLayoutFactory.getPriority()) continue;
                assert (currentLayoutFactory.getPriority() != bestLayoutFactory.getPriority());
                bestLayoutFactory = currentLayoutFactory;
            }
        }
        return bestLayoutFactory;
    }

    protected String printStackTraceToString(Throwable e) {
        CharArrayWriter caw = new CharArrayWriter();
        e.printStackTrace(new PrintWriter(caw));
        return caw.toString();
    }

    protected static ResolvedJavaMethod searchMethod(ResolvedJavaType type, String name) {
        for (ResolvedJavaMethod searchMethod : type.getDeclaredMethods()) {
            if (!searchMethod.getName().equals(name)) continue;
            return searchMethod;
        }
        throw CompilerDirectives.shouldNotReachHere((String)(type + "." + name + " method not found."));
    }

    @Override
    public boolean isValueType(ResolvedJavaType type) {
        return GraalTruffleRuntime.getAnnotation(CompilerDirectives.ValueType.class, type) != null;
    }

    @Override
    public JavaKind getJavaKindForFrameSlotKind(int frameSlotKindTag) {
        if (frameSlotKindTag == FrameSlotKind.Boolean.tag) {
            return JavaKind.Boolean;
        }
        if (frameSlotKindTag == FrameSlotKind.Byte.tag) {
            return JavaKind.Byte;
        }
        if (frameSlotKindTag == FrameSlotKind.Int.tag) {
            return JavaKind.Int;
        }
        if (frameSlotKindTag == FrameSlotKind.Float.tag) {
            return JavaKind.Float;
        }
        if (frameSlotKindTag == FrameSlotKind.Long.tag) {
            return JavaKind.Long;
        }
        if (frameSlotKindTag == FrameSlotKind.Double.tag) {
            return JavaKind.Double;
        }
        if (frameSlotKindTag == FrameSlotKind.Object.tag) {
            return JavaKind.Object;
        }
        if (frameSlotKindTag == FrameSlotKind.Illegal.tag) {
            return JavaKind.Illegal;
        }
        return JavaKind.Illegal;
    }

    @Override
    public int getFrameSlotKindTagForJavaKind(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return FrameSlotKind.Boolean.tag;
            }
            case Byte: {
                return FrameSlotKind.Byte.tag;
            }
            case Int: {
                return FrameSlotKind.Int.tag;
            }
            case Float: {
                return FrameSlotKind.Float.tag;
            }
            case Long: {
                return FrameSlotKind.Long.tag;
            }
            case Double: {
                return FrameSlotKind.Double.tag;
            }
            case Object: {
                return FrameSlotKind.Object.tag;
            }
            case Illegal: {
                return FrameSlotKind.Illegal.tag;
            }
        }
        return FrameSlotKind.Illegal.tag;
    }

    @Override
    public int getFrameSlotKindTagsCount() {
        return FrameSlotKind.values().length;
    }

    @Override
    public TruffleCompilerRuntime.InlineKind getInlineKind(ResolvedJavaMethod original, boolean duringPartialEvaluation) {
        CompilerDirectives.TruffleBoundary truffleBoundary = GraalTruffleRuntime.getAnnotation(CompilerDirectives.TruffleBoundary.class, original);
        if (truffleBoundary != null) {
            if (duringPartialEvaluation) {
                if (truffleBoundary.transferToInterpreterOnException()) {
                    return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION;
                }
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (!truffleBoundary.allowInlining()) {
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
        } else {
            if (GraalTruffleRuntime.getAnnotation(TruffleCallBoundary.class, original) != null) {
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (JFRListener.isInstrumented(original)) {
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
        }
        return TruffleCompilerRuntime.InlineKind.INLINE;
    }

    @Override
    public boolean isInlineable(ResolvedJavaMethod method) {
        return method.canBeInlined();
    }

    @Override
    public boolean isTruffleBoundary(ResolvedJavaMethod method) {
        return GraalTruffleRuntime.getAnnotation(CompilerDirectives.TruffleBoundary.class, method) != null;
    }

    @Override
    public boolean isSpecializationMethod(ResolvedJavaMethod method) {
        return GraalTruffleRuntime.getAnnotation(Specialization.class, method) != null;
    }

    @Override
    public boolean isBytecodeInterpreterSwitch(ResolvedJavaMethod method) {
        return GraalTruffleRuntime.getAnnotation(HostCompilerDirectives.BytecodeInterpreterSwitch.class, method) != null;
    }

    @Override
    public boolean isInliningCutoff(ResolvedJavaMethod method) {
        return GraalTruffleRuntime.getAnnotation(HostCompilerDirectives.InliningCutoff.class, method) != null;
    }

    @Override
    public boolean isInInterpreter(ResolvedJavaMethod targetMethod) {
        return this.getKnownMethods().inInterpreterMethod.equals(targetMethod);
    }

    @Override
    public boolean isTransferToInterpreterMethod(ResolvedJavaMethod method) {
        ResolvedJavaMethod[] methods = this.getKnownMethods().transferToInterpreterMethods;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].equals(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBytecodeInterpreterSwitchBoundary(ResolvedJavaMethod method) {
        return GraalTruffleRuntime.getAnnotation(HostCompilerDirectives.BytecodeInterpreterSwitchBoundary.class, method) != null;
    }

    @Override
    public void log(String loggerId, CompilableTruffleAST compilable, String message) {
        ((OptimizedCallTarget)compilable).engine.getLogger(loggerId).log(Level.INFO, message);
    }

    @Override
    public boolean isSuppressedFailure(CompilableTruffleAST compilable, Supplier<String> serializedException) {
        return this.floodControlHandler != null && this.floodControlHandler.isSuppressedFailure(compilable, serializedException);
    }

    protected boolean isSuppressedTruffleRuntimeException(Throwable throwable) {
        return false;
    }

    private static BailoutException handleAnnotationFailure(NoClassDefFoundError e, String attemptedAction) {
        throw new BailoutException((Throwable)e, "Error while %s. This usually means that the unresolved type is in the signature of some other method or field in the same class. This can be resolved by modifying the relevant class path or module path such that it includes the missing type.", new Object[]{attemptedAction});
    }

    private static <T extends Annotation> T getAnnotation(Class<T> annotationClass, ResolvedJavaMethod method) {
        try {
            return (T)((Annotation)annotationClass.cast(method.getAnnotation(annotationClass)));
        }
        catch (NoClassDefFoundError e) {
            throw GraalTruffleRuntime.handleAnnotationFailure(e, String.format("querying %s for presence of a %s annotation", method.format("%H.%n(%p)"), annotationClass.getName()));
        }
    }

    private static <T extends Annotation> T getAnnotation(Class<T> annotationClass, ResolvedJavaType type) {
        try {
            return (T)((Annotation)annotationClass.cast(type.getAnnotation(annotationClass)));
        }
        catch (NoClassDefFoundError e) {
            throw GraalTruffleRuntime.handleAnnotationFailure(e, String.format("querying %s for presence of a %s annotation", type.toJavaName(), annotationClass.getName()));
        }
    }

    protected AutoCloseable openCompilerThreadScope() {
        return null;
    }

    protected long getCompilerIdleDelay(OptimizedCallTarget callTarget) {
        OptionValues options = callTarget.engine.getEngineOptions();
        if (!((Set)options.get(PolyglotCompilerOptions.MethodExpansionStatistics)).isEmpty() || !((Set)options.get(PolyglotCompilerOptions.NodeExpansionStatistics)).isEmpty() || ((Boolean)options.get(PolyglotCompilerOptions.InstrumentBranches)).booleanValue() || ((Boolean)options.get(PolyglotCompilerOptions.InstrumentBoundaries)).booleanValue()) {
            return 0L;
        }
        return callTarget.getOptionValue(PolyglotCompilerOptions.CompilerIdleDelay);
    }

    final OptionDescriptors getEngineOptionDescriptors() {
        return this.engineOptions;
    }

    public static Map<String, Object> getOptionsForCompiler(OptimizedCallTarget target) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        OptionValues values = target.engine.getEngineOptions();
        for (OptionDescriptor desc : PolyglotCompilerOptions.getDescriptors()) {
            OptionKey key = desc.getKey();
            if (!values.hasBeenSet(key)) continue;
            Object value = values.get(key);
            if (!GraalTruffleRuntime.isPrimitiveType(value)) {
                value = GraalRuntimeAccessor.ENGINE.getUnparsedOptionValue(values, key);
            }
            if (value == null) continue;
            map.put(desc.getName(), value);
        }
        return map;
    }

    private static boolean isPrimitiveType(Object value) {
        Class<?> valueClass = value.getClass();
        return valueClass == Boolean.class || valueClass == Byte.class || valueClass == Short.class || valueClass == Character.class || valueClass == Integer.class || valueClass == Long.class || valueClass == Float.class || valueClass == Double.class || valueClass == String.class;
    }

    protected int getObjectAlignment() {
        throw new UnsupportedOperationException();
    }

    protected int getArrayBaseOffset(Class<?> componentType) {
        throw new UnsupportedOperationException();
    }

    protected int getArrayIndexScale(Class<?> componentType) {
        throw new UnsupportedOperationException();
    }

    protected int getBaseInstanceSize(Class<?> type) {
        throw new UnsupportedOperationException();
    }

    protected Object[] getResolvedFields(Class<?> type, boolean includePrimitive, boolean includeSuperclasses) {
        throw new UnsupportedOperationException();
    }

    protected Object getFieldValue(ResolvedJavaField resolvedJavaField, Object obj) {
        throw new UnsupportedOperationException();
    }

    protected abstract AbstractFastThreadLocal getFastThreadLocalImpl();

    public long getStackOverflowLimit() {
        throw new UnsupportedOperationException();
    }

    public static class StackTraceHelper {
        public static void logHostAndGuestStacktrace(String reason, OptimizedCallTarget callTarget) {
            final int limit = callTarget.getOptionValue(PolyglotCompilerOptions.TraceStackTraceLimit);
            GraalTruffleRuntime runtime = GraalTruffleRuntime.getRuntime();
            final StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(reason).append(" at\n");
            runtime.iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){
                int frameIndex = 0;

                public Object visitFrame(FrameInstance frameInstance) {
                    CallTarget target = frameInstance.getCallTarget();
                    StringBuilder line = new StringBuilder("  ");
                    if (this.frameIndex > 0) {
                        line.append("  ");
                    }
                    line.append(StackTraceHelper.formatStackFrame(frameInstance, target)).append("\n");
                    ++this.frameIndex;
                    messageBuilder.append((CharSequence)line);
                    if (this.frameIndex < limit) {
                        return null;
                    }
                    messageBuilder.append("    ...\n");
                    return frameInstance;
                }
            });
            int skip = 3;
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            String suffix = stackTrace.length > 3 + limit ? "\n    ..." : "";
            messageBuilder.append(Arrays.stream(stackTrace).skip(3L).limit(limit).map(StackTraceElement::toString).collect(Collectors.joining("\n    ", "  ", suffix)));
            runtime.log(callTarget, messageBuilder.toString());
        }

        private static String formatStackFrame(FrameInstance frameInstance, CallTarget target) {
            StringBuilder builder = new StringBuilder();
            if (target instanceof RootCallTarget) {
                OptimizedCallTarget callTarget;
                RootNode root = ((RootCallTarget)target).getRootNode();
                String name = root.getName();
                if (name == null) {
                    builder.append("unnamed-root");
                } else {
                    builder.append(name);
                }
                Node callNode = frameInstance.getCallNode();
                SourceSection sourceSection = null;
                if (callNode != null) {
                    sourceSection = callNode.getEncapsulatingSourceSection();
                }
                if (sourceSection == null) {
                    sourceSection = root.getSourceSection();
                }
                if (sourceSection == null || sourceSection.getSource() == null) {
                    builder.append("(Unknown)");
                } else {
                    builder.append("(").append(StackTraceHelper.formatPath(sourceSection)).append(":").append(sourceSection.getStartLine()).append(")");
                }
                if (target instanceof OptimizedCallTarget && (callTarget = (OptimizedCallTarget)target).isSplit()) {
                    builder.append(" <split-").append(Integer.toHexString(callTarget.hashCode())).append(">");
                }
            } else {
                builder.append(target.toString());
            }
            return builder.toString();
        }

        private static String formatPath(SourceSection sourceSection) {
            if (sourceSection.getSource().getPath() != null) {
                Path path = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath();
                Path filePath = FileSystems.getDefault().getPath(sourceSection.getSource().getPath(), new String[0]).toAbsolutePath();
                try {
                    return path.relativize(filePath).toString();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return sourceSection.getSource().getName();
        }
    }

    public final class KnownMethods {
        public final ResolvedJavaMethod callDirectMethod;
        public final ResolvedJavaMethod callInlinedMethod;
        public final ResolvedJavaMethod callIndirectMethod;
        public final ResolvedJavaMethod callTargetMethod;
        public final ResolvedJavaMethod callInlinedCallMethod;
        public final ResolvedJavaMethod[] anyFrameMethod;
        public final ResolvedJavaMethod inInterpreterMethod;
        public final ResolvedJavaMethod[] transferToInterpreterMethods;

        public KnownMethods(MetaAccessProvider metaAccess) {
            this.callDirectMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_DIRECT);
            this.callIndirectMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_INDIRECT);
            this.callInlinedMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_INLINED);
            this.callInlinedCallMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_INLINED_CALL);
            this.callTargetMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_TARGET_METHOD);
            this.anyFrameMethod = new ResolvedJavaMethod[]{this.callDirectMethod, this.callIndirectMethod, this.callInlinedMethod, this.callTargetMethod, this.callInlinedCallMethod};
            ResolvedJavaType compilerDirectives = metaAccess.lookupJavaType(CompilerDirectives.class);
            this.transferToInterpreterMethods = new ResolvedJavaMethod[2];
            this.transferToInterpreterMethods[0] = GraalTruffleRuntime.searchMethod(compilerDirectives, "transferToInterpreter");
            this.transferToInterpreterMethods[1] = GraalTruffleRuntime.searchMethod(compilerDirectives, "transferToInterpreterAndInvalidate");
            this.inInterpreterMethod = GraalTruffleRuntime.searchMethod(compilerDirectives, "inInterpreter");
        }
    }

    private static final class FrameVisitor<T>
    implements InspectedFrameVisitor<T> {
        private final FrameInstanceVisitor<T> visitor;
        private final KnownMethods methods;
        private int skipFrames;
        private InspectedFrame callNodeFrame;
        private InspectedFrame osrFrame;

        FrameVisitor(FrameInstanceVisitor<T> visitor, KnownMethods methods, int skip) {
            this.visitor = visitor;
            this.methods = methods;
            this.skipFrames = skip;
        }

        public T visitFrame(InspectedFrame frame) {
            if (frame.isMethod(this.methods.callDirectMethod) || frame.isMethod(this.methods.callIndirectMethod) || frame.isMethod(this.methods.callInlinedMethod) || frame.isMethod(this.methods.callInlinedCallMethod)) {
                this.callNodeFrame = frame;
                return null;
            }
            assert (frame.isMethod(this.methods.callTargetMethod));
            if (FrameVisitor.isOSRFrame(frame)) {
                if (this.skipFrames == 0 && this.osrFrame == null) {
                    this.osrFrame = frame;
                }
                return null;
            }
            if (this.skipFrames > 0) {
                --this.skipFrames;
                return null;
            }
            try {
                if (this.osrFrame != null) {
                    Object object = this.visitor.visitFrame((FrameInstance)new GraalOSRFrameInstance(frame, this.callNodeFrame, this.osrFrame));
                    return (T)object;
                }
                Object object = this.visitor.visitFrame((FrameInstance)new GraalFrameInstance(frame, this.callNodeFrame));
                return (T)object;
            }
            finally {
                this.osrFrame = null;
                this.callNodeFrame = null;
            }
        }

        private static boolean isOSRFrame(InspectedFrame frame) {
            return ((OptimizedCallTarget)frame.getLocal(0)).getRootNode() instanceof BaseOSRRootNode;
        }
    }
}

