/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.Arrays;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.ResolvedMethodHandleCallTargetNode;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="see MacroNode", size=NodeSize.SIZE_UNKNOWN, sizeRationale="see MacroNode")
public final class MethodHandleNode
extends MacroNode
implements Simplifiable {
    public static final NodeClass<MethodHandleNode> TYPE = NodeClass.create(MethodHandleNode.class);
    protected final MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod;

    public MethodHandleNode(MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod, MacroNode.MacroParams p) {
        super(TYPE, p);
        this.intrinsicMethod = intrinsicMethod;
    }

    public static InvokeNode tryResolveTargetInvoke(GraphAdder adder, MethodHandleAccessProvider methodHandleAccess, MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod, ResolvedJavaMethod original, int bci, StampPair returnStamp, ValueNode ... arguments) {
        switch (intrinsicMethod) {
            case INVOKE_BASIC: {
                return MethodHandleNode.getInvokeBasicTarget(adder, intrinsicMethod, methodHandleAccess, original, bci, returnStamp, arguments);
            }
            case LINK_TO_STATIC: 
            case LINK_TO_SPECIAL: 
            case LINK_TO_VIRTUAL: 
            case LINK_TO_INTERFACE: {
                return MethodHandleNode.getLinkToTarget(adder, intrinsicMethod, methodHandleAccess, original, bci, returnStamp, arguments);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public void simplify(SimplifierTool tool) {
        MethodHandleAccessProvider methodHandleAccess = tool.getConstantReflection().getMethodHandleAccess();
        ValueNode[] argumentsArray = this.arguments.toArray((A[])new ValueNode[this.arguments.size()]);
        final MethodHandleNode before = this;
        GraphAdder adder = new GraphAdder(this.graph()){

            @Override
            public <T extends ValueNode> T add(T node) {
                T added = MethodHandleNode.this.graph().addOrUnique(node);
                if (added instanceof FixedWithNextNode) {
                    MethodHandleNode.this.graph().addBeforeFixed(before, (FixedWithNextNode)added);
                }
                return added;
            }
        };
        InvokeNode invoke = MethodHandleNode.tryResolveTargetInvoke(adder, methodHandleAccess, this.intrinsicMethod, this.targetMethod, this.bci, this.returnStamp, argumentsArray);
        if (invoke != null) {
            assert (invoke.graph() == null);
            invoke = this.graph().addOrUniqueWithInputs(invoke);
            invoke.setStateAfter(this.stateAfter());
            FixedNode currentNext = this.next();
            this.replaceAtUsages(invoke);
            GraphUtil.removeFixedWithUnusedInputs(this);
            this.graph().addBeforeFixed(currentNext, invoke);
        }
    }

    private static ValueNode getReceiver(ValueNode[] arguments) {
        return arguments[0];
    }

    private static ValueNode getMemberName(ValueNode[] arguments) {
        return arguments[arguments.length - 1];
    }

    private static InvokeNode getInvokeBasicTarget(GraphAdder adder, MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod, MethodHandleAccessProvider methodHandleAccess, ResolvedJavaMethod original, int bci, StampPair returnStamp, ValueNode[] arguments) {
        ValueNode methodHandleNode = MethodHandleNode.getReceiver(arguments);
        if (methodHandleNode.isConstant()) {
            return MethodHandleNode.getTargetInvokeNode(adder, intrinsicMethod, methodHandleAccess, bci, returnStamp, arguments, methodHandleAccess.resolveInvokeBasicTarget(methodHandleNode.asJavaConstant(), true), original);
        }
        return null;
    }

    private static InvokeNode getLinkToTarget(GraphAdder adder, MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod, MethodHandleAccessProvider methodHandleAccess, ResolvedJavaMethod original, int bci, StampPair returnStamp, ValueNode[] arguments) {
        ValueNode memberNameNode = MethodHandleNode.getMemberName(arguments);
        if (memberNameNode.isConstant()) {
            return MethodHandleNode.getTargetInvokeNode(adder, intrinsicMethod, methodHandleAccess, bci, returnStamp, arguments, methodHandleAccess.resolveLinkToTarget(memberNameNode.asJavaConstant()), original);
        }
        return null;
    }

    private static InvokeNode getTargetInvokeNode(GraphAdder adder, MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod, MethodHandleAccessProvider methodHandleAccess, int bci, StampPair returnStamp, ValueNode[] originalArguments, ResolvedJavaMethod target, ResolvedJavaMethod original) {
        if (target == null || !MethodHandleNode.isConsistentInfo(methodHandleAccess, original, target)) {
            return null;
        }
        Signature signature = target.getSignature();
        boolean isStatic = target.isStatic();
        int receiverSkip = isStatic ? 0 : 1;
        Assumptions assumptions = adder.getAssumptions();
        ResolvedJavaMethod realTarget = null;
        if (target.canBeStaticallyBound() || intrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_SPECIAL) {
            realTarget = target;
        } else {
            ValueNode receiver;
            TypeReference receiverType;
            ResolvedJavaType targetType = target.getDeclaringClass();
            Assumptions.AssumptionResult concreteMethod = targetType.findUniqueConcreteMethod(target);
            if (concreteMethod == null && (intrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_VIRTUAL || intrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_INTERFACE) && (receiverType = StampTool.typeReferenceOrNull((receiver = MethodHandleNode.getReceiver(originalArguments)).stamp(NodeView.DEFAULT))) != null) {
                concreteMethod = receiverType.getType().findUniqueConcreteMethod(target);
            }
            if (concreteMethod != null && concreteMethod.canRecordTo(assumptions)) {
                concreteMethod.recordTo(assumptions);
                realTarget = (ResolvedJavaMethod)concreteMethod.getResult();
            }
        }
        if (realTarget != null) {
            ValueNode[] arguments = (ValueNode[])originalArguments.clone();
            if (!isStatic) {
                ResolvedJavaType receiverType = target.getDeclaringClass();
                MethodHandleNode.maybeCastArgument(adder, arguments, 0, (JavaType)receiverType);
            }
            for (int index = 0; index < signature.getParameterCount(false); ++index) {
                JavaType parameterType = signature.getParameterType(index, target.getDeclaringClass());
                MethodHandleNode.maybeCastArgument(adder, arguments, receiverSkip + index, parameterType);
            }
            InvokeNode invoke = MethodHandleNode.createTargetInvokeNode(assumptions, intrinsicMethod, realTarget, original, bci, returnStamp, arguments);
            assert (invoke != null) : "graph has been modified so this must result an invoke";
            return invoke;
        }
        return null;
    }

    private static void maybeCastArgument(GraphAdder adder, ValueNode[] arguments, int index, JavaType type) {
        ResolvedJavaType argumentType;
        Assumptions assumptions;
        TypeReference targetType;
        ValueNode argument = arguments[index];
        if (type instanceof ResolvedJavaType && !((ResolvedJavaType)type).isJavaLangObject() && (targetType = TypeReference.create(assumptions = adder.getAssumptions(), (ResolvedJavaType)type)) != null && !targetType.getType().isPrimitive() && !argument.getStackKind().isPrimitive() && ((argumentType = StampTool.typeOrNull(argument.stamp(NodeView.DEFAULT))) == null || argumentType.isAssignableFrom(targetType.getType()) && !argumentType.equals(targetType.getType()))) {
            LogicNode inst = InstanceOfNode.createAllowNull(targetType, argument, null, null);
            assert (!inst.isAlive());
            if (!inst.isTautology()) {
                ValueNode valueNode;
                ValueNode guard;
                inst = adder.add(inst);
                AnchoringNode guardAnchor = adder.getGuardAnchor();
                DeoptimizationReason reason = DeoptimizationReason.ClassCastException;
                DeoptimizationAction action = DeoptimizationAction.InvalidateRecompile;
                SpeculationLog.Speculation speculation = SpeculationLog.NO_SPECULATION;
                if (guardAnchor == null) {
                    FixedGuardNode fixedGuard;
                    guard = fixedGuard = adder.add(new FixedGuardNode(inst, reason, action, speculation, false));
                } else {
                    GuardNode newGuard = adder.add(new GuardNode(inst, guardAnchor, reason, action, false, speculation, null));
                    adder.add(new ValueAnchorNode(newGuard));
                    guard = newGuard;
                }
                arguments[index] = valueNode = adder.add(PiNode.create(argument, StampFactory.object(targetType), guard.asNode()));
            }
        }
    }

    private static InvokeNode createTargetInvokeNode(Assumptions assumptions, MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod, ResolvedJavaMethod target, ResolvedJavaMethod original, int bci, StampPair returnStamp, ValueNode[] arguments) {
        ValueNode[] targetArguments;
        CallTargetNode.InvokeKind targetInvokeKind = target.isStatic() ? CallTargetNode.InvokeKind.Static : CallTargetNode.InvokeKind.Special;
        JavaType targetReturnType = target.getSignature().getReturnType(null);
        switch (intrinsicMethod) {
            case INVOKE_BASIC: {
                targetArguments = arguments;
                break;
            }
            case LINK_TO_STATIC: 
            case LINK_TO_SPECIAL: 
            case LINK_TO_VIRTUAL: 
            case LINK_TO_INTERFACE: {
                targetArguments = Arrays.copyOfRange(arguments, 0, arguments.length - 1);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        StampPair targetReturnStamp = StampFactory.forDeclaredType(assumptions, targetReturnType, false);
        MethodCallTargetNode callTarget = ResolvedMethodHandleCallTargetNode.create(targetInvokeKind, target, targetArguments, targetReturnStamp, original, arguments, returnStamp);
        if (returnStamp.getTrustedStamp().getStackKind() == JavaKind.Void) {
            return new InvokeNode((CallTargetNode)callTarget, bci, StampFactory.forVoid());
        }
        return new InvokeNode(callTarget, bci);
    }

    private static boolean isConsistentInfo(MethodHandleAccessProvider methodHandleAccess, ResolvedJavaMethod original, ResolvedJavaMethod target) {
        int hasAppendix;
        boolean invokeThroughMHIntrinsic;
        MethodHandleAccessProvider.IntrinsicMethod originalIntrinsicMethod = methodHandleAccess.lookupMethodHandleIntrinsic(original);
        assert (originalIntrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.INVOKE_BASIC || originalIntrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_STATIC || originalIntrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_SPECIAL || originalIntrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_VIRTUAL || originalIntrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_INTERFACE);
        MethodHandleAccessProvider.IntrinsicMethod targetIntrinsicMethod = methodHandleAccess.lookupMethodHandleIntrinsic(target);
        Signature originalSignature = original.getSignature();
        Signature targetSignature = target.getSignature();
        boolean bl = invokeThroughMHIntrinsic = originalIntrinsicMethod != null && targetIntrinsicMethod == null;
        if (!invokeThroughMHIntrinsic) {
            return original.getName().equals(target.getName()) && originalSignature.equals(targetSignature);
        }
        int n = hasAppendix = originalIntrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_STATIC || originalIntrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_SPECIAL || originalIntrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_VIRTUAL || originalIntrinsicMethod == MethodHandleAccessProvider.IntrinsicMethod.LINK_TO_INTERFACE ? 1 : 0;
        if (originalSignature.getParameterCount(original.hasReceiver()) != targetSignature.getParameterCount(target.hasReceiver()) + hasAppendix) {
            return false;
        }
        int senderBase = 0;
        int receiverBase = 0;
        switch (originalIntrinsicMethod) {
            case LINK_TO_SPECIAL: 
            case LINK_TO_VIRTUAL: 
            case LINK_TO_INTERFACE: {
                if (target.isStatic()) {
                    return false;
                }
                if (originalSignature.getParameterKind(0).isPrimitive()) {
                    return false;
                }
                senderBase = 1;
                break;
            }
            case LINK_TO_STATIC: {
                if (!target.hasReceiver()) break;
                return false;
            }
            case INVOKE_BASIC: {
                if (!target.isStatic()) break;
                if (targetSignature.getParameterKind(0).isPrimitive()) {
                    return false;
                }
                receiverBase = 1;
                break;
            }
        }
        assert (targetSignature.getParameterCount(false) - receiverBase == originalSignature.getParameterCount(false) - senderBase - hasAppendix) : "argument count mismatch";
        int argCount = targetSignature.getParameterCount(false) - receiverBase;
        for (int i = 0; i < argCount; ++i) {
            if (originalSignature.getParameterKind(senderBase + i).getStackKind() == targetSignature.getParameterKind(receiverBase + i).getStackKind()) continue;
            return false;
        }
        return originalSignature.getReturnKind() == JavaKind.Void || originalSignature.getReturnKind().getStackKind() == targetSignature.getReturnKind().getStackKind();
    }

    public static abstract class GraphAdder {
        private final StructuredGraph graph;

        public GraphAdder(StructuredGraph graph) {
            this.graph = graph;
        }

        public abstract <T extends ValueNode> T add(T var1);

        public AnchoringNode getGuardAnchor() {
            return null;
        }

        public Assumptions getAssumptions() {
            return this.graph.getAssumptions();
        }
    }
}

