/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.type.StampTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class CountLeadingZerosNode
extends UnaryNode
implements ArithmeticLIRLowerable,
Lowerable {
    public static final NodeClass<CountLeadingZerosNode> TYPE = NodeClass.create(CountLeadingZerosNode.class);

    protected CountLeadingZerosNode(ValueNode value) {
        super(TYPE, CountLeadingZerosNode.computeStamp(value.stamp(NodeView.DEFAULT), value), value);
        assert (value.getStackKind() == JavaKind.Int || value.getStackKind() == JavaKind.Long);
    }

    public static ValueNode create(ValueNode value) {
        ValueNode folded = CountLeadingZerosNode.tryFold(value);
        if (folded != null) {
            return folded;
        }
        return new CountLeadingZerosNode(value);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        return CountLeadingZerosNode.computeStamp(newStamp, this.getValue());
    }

    private static Stamp computeStamp(Stamp newStamp, ValueNode theValue) {
        assert (newStamp.isCompatible(theValue.stamp(NodeView.DEFAULT)));
        assert (theValue.getStackKind() == JavaKind.Int || theValue.getStackKind() == JavaKind.Long);
        return StampTool.stampForLeadingZeros((IntegerStamp)newStamp);
    }

    public static ValueNode tryFold(ValueNode value) {
        if (value.isConstant()) {
            JavaConstant c = value.asJavaConstant();
            if (value.getStackKind() == JavaKind.Int) {
                return ConstantNode.forInt(Integer.numberOfLeadingZeros(c.asInt()));
            }
            return ConstantNode.forInt(Long.numberOfLeadingZeros(c.asLong()));
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode folded = CountLeadingZerosNode.tryFold(forValue);
        return folded != null ? folded : this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitCountLeadingZeros(builder.operand(this.getValue())));
    }
}

