/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.lir.amd64.AMD64CalcStringAttributesOp;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.amd64.AMD64CalcStringAttributesForeignCalls;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public final class AMD64CalcStringAttributesNode
extends PureFunctionStubIntrinsicNode {
    public static final NodeClass<AMD64CalcStringAttributesNode> TYPE = NodeClass.create(AMD64CalcStringAttributesNode.class);
    private static final EnumSet<AMD64.CPUFeature> MINIMUM_FEATURES_AMD64 = EnumSet.of(AMD64.CPUFeature.SSE, new AMD64.CPUFeature[]{AMD64.CPUFeature.SSE2, AMD64.CPUFeature.SSE3, AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.SSE4_1, AMD64.CPUFeature.SSE4_2, AMD64.CPUFeature.POPCNT});
    private final AMD64CalcStringAttributesOp.Op op;
    private final boolean assumeValid;
    @Node.Input
    protected ValueNode array;
    @Node.Input
    protected ValueNode offset;
    @Node.Input
    protected ValueNode length;

    protected AMD64CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op op, @Node.ConstantNodeParameter boolean assumeValid) {
        this(array, offset, length, op, assumeValid, null, LocationIdentity.any());
    }

    protected AMD64CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op op, @Node.ConstantNodeParameter boolean assumeValid, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(array, offset, length, op, assumeValid, runtimeCheckedCPUFeatures, LocationIdentity.any());
    }

    public AMD64CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op op, @Node.ConstantNodeParameter boolean assumeValid, LocationIdentity locationIdentity) {
        this(array, offset, length, op, assumeValid, null, locationIdentity);
    }

    public AMD64CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op op, @Node.ConstantNodeParameter boolean assumeValid, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity) {
        super(TYPE, StampFactory.forKind(AMD64CalcStringAttributesNode.getReturnValueKind(op)), runtimeCheckedCPUFeatures, locationIdentity);
        this.op = op;
        this.assumeValid = assumeValid;
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    private static JavaKind getReturnValueKind(AMD64CalcStringAttributesOp.Op op) {
        return op == AMD64CalcStringAttributesOp.Op.UTF_8 || op == AMD64CalcStringAttributesOp.Op.UTF_16 ? JavaKind.Long : JavaKind.Int;
    }

    public AMD64CalcStringAttributesOp.Op getOp() {
        return this.op;
    }

    public boolean isAssumeValid() {
        return this.assumeValid;
    }

    public ValueNode getArray() {
        return this.array;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
        return MINIMUM_FEATURES_AMD64;
    }

    public static EnumSet<?> minFeaturesAARCH64() {
        throw GraalError.shouldNotReachHere("not implemented yet");
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return AMD64CalcStringAttributesForeignCalls.getStub(this);
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.array, this.offset, this.length};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitCalcStringAttributes((Object)this.op, this.getRuntimeCheckedCPUFeatures(), gen.operand(this.array), gen.operand(this.offset), gen.operand(this.length), this.assumeValid));
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="calcStringAttributesLatin1", parameters={"LATIN1", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesBMP", parameters={"BMP", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF32", parameters={"UTF_32", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")})
    public static native int intReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op var4, @Node.ConstantNodeParameter boolean var5);

    @Node.NodeIntrinsic
    public static native int intReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op var4, @Node.ConstantNodeParameter boolean var5, @Node.ConstantNodeParameter EnumSet<?> var6);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="calcStringAttributesUTF8Valid", parameters={"UTF_8", "true"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF8Unknown", parameters={"UTF_8", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF16Valid", parameters={"UTF_16", "true"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF16Unknown", parameters={"UTF_16", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")})
    public static native long longReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op var4, @Node.ConstantNodeParameter boolean var5);

    @Node.NodeIntrinsic
    public static native long longReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op var4, @Node.ConstantNodeParameter boolean var5, @Node.ConstantNodeParameter EnumSet<?> var6);
}

