/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.RetryableBailoutException;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.core.common.util.CompilationAlarm;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;

public final class ReentrantBlockIterator {
    private ReentrantBlockIterator() {
    }

    public static <StateT> LoopInfo<StateT> processLoop(BlockIteratorClosure<StateT> closure, Loop<Block> loop, StateT initialState) {
        EconomicMap<FixedNode, StateT> blockEndStates = ReentrantBlockIterator.apply(closure, loop.getHeader(), initialState, block -> block.getLoop() != loop && !block.isLoopHeader());
        Block[] predecessors = (Block[])loop.getHeader().getPredecessors();
        LoopInfo info = new LoopInfo(predecessors.length - 1, loop.getLoopExits().size());
        for (int i = 1; i < predecessors.length; ++i) {
            Object endState = blockEndStates.get((Object)predecessors[i].getEndNode());
            info.endStates.add(closure.cloneState(endState));
        }
        for (Block loopExit : loop.getLoopExits()) {
            assert (loopExit.getPredecessorCount() == 1);
            assert (blockEndStates.containsKey((Object)loopExit.getBeginNode())) : loopExit.getBeginNode() + " " + blockEndStates;
            Object exitState = blockEndStates.get((Object)loopExit.getBeginNode());
            info.exitStates.add(closure.cloneState(exitState));
        }
        return info;
    }

    public static <StateT> void apply(BlockIteratorClosure<StateT> closure, Block start) {
        ReentrantBlockIterator.apply(closure, start, closure.getInitialState(), null);
    }

    public static <StateT> EconomicMap<FixedNode, StateT> apply(BlockIteratorClosure<StateT> closure, Block start, StateT initialState, Predicate<Block> stopAtBlock) {
        ArrayDeque<Block> blockQueue = new ArrayDeque<Block>();
        EconomicMap states = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        Object state = initialState;
        Block current = start;
        StructuredGraph graph = start.getBeginNode().graph();
        CompilationAlarm compilationAlarm = CompilationAlarm.current();
        while (true) {
            if (compilationAlarm.hasExpired()) {
                int period = CompilationAlarm.Options.CompilationExpirationPeriod.getValue(graph.getOptions());
                if (period > 120) {
                    throw new PermanentBailoutException("Compilation exceeded %d seconds during CFG traversal", period);
                }
                throw new RetryableBailoutException("Compilation exceeded %d seconds during CFG traversal", period);
            }
            Block next = null;
            if (stopAtBlock != null && stopAtBlock.test(current)) {
                states.put((Object)current.getBeginNode(), state);
            } else {
                state = closure.processBlock(current, state);
                Block[] successors = (Block[])current.getSuccessors();
                if (successors.length != 0) {
                    if (successors.length == 1) {
                        Block successor = successors[0];
                        if (successor.isLoopHeader()) {
                            if (current.isLoopEnd()) {
                                states.put((Object)current.getEndNode(), state);
                            } else {
                                ReentrantBlockIterator.recurseIntoLoop(closure, blockQueue, states, state, successor);
                            }
                        } else if (current.getEndNode() instanceof AbstractEndNode) {
                            AbstractEndNode end = (AbstractEndNode)current.getEndNode();
                            AbstractMergeNode merge = end.merge();
                            if (ReentrantBlockIterator.allEndsVisited(states, current, merge)) {
                                ArrayList<StateT> mergedStates = ReentrantBlockIterator.mergeStates(states, state, current, successor, merge);
                                state = closure.merge(successor, mergedStates);
                                next = successor;
                            } else {
                                assert (!states.containsKey((Object)end));
                                states.put((Object)end, state);
                            }
                        } else {
                            next = successor;
                        }
                    } else {
                        next = ReentrantBlockIterator.processMultipleSuccessors(closure, blockQueue, states, state, successors);
                    }
                }
            }
            if (next != null) {
                current = next;
                continue;
            }
            if (blockQueue.isEmpty()) {
                return states;
            }
            current = (Block)blockQueue.removeFirst();
            assert (current.getPredecessorCount() == 1);
            assert (states.containsKey((Object)current.getBeginNode()));
            state = states.removeKey((Object)current.getBeginNode());
        }
    }

    private static <StateT> boolean allEndsVisited(EconomicMap<FixedNode, StateT> states, Block current, AbstractMergeNode merge) {
        for (AbstractEndNode abstractEndNode : merge.forwardEnds()) {
            if (abstractEndNode == current.getEndNode() || states.containsKey((Object)abstractEndNode)) continue;
            return false;
        }
        return true;
    }

    private static <StateT> Block processMultipleSuccessors(BlockIteratorClosure<StateT> closure, Deque<Block> blockQueue, EconomicMap<FixedNode, StateT> states, StateT state, Block[] successors) {
        assert (successors.length > 1);
        for (int i = 1; i < successors.length; ++i) {
            Block successor = successors[i];
            blockQueue.addFirst(successor);
            states.put((Object)successor.getBeginNode(), closure.afterSplit(successor, closure.cloneState(state)));
        }
        return successors[0];
    }

    private static <StateT> ArrayList<StateT> mergeStates(EconomicMap<FixedNode, StateT> states, StateT state, Block current, Block successor, AbstractMergeNode merge) {
        ArrayList<StateT> mergedStates = new ArrayList<StateT>(merge.forwardEndCount());
        for (Block predecessor : (Block[])successor.getPredecessors()) {
            assert (predecessor == current || states.containsKey((Object)predecessor.getEndNode()));
            StateT endState = predecessor == current ? state : states.removeKey((Object)predecessor.getEndNode());
            mergedStates.add(endState);
        }
        return mergedStates;
    }

    private static <StateT> void recurseIntoLoop(BlockIteratorClosure<StateT> closure, Deque<Block> blockQueue, EconomicMap<FixedNode, StateT> states, StateT state, Block successor) {
        Loop<Block> loop = successor.getLoop();
        LoopBeginNode loopBegin = (LoopBeginNode)loop.getHeader().getBeginNode();
        assert (successor.getBeginNode() == loopBegin);
        List<StateT> exitStates = closure.processLoop(loop, state);
        int i = 0;
        assert (loop.getLoopExits().size() == exitStates.size());
        for (Block exit : loop.getLoopExits()) {
            states.put((Object)exit.getBeginNode(), exitStates.get(i++));
            blockQueue.addFirst(exit);
        }
    }

    public static abstract class BlockIteratorClosure<StateT> {
        protected abstract StateT getInitialState();

        protected abstract StateT processBlock(Block var1, StateT var2);

        protected abstract StateT merge(Block var1, List<StateT> var2);

        protected abstract StateT cloneState(StateT var1);

        protected StateT afterSplit(Block successor, StateT oldState) {
            return oldState;
        }

        protected abstract List<StateT> processLoop(Loop<Block> var1, StateT var2);
    }

    public static class LoopInfo<StateT> {
        public final List<StateT> endStates;
        public final List<StateT> exitStates;

        public LoopInfo(int endCount, int exitCount) {
            this.endStates = new ArrayList<StateT>(endCount);
            this.exitStates = new ArrayList<StateT>(exitCount);
        }
    }
}

