/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import java.util.function.BiFunction;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.FixedBinaryNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.SignedDivNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedDivNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;

public class MathUtil {
    private static boolean isConstantOne(ValueNode v1) {
        return v1.isConstant() && v1.stamp(NodeView.DEFAULT) instanceof IntegerStamp && v1.asJavaConstant().asLong() == 1L;
    }

    private static boolean isConstantZero(ValueNode v1) {
        return v1.isConstant() && v1.stamp(NodeView.DEFAULT) instanceof IntegerStamp && v1.asJavaConstant().asLong() == 0L;
    }

    public static ValueNode add(StructuredGraph graph, ValueNode v1, ValueNode v2) {
        return MathUtil.add(graph, v1, v2, true);
    }

    public static ValueNode add(StructuredGraph graph, ValueNode v1, ValueNode v2, boolean gvn) {
        if (MathUtil.isConstantZero(v1)) {
            return v2;
        }
        if (MathUtil.isConstantZero(v2)) {
            return v1;
        }
        if (gvn) {
            return BinaryArithmeticNode.add(graph, v1, v2, NodeView.DEFAULT);
        }
        return graph.addWithoutUniqueWithInputs(new AddNode(v1, v2));
    }

    public static ValueNode mul(StructuredGraph graph, ValueNode v1, ValueNode v2) {
        return MathUtil.mul(graph, v1, v2, true);
    }

    public static ValueNode mul(StructuredGraph graph, ValueNode v1, ValueNode v2, boolean gvn) {
        if (MathUtil.isConstantOne(v1)) {
            return v2;
        }
        if (MathUtil.isConstantOne(v2)) {
            return v1;
        }
        if (gvn) {
            return BinaryArithmeticNode.mul(graph, v1, v2, NodeView.DEFAULT);
        }
        return graph.addWithoutUniqueWithInputs(new MulNode(v1, v2));
    }

    public static ValueNode sub(StructuredGraph graph, ValueNode v1, ValueNode v2) {
        return MathUtil.sub(graph, v1, v2, true);
    }

    public static ValueNode sub(StructuredGraph graph, ValueNode v1, ValueNode v2, boolean gvn) {
        if (MathUtil.isConstantZero(v2)) {
            return v1;
        }
        if (gvn) {
            return BinaryArithmeticNode.sub(graph, v1, v2, NodeView.DEFAULT);
        }
        return graph.addWithoutUniqueWithInputs(new SubNode(v1, v2));
    }

    public static ValueNode divBefore(StructuredGraph graph, FixedNode before, ValueNode dividend, ValueNode divisor, GuardingNode zeroCheck) {
        return MathUtil.fixedDivBefore(graph, before, dividend, divisor, (dend, sor) -> SignedDivNode.create(dend, sor, zeroCheck, NodeView.DEFAULT));
    }

    public static ValueNode unsignedDivBefore(StructuredGraph graph, FixedNode before, ValueNode dividend, ValueNode divisor, GuardingNode zeroCheck) {
        return MathUtil.fixedDivBefore(graph, before, dividend, divisor, (dend, sor) -> UnsignedDivNode.create(dend, sor, zeroCheck, NodeView.DEFAULT));
    }

    private static ValueNode fixedDivBefore(StructuredGraph graph, FixedNode before, ValueNode dividend, ValueNode divisor, BiFunction<ValueNode, ValueNode, ValueNode> createDiv) {
        if (MathUtil.isConstantOne(divisor)) {
            return dividend;
        }
        ValueNode div = createDiv.apply(dividend, divisor);
        if (div instanceof FixedBinaryNode) {
            FixedBinaryNode binaryPredecessor;
            FixedBinaryNode fixedDiv = (FixedBinaryNode)div;
            if (before.predecessor() instanceof FixedBinaryNode && fixedDiv.dataFlowEquals(binaryPredecessor = (FixedBinaryNode)before.predecessor())) {
                if (fixedDiv.isAlive()) {
                    fixedDiv.safeDelete();
                }
                return binaryPredecessor;
            }
            graph.addBeforeFixed(before, graph.addOrUniqueWithInputs(fixedDiv));
        }
        return div;
    }
}

