/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.cfg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.CFGVerifier;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.HIRLoop;
import org.graalvm.compiler.nodes.cfg.ReversePostOrder;
import org.graalvm.compiler.options.OptionKey;

public final class ControlFlowGraph
implements AbstractControlFlowGraph<Block> {
    public static final double MIN_RELATIVE_FREQUENCY = 3.054936363499605E-151;
    public static final double MAX_RELATIVE_FREQUENCY = 3.273390607896142E150;
    public final StructuredGraph graph;
    private NodeMap<Block> nodeToBlock;
    private Block[] reversePostOrder;
    private List<Loop<Block>> loops;
    private int maxDominatorDepth;
    private EconomicMap<LoopBeginNode, ProfileData.LoopFrequencyData> localLoopFrequencyData;

    public static ControlFlowGraph computeForSchedule(StructuredGraph graph) {
        return ControlFlowGraph.compute(graph, true, true, true, false);
    }

    public static ControlFlowGraph compute(StructuredGraph graph, boolean connectBlocks, boolean computeLoops, boolean computeDominators, boolean computePostdominators) {
        ControlFlowGraph cfg = new ControlFlowGraph(graph);
        cfg.identifyBlocks();
        boolean loopInfoComputed = false;
        if (CFGOptions.DumpEndVersusExitLoopFrequencies.getValue(graph.getOptions()).booleanValue()) {
            cfg.computeLoopInformation();
            cfg.computeDominators();
            loopInfoComputed = true;
        }
        cfg.computeFrequencies();
        if (computeLoops && !loopInfoComputed) {
            cfg.computeLoopInformation();
        }
        if (computeDominators && !loopInfoComputed) {
            cfg.computeDominators();
            assert (cfg.verifyRPOInnerLoopsFirst());
        }
        if (computePostdominators) {
            cfg.computePostdominators();
        }
        assert (!connectBlocks && !computeLoops && !computeDominators && !computePostdominators || CFGVerifier.verify(cfg));
        return cfg;
    }

    private void identifyBlocks() {
        int numBlocks = 0;
        for (AbstractBeginNode begin : this.graph.getNodes(AbstractBeginNode.TYPE)) {
            GraalError.guarantee(begin.predecessor() != null || begin instanceof StartNode || begin instanceof AbstractMergeNode, "Disconnected control flow %s encountered", (Object)begin);
            Block block = new Block(begin);
            this.identifyBlock(block);
            ++numBlocks;
        }
        this.reversePostOrder = ReversePostOrder.identifyBlocks(this, numBlocks);
    }

    public double localLoopFrequency(LoopBeginNode lb) {
        return ((ProfileData.LoopFrequencyData)this.localLoopFrequencyData.get((Object)lb)).getLoopFrequency();
    }

    public ProfileData.ProfileSource localLoopFrequencySource(LoopBeginNode lb) {
        return ((ProfileData.LoopFrequencyData)this.localLoopFrequencyData.get((Object)lb)).getProfileSource();
    }

    public EconomicMap<LoopBeginNode, ProfileData.LoopFrequencyData> getLocalLoopFrequencyData() {
        return this.localLoopFrequencyData;
    }

    public void updateCachedLocalLoopFrequency(LoopBeginNode lb, Function<ProfileData.LoopFrequencyData, ProfileData.LoopFrequencyData> updater) {
        this.localLoopFrequencyData.put((Object)lb, (Object)updater.apply((ProfileData.LoopFrequencyData)this.localLoopFrequencyData.get((Object)lb)));
    }

    public String dominatorTreeString() {
        return ControlFlowGraph.dominatorTreeString(this.getStartBlock());
    }

    private static String dominatorTreeString(Block b) {
        StringBuilder sb = new StringBuilder();
        sb.append(b);
        sb.append("(");
        for (Block firstDominated = (Block)b.getFirstDominated(); firstDominated != null; firstDominated = (Block)firstDominated.getDominatedSibling()) {
            if (((Block)firstDominated.getDominator()).getPostdominator() == firstDominated) {
                sb.append("!");
            }
            sb.append(ControlFlowGraph.dominatorTreeString(firstDominated));
        }
        sb.append(") ");
        return sb.toString();
    }

    public <V> void visitDominatorTreeDefault(RecursiveVisitor<V> visitor) {
        Block[] stack = new Block[this.maxDominatorDepth + 1];
        Block current = this.getStartBlock();
        int tos = 0;
        Object[] values = null;
        int valuesTOS = 0;
        while (tos >= 0) {
            Object value;
            Block state = stack[tos];
            if (state == null || state.getDominator() == null || ((Block)state.getDominator()).getPostdominator() != state) {
                Block postDom;
                if (state == null) {
                    Block dominated;
                    value = visitor.enter(current);
                    if (value != null || values != null) {
                        if (values == null) {
                            values = new Object[this.maxDominatorDepth + 1];
                        }
                        values[valuesTOS++] = value;
                    }
                    if ((dominated = ControlFlowGraph.skipPostDom((Block)current.getFirstDominated())) != null) {
                        stack[tos] = dominated;
                        current = dominated;
                        stack[++tos] = null;
                        continue;
                    }
                } else {
                    Block next = ControlFlowGraph.skipPostDom((Block)state.getDominatedSibling());
                    if (next != null) {
                        stack[tos] = next;
                        current = next;
                        stack[++tos] = null;
                        continue;
                    }
                }
                if ((postDom = current.getPostdominator()) != null && postDom.getDominator() == current) {
                    stack[tos] = postDom;
                    current = postDom;
                    stack[++tos] = null;
                    continue;
                }
            }
            value = null;
            if (values != null && valuesTOS > 0) {
                value = values[--valuesTOS];
            }
            visitor.exit(current, value);
            current = (Block)current.getDominator();
            --tos;
        }
    }

    private static Block skipPostDom(Block block) {
        if (block != null && ((Block)block.getDominator()).getPostdominator() == block) {
            return (Block)block.getDominatedSibling();
        }
        return block;
    }

    public static void addDeferredExit(DeferredExit[] deferredExits, Block b) {
        Loop<Block> outermostExited = ((Block)b.getDominator()).getLoop();
        Loop<Block> exitBlockLoop = b.getLoop();
        assert (outermostExited != null) : "Dominator must be in a loop. Possible cause is a missing loop exit node.";
        while (outermostExited.getParent() != null && outermostExited.getParent() != exitBlockLoop) {
            outermostExited = outermostExited.getParent();
        }
        int loopIndex = outermostExited.getIndex();
        deferredExits[loopIndex] = new DeferredExit(b, deferredExits[loopIndex]);
    }

    public <V> void visitDominatorTreeDeferLoopExits(RecursiveVisitor<V> visitor) {
        Block[] stack = new Block[this.getBlocks().length];
        int tos = 0;
        BitSet visited = new BitSet(this.getBlocks().length);
        int loopCount = this.getLoops().size();
        DeferredExit[] deferredExits = new DeferredExit[loopCount];
        Object[] values = null;
        int valuesTOS = 0;
        stack[0] = this.getStartBlock();
        while (tos >= 0) {
            Block alwaysReached;
            Object value;
            Block cur = stack[tos];
            int curId = cur.getId();
            if (visited.get(curId)) {
                int loopIndex;
                DeferredExit deferredExit;
                value = null;
                if (values != null && valuesTOS > 0) {
                    value = values[--valuesTOS];
                }
                visitor.exit(cur, value);
                --tos;
                if (!cur.isLoopHeader() || (deferredExit = deferredExits[loopIndex = cur.getLoop().getIndex()]) == null) continue;
                while (deferredExit != null) {
                    stack[++tos] = deferredExit.block;
                    deferredExit = deferredExit.next;
                }
                deferredExits[loopIndex] = null;
                continue;
            }
            visited.set(curId);
            value = visitor.enter(cur);
            if (value != null || values != null) {
                if (values == null) {
                    values = new Object[this.maxDominatorDepth + 1];
                }
                values[valuesTOS++] = value;
            }
            if ((alwaysReached = cur.getPostdominator()) != null) {
                if (alwaysReached.getDominator() != cur) {
                    alwaysReached = null;
                } else if (ControlFlowGraph.isDominatorTreeLoopExit(alwaysReached)) {
                    ControlFlowGraph.addDeferredExit(deferredExits, alwaysReached);
                } else {
                    stack[++tos] = alwaysReached;
                }
            }
            for (Block b = (Block)cur.getFirstDominated(); b != null; b = (Block)b.getDominatedSibling()) {
                if (b == alwaysReached) continue;
                if (ControlFlowGraph.isDominatorTreeLoopExit(b)) {
                    ControlFlowGraph.addDeferredExit(deferredExits, b);
                    continue;
                }
                stack[++tos] = b;
            }
        }
    }

    public <V> void visitDominatorTree(RecursiveVisitor<V> visitor, boolean deferLoopExits) {
        if (deferLoopExits && this.getLoops().size() > 0) {
            this.visitDominatorTreeDeferLoopExits(visitor);
        } else {
            this.visitDominatorTreeDefault(visitor);
        }
    }

    public static boolean isDominatorTreeLoopExit(Block b) {
        return ControlFlowGraph.isDominatorTreeLoopExit(b, false);
    }

    public static boolean isDominatorTreeLoopExit(Block b, boolean considerRealExits) {
        Block dominator = (Block)b.getDominator();
        if (!(dominator == null || b.getLoop() == dominator.getLoop() || b.isLoopHeader() && dominator.getLoopDepth() < b.getLoopDepth())) {
            return true;
        }
        return considerRealExits && b.getBeginNode() instanceof LoopExitNode;
    }

    private ControlFlowGraph(StructuredGraph graph) {
        this.graph = graph;
        this.nodeToBlock = graph.createNodeMap();
    }

    private boolean verifyRPOInnerLoopsFirst() {
        return this.rpoInnerLoopsFirst(b -> {}, b -> {});
    }

    private boolean rpoInnerLoopsFirst(Consumer<Block> perBasicBlockOption, Consumer<LoopBeginNode> loopClosedAction) {
        RPOLoopVerification[] openLoops = new RPOLoopVerification[this.graph.getNodes(LoopBeginNode.TYPE).count()];
        int tos = 0;
        for (Block b : this.reversePostOrder) {
            if (b.isLoopHeader()) {
                RPOLoopVerification lv = new RPOLoopVerification((LoopBeginNode)b.getBeginNode());
                openLoops[tos++] = lv;
            }
            perBasicBlockOption.accept(b);
            boolean wasExit = ControlFlowGraph.predecessorBlockSequentialLoopExit(b);
            FixedNode f = b.getBeginNode();
            while (true) {
                if (f instanceof LoopExitNode) {
                    LoopBeginNode closedLoop = ((LoopExitNode)f).loopBegin();
                    RPOLoopVerification lv = openLoops[tos - 1];
                    assert (lv.lb == closedLoop) : "Must close inner loops first before closing other ones stackLoop=" + lv.lb + " exited loop=" + closedLoop + " block=" + b;
                    if (!lv.allEndsVisited()) {
                        throw GraalError.shouldNotReachHere("Loop ends should be visited before exits. This is a major error in the reverse post order of the control flow graph of this method. This typically means wrongly specified control-split nodes have been processed in ReversePostOrder.java.");
                    }
                    ++lv.exitsVisited;
                    if (lv.loopFullyProcessed()) {
                        loopClosedAction.accept(lv.lb);
                        --tos;
                    }
                    wasExit = true;
                }
                if (f == b.getEndNode()) break;
                f = ((FixedWithNextNode)f).next();
            }
            if (!b.isLoopEnd()) continue;
            RPOLoopVerification lv = null;
            LoopEndNode len = (LoopEndNode)b.getEndNode();
            int index = tos - 1;
            if (wasExit) {
                while (openLoops[index].lb != len.loopBegin()) {
                    --index;
                }
                lv = openLoops[index];
            } else {
                lv = openLoops[tos - 1];
            }
            LoopBeginNode closedLoop = ((LoopEndNode)b.getEndNode()).loopBegin();
            assert (lv.lb == closedLoop) : "Must close inner loops first before closing other ones stackLoop=" + lv.lb + " ended loop=" + closedLoop + " block=" + b + "->" + b.getBeginNode();
            ++lv.endsVisited;
            if (!lv.loopFullyProcessed()) continue;
            loopClosedAction.accept(lv.lb);
            if (lv.lb != openLoops[tos - 1].lb) {
                RPOLoopVerification[] tmp = new RPOLoopVerification[openLoops.length];
                System.arraycopy(openLoops, 0, tmp, 0, index);
                System.arraycopy(openLoops, index + 1, tmp, index, openLoops.length - (index + 1));
                openLoops = tmp;
            }
            --tos;
        }
        assert (tos == 0) : "Unfinished loops on stack " + tos;
        return true;
    }

    private static boolean predecessorBlockSequentialLoopExit(Block b) {
        Block cur = b;
        while (cur.getPredecessorCount() == 1 && ((Block[])cur.getPredecessors())[0].getSuccessorCount() == 1) {
            Block pred = ((Block[])cur.getPredecessors())[0];
            FixedNode f = pred.getBeginNode();
            while (true) {
                if (f instanceof LoopExitNode) {
                    return true;
                }
                if (f == pred.getEndNode()) break;
                f = ((FixedWithNextNode)f).next();
            }
            cur = ((Block[])cur.getPredecessors())[0];
        }
        return false;
    }

    private void computeDominators() {
        assert (this.reversePostOrder[0].getPredecessorCount() == 0) : "start block has no predecessor and therefore no dominator";
        Block[] blocks = this.reversePostOrder;
        int curMaxDominatorDepth = 0;
        for (int i = 1; i < blocks.length; ++i) {
            Block block = blocks[i];
            assert (block.getPredecessorCount() > 0);
            AbstractBlockBase dominator = null;
            for (Block pred : (Block[])block.getPredecessors()) {
                if (pred.isLoopEnd()) continue;
                dominator = dominator == null ? pred : ControlFlowGraph.commonDominatorRaw((Block)dominator, pred);
            }
            assert (dominator != null);
            block.setDominator(dominator);
            Block currentDominated = (Block)dominator.getFirstDominated();
            if (currentDominated != null && currentDominated.getId() < block.getId()) {
                while (currentDominated.getDominatedSibling() != null && ((Block)currentDominated.getDominatedSibling()).getId() < block.getId()) {
                    currentDominated = (Block)currentDominated.getDominatedSibling();
                }
                block.setDominatedSibling((Block)currentDominated.getDominatedSibling());
                currentDominated.setDominatedSibling(block);
            } else {
                block.setDominatedSibling((Block)dominator.getFirstDominated());
                dominator.setFirstDominated(block);
            }
            curMaxDominatorDepth = Math.max(curMaxDominatorDepth, block.getDominatorDepth());
        }
        this.maxDominatorDepth = curMaxDominatorDepth;
        ControlFlowGraph.calcDominatorRanges(this.getStartBlock(), this.reversePostOrder.length);
    }

    private static void calcDominatorRanges(Block block, int size) {
        Block[] stack = new Block[size];
        stack[0] = block;
        int tos = 0;
        int myNumber = 0;
        do {
            Block cur = stack[tos];
            Block dominated = (Block)cur.getFirstDominated();
            if (cur.getDominatorNumber() == -1) {
                cur.setDominatorNumber(myNumber);
                if (dominated != null) {
                    do {
                        stack[++tos] = dominated;
                    } while ((dominated = (Block)dominated.getDominatedSibling()) != null);
                } else {
                    cur.setMaxChildDomNumber(myNumber);
                    --tos;
                }
                ++myNumber;
                continue;
            }
            cur.setMaxChildDomNumber(dominated.getMaxChildDominatorNumber());
            --tos;
        } while (tos >= 0);
    }

    private static Block commonDominatorRaw(Block a, Block b) {
        int bDomDepth;
        int aDomDepth = a.getDominatorDepth();
        if (aDomDepth > (bDomDepth = b.getDominatorDepth())) {
            return ControlFlowGraph.commonDominatorRawSameDepth(a.getDominator(aDomDepth - bDomDepth), b);
        }
        return ControlFlowGraph.commonDominatorRawSameDepth(a, b.getDominator(bDomDepth - aDomDepth));
    }

    private static Block commonDominatorRawSameDepth(Block a, Block b) {
        Block iterA = a;
        for (Block iterB = b; iterA != iterB; iterA = (Block)iterA.getDominator(), iterB = (Block)iterB.getDominator()) {
        }
        return iterA;
    }

    public Block[] getBlocks() {
        return this.reversePostOrder;
    }

    @Override
    public Block getStartBlock() {
        return this.reversePostOrder[0];
    }

    public Block[] reversePostOrder() {
        return this.reversePostOrder;
    }

    public NodeMap<Block> getNodeToBlock() {
        return this.nodeToBlock;
    }

    public Block blockFor(Node node) {
        return this.nodeToBlock.get(node);
    }

    public Block commonDominatorFor(NodeIterable<? extends Node> nodes) {
        Block commonDom = null;
        for (Node node : nodes) {
            Block b = this.blockFor(node);
            commonDom = (Block)AbstractControlFlowGraph.commonDominator(commonDom, b);
        }
        return commonDom;
    }

    @Override
    public List<Loop<Block>> getLoops() {
        return this.loops;
    }

    public int getMaxDominatorDepth() {
        return this.maxDominatorDepth;
    }

    private void identifyBlock(Block block) {
        FixedNode next;
        FixedWithNextNode cur = block.getBeginNode();
        while (true) {
            assert (cur.isAlive()) : cur;
            assert (this.nodeToBlock.get(cur) == null);
            this.nodeToBlock.set(cur, block);
            next = cur.next();
            assert (next != null) : cur;
            if (next instanceof AbstractBeginNode) {
                block.endNode = cur;
                return;
            }
            if (!(next instanceof FixedWithNextNode)) break;
            cur = (FixedWithNextNode)next;
        }
        this.nodeToBlock.set(next, block);
        block.endNode = next;
    }

    private void finishLocalLoopFrequency(LoopBeginNode lb) {
        this.calculateLocalLoopFrequency(lb);
        double sumAllLexFrequency = 0.0;
        for (LoopExitNode lex : lb.loopExits()) {
            sumAllLexFrequency += this.blockFor((Node)lex).relativeFrequency;
        }
        for (LoopExitNode lex : lb.loopExits()) {
            Block lexBlock = this.blockFor(lex);
            assert (lexBlock != null);
            double lexFrequency = lexBlock.getRelativeFrequency();
            double scaleLexFrequency = lexFrequency / sumAllLexFrequency;
            double loopPredFrequency = this.blockFor((Node)lb.forwardEnd()).relativeFrequency;
            double exitFrequency = ControlFlowGraph.multiplyRelativeFrequencies(scaleLexFrequency, loopPredFrequency);
            lexBlock.setRelativeFrequency(exitFrequency);
            GraalError.guarantee(this.blockFor((Node)lex).relativeFrequency <= loopPredFrequency, "Lex frequency %f must be below pred frequency %f", (Object)loopPredFrequency, (Object)exitFrequency);
        }
    }

    private void computeLocalLoopFrequencies() {
        this.rpoInnerLoopsFirst(b -> this.perBasicBlockFrequencyAction((Block)b, true), lb -> this.finishLocalLoopFrequency((LoopBeginNode)lb));
    }

    private double calculateLocalLoopFrequency(LoopBeginNode lb) {
        Block header = this.blockFor(lb);
        assert (header != null);
        double loopFrequency = -1.0;
        ProfileData.ProfileSource source = ProfileData.ProfileSource.UNKNOWN;
        if (CFGOptions.UseLoopEndFrequencies.getValue(lb.graph().getOptions()).booleanValue()) {
            double loopEndFrequency = 0.0;
            for (LoopEndNode len : lb.loopEnds()) {
                Block endBlock = this.blockFor(len);
                assert (endBlock != null);
                assert (endBlock.relativeFrequency >= 0.0);
                loopEndFrequency += endBlock.relativeFrequency;
                source = source.combine(endBlock.frequencySource);
            }
            loopEndFrequency = Math.min(1.0, loopEndFrequency);
            if ((loopEndFrequency = Math.max(3.054936363499605E-151, loopEndFrequency)) == 1.0) {
                loopFrequency = 3.273390607896142E150;
            } else {
                double exitFrequency = 1.0 - loopEndFrequency;
                loopFrequency = 1.0 / exitFrequency;
                assert (Double.isFinite(loopFrequency)) : "Loop=" + lb + " Loop Frequency=" + loopFrequency + " endFrequency=" + loopEndFrequency;
                assert (!Double.isNaN(loopFrequency)) : "Loop=" + lb + " Loop Frequency=" + loopFrequency + " endFrequency=" + loopEndFrequency;
            }
        } else {
            double loopExitFrequencySum = 0.0;
            for (LoopExitNode lex : lb.loopExits()) {
                Block lexBlock = this.blockFor(lex);
                assert (lexBlock != null);
                assert (lexBlock.relativeFrequency >= 0.0);
                loopExitFrequencySum += lexBlock.relativeFrequency;
                source = source.combine(lexBlock.frequencySource);
            }
            loopExitFrequencySum = Math.min(1.0, loopExitFrequencySum);
            loopExitFrequencySum = Math.max(3.054936363499605E-151, loopExitFrequencySum);
            loopFrequency = 1.0 / loopExitFrequencySum;
            assert (Double.isFinite(loopFrequency)) : "Loop=" + lb + " Loop Frequency=" + loopFrequency + " lexFrequencySum=" + loopExitFrequencySum;
            assert (!Double.isNaN(loopFrequency)) : "Loop=" + lb + " Loop Frequency=" + loopFrequency + " lexFrequencySum=" + loopExitFrequencySum;
            if (CFGOptions.DumpEndVersusExitLoopFrequencies.getValue(lb.getOptions()).booleanValue()) {
                this.debugLocalLoopFrequencies(lb, loopFrequency, loopExitFrequencySum);
            }
        }
        this.localLoopFrequencyData.put((Object)lb, (Object)ProfileData.LoopFrequencyData.create(loopFrequency, source));
        return loopFrequency;
    }

    private void debugLocalLoopFrequencies(LoopBeginNode lb, double loopFrequency, double loopExitFrequencySum) {
        try (DebugContext.Scope s = lb.getDebug().scope("CFGFrequencyInfo");){
            boolean hasLoopExits;
            boolean sinkingImplicitExitsFullyVisited = true;
            double loopSinkFrequencySum = 0.0;
            for (Block loopBlock : this.blockFor(lb).getLoop().getBlocks()) {
                FixedNode blockEndNode = loopBlock.getEndNode();
                if (blockEndNode instanceof ControlSinkNode) {
                    double sinkBlockFrequency = this.blockFor((Node)blockEndNode).relativeFrequency;
                    loopSinkFrequencySum += sinkBlockFrequency;
                }
                if (this.blockFor((Node)blockEndNode).relativeFrequency != -1.0) continue;
                sinkingImplicitExitsFullyVisited = false;
            }
            double delta = 0.01;
            if (sinkingImplicitExitsFullyVisited) {
                block6: for (Block loopBlock : this.blockFor(lb).getLoop().getBlocks()) {
                    if (loopBlock.isLoopHeader() || ControlFlowGraph.isDominatorTreeLoopExit(loopBlock, true)) continue;
                    for (Block succ : (Block[])loopBlock.getSuccessors()) {
                        if (ControlFlowGraph.isDominatorTreeLoopExit(succ, true) || succ.isLoopHeader()) continue block6;
                    }
                    double selfFrequency = loopBlock.relativeFrequency;
                    double succFrequency = 0.0;
                    for (Block succ : (Block[])loopBlock.getSuccessors()) {
                        succFrequency += succ.relativeFrequency;
                    }
                    if (loopBlock.getSuccessorCount() == 0) {
                        GraalError.guarantee(loopBlock.getEndNode() instanceof ControlSinkNode, "Must sink if there is no successor");
                        continue;
                    }
                    if (!(succFrequency < selfFrequency - 0.01)) continue;
                    String format = "Successors must add up for block %s with begin %s, selfF=%f succF=%f";
                    this.graph.getDebug().dump(3, this.graph, format, loopBlock, loopBlock.getBeginNode(), selfFrequency, succFrequency);
                    throw GraalError.shouldNotReachHere(String.format(format, loopBlock, loopBlock.getBeginNode(), selfFrequency, succFrequency));
                }
            }
            double loopEndFrequencySum = 0.0;
            for (LoopEndNode len : lb.loopEnds()) {
                Block lenBlock = this.blockFor(len);
                loopEndFrequencySum += lenBlock.relativeFrequency;
            }
            double endBasedFrequency = 1.0 / (1.0 - loopEndFrequencySum);
            if (loopEndFrequencySum == 1.0) {
                endBasedFrequency = 3.273390607896142E150;
            }
            for (Block loopBlock : this.blockFor(lb).getLoop().getBlocks()) {
                if (!loopBlock.isLoopHeader() || loopBlock.getBeginNode() == lb) continue;
                LoopBeginNode otherLoop = (LoopBeginNode)loopBlock.getBeginNode();
                double otherLoopExitFrequencySum = 0.0;
                for (LoopExitNode lex : otherLoop.loopExits()) {
                    otherLoopExitFrequencySum += this.blockFor((Node)lex).relativeFrequency;
                }
                double predFrequency = loopBlock.getFirstPredecessor().relativeFrequency;
                double frequencyDifference = Math.abs(predFrequency - otherLoopExitFrequencySum);
                if (!(frequencyDifference > 0.01)) continue;
                this.graph.getDebug().dump(3, this.graph, "Frequencies diverge too much");
                throw GraalError.shouldNotReachHere("Frequencies diverge too much");
            }
            boolean bl = hasLoopExits = lb.loopExits().count() > 0;
            if (Math.abs(endBasedFrequency - loopFrequency) > CFGOptions.LoopExitVsLoopEndFrequencyDiff.getValue(lb.getOptions()) && hasLoopExits) {
                this.graph.getDebug().dump(3, this.graph, "Frequency divergence for loop %s,exitBasedFrequency=%.4f endBasedFrequency=%.4f, exitFSum=%.2f / endFSum=%.2f/ sinkSum=%.2f [allSum=%f]", lb, loopFrequency, endBasedFrequency, loopExitFrequencySum, loopEndFrequencySum, loopSinkFrequencySum, loopExitFrequencySum + loopEndFrequencySum + loopSinkFrequencySum);
            }
        }
    }

    private void resetBlockFrequencies() {
        for (Block block : this.reversePostOrder) {
            block.setRelativeFrequency(0.0);
        }
    }

    private void computeFrequenciesFromLocal() {
        for (Block block : this.reversePostOrder) {
            this.perBasicBlockFrequencyAction(block, false);
        }
    }

    private void perBasicBlockFrequencyAction(Block b, boolean computingLocalLoopFrequencies) {
        double relativeFrequency = -1.0;
        ProfileData.ProfileSource source = ProfileData.ProfileSource.UNKNOWN;
        Block[] predecessors = (Block[])b.getPredecessors();
        if (predecessors.length == 0) {
            relativeFrequency = 1.0;
        } else if (predecessors.length == 1) {
            Block pred = predecessors[0];
            relativeFrequency = pred.relativeFrequency;
            if (pred.getSuccessorCount() > 1) {
                assert (pred.getEndNode() instanceof ControlSplitNode);
                ControlSplitNode controlSplit = (ControlSplitNode)pred.getEndNode();
                relativeFrequency = ControlFlowGraph.multiplyRelativeFrequencies(relativeFrequency, controlSplit.probability(b.getBeginNode()));
                if (computingLocalLoopFrequencies) {
                    source = controlSplit.getProfileData().getProfileSource();
                }
            }
        } else {
            relativeFrequency = predecessors[0].relativeFrequency;
            for (int i = 1; i < predecessors.length; ++i) {
                relativeFrequency += predecessors[i].relativeFrequency;
                if (!computingLocalLoopFrequencies || predecessors[i].frequencySource == null) continue;
                source = source.combine(predecessors[i].frequencySource);
            }
            if (b.getBeginNode() instanceof LoopBeginNode) {
                if (computingLocalLoopFrequencies) {
                    relativeFrequency = 1.0;
                    source = ProfileData.ProfileSource.UNKNOWN;
                } else {
                    LoopBeginNode loopBegin = (LoopBeginNode)b.getBeginNode();
                    relativeFrequency = ControlFlowGraph.multiplyRelativeFrequencies(relativeFrequency, ((ProfileData.LoopFrequencyData)this.localLoopFrequencyData.get((Object)loopBegin)).getLoopFrequency());
                }
            }
        }
        if (relativeFrequency < 3.054936363499605E-151) {
            relativeFrequency = 3.054936363499605E-151;
        } else if (relativeFrequency > 3.273390607896142E150) {
            relativeFrequency = 3.273390607896142E150;
        }
        b.setRelativeFrequency(relativeFrequency);
        if (computingLocalLoopFrequencies) {
            b.setFrequencySource(source);
        }
    }

    private void computeFrequencies() {
        this.localLoopFrequencyData = EconomicMap.create();
        this.computeLocalLoopFrequencies();
        this.resetBlockFrequencies();
        this.computeFrequenciesFromLocal();
        if (Assertions.assertionsEnabled()) {
            for (Block block : this.reversePostOrder) {
                assert (block.getRelativeFrequency() >= 0.0) : "Must have a relative frequency set, block " + block;
            }
        }
    }

    private void computeLoopInformation() {
        this.loops = new ArrayList<Loop<Block>>();
        if (this.graph.hasLoops()) {
            Block[] stack = new Block[this.reversePostOrder.length];
            for (Block block : this.reversePostOrder) {
                AbstractBeginNode beginNode = block.getBeginNode();
                if (!(beginNode instanceof LoopBeginNode)) continue;
                Loop<Block> parent = block.getLoop();
                HIRLoop loop = new HIRLoop(parent, this.loops.size(), block);
                if (parent != null) {
                    parent.getChildren().add(loop);
                }
                this.loops.add(loop);
                block.setLoop(loop);
                loop.getBlocks().add(block);
                LoopBeginNode loopBegin = (LoopBeginNode)beginNode;
                for (LoopEndNode end : loopBegin.loopEnds()) {
                    Block[] endBlock = this.nodeToBlock.get(end);
                    ControlFlowGraph.computeLoopBlocks((Block)endBlock, loop, stack, true);
                }
                for (Block b : loop.getBlocks()) {
                    for (Block sux : (Block[])b.getSuccessors()) {
                        if (sux.getLoop() == loop) continue;
                        assert (sux.getLoopDepth() < loop.getDepth());
                        loop.getNaturalExits().add(sux);
                    }
                }
                loop.getNaturalExits().sort(AbstractBlockBase.BLOCK_ID_COMPARATOR);
                if (!this.graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    for (LoopExitNode exit : loopBegin.loopExits()) {
                        Block exitBlock = this.nodeToBlock.get(exit);
                        assert (exitBlock.getPredecessorCount() == 1);
                        ControlFlowGraph.computeLoopBlocks(exitBlock.getFirstPredecessor(), loop, stack, true);
                        loop.getLoopExits().add(exitBlock);
                    }
                    loop.getLoopExits().sort(AbstractBlockBase.BLOCK_ID_COMPARATOR);
                    int size = loop.getBlocks().size();
                    for (int i = 0; i < size; ++i) {
                        Block b = (Block)loop.getBlocks().get(i);
                        for (Block sux : (Block[])b.getSuccessors()) {
                            AbstractBeginNode begin;
                            if (sux.getLoop() == loop || loopBegin.isLoopExit(begin = sux.getBeginNode())) continue;
                            assert (!(begin instanceof LoopBeginNode));
                            assert (sux.getLoopDepth() < loop.getDepth());
                            this.graph.getDebug().log(3, "Unexpected loop exit with %s, including whole branch in the loop", (Object)sux);
                            ControlFlowGraph.computeLoopBlocks(sux, loop, stack, false);
                        }
                    }
                    continue;
                }
                loop.getLoopExits().addAll(loop.getNaturalExits());
            }
        }
    }

    private static void computeLoopBlocks(Block start, Loop<Block> loop, Block[] stack, boolean usePred) {
        if (start.getLoop() != loop) {
            start.setLoop(loop);
            stack[0] = start;
            loop.getBlocks().add(start);
            int tos = 0;
            do {
                Block block = stack[tos--];
                for (Block b : usePred ? (Block[])block.getPredecessors() : (Block[])block.getSuccessors()) {
                    if (b.getLoop() == loop) continue;
                    stack[++tos] = b;
                    b.setLoop(loop);
                    loop.getBlocks().add(b);
                }
            } while (tos >= 0);
        }
    }

    public void computePostdominators() {
        Block[] reversePostOrderTmp = this.reversePostOrder;
        block0: for (int j = reversePostOrderTmp.length - 1; j >= 0; --j) {
            Block block = reversePostOrderTmp[j];
            if (block.isLoopEnd() || block.getSuccessorCount() == 0) continue;
            Block firstSucc = ((Block[])block.getSuccessors())[0];
            if (block.getSuccessorCount() == 1) {
                block.postdominator = firstSucc;
                continue;
            }
            Block postdominator = firstSucc;
            for (Block sux : (Block[])block.getSuccessors()) {
                if ((postdominator = ControlFlowGraph.commonPostdominator(postdominator, sux)) == null) continue block0;
            }
            assert (!Arrays.asList((Block[])block.getSuccessors()).contains(postdominator)) : "Block " + block + " has a wrong post dominator: " + postdominator;
            block.setPostDominator(postdominator);
        }
    }

    private static Block commonPostdominator(Block a, Block b) {
        Block iterA = a;
        Block iterB = b;
        while (iterA != iterB) {
            if (iterA.getId() < iterB.getId()) {
                if ((iterA = iterA.getPostdominator()) != null) continue;
                return null;
            }
            assert (iterB.getId() < iterA.getId());
            if ((iterB = iterB.getPostdominator()) != null) continue;
            return null;
        }
        return iterA;
    }

    public void setNodeToBlock(NodeMap<Block> nodeMap) {
        this.nodeToBlock = nodeMap;
    }

    public static double multiplyRelativeFrequencies(double a, double b, double c) {
        return ControlFlowGraph.multiplyRelativeFrequencies(ControlFlowGraph.multiplyRelativeFrequencies(a, b), c);
    }

    public static double multiplyRelativeFrequencies(double a, double b) {
        assert (!Double.isNaN(a) && !Double.isNaN(b) && Double.isFinite(a) && Double.isFinite(b)) : a + " " + b;
        double r = a * b;
        if (r > 3.273390607896142E150) {
            return 3.273390607896142E150;
        }
        if (r < 3.054936363499605E-151) {
            return 3.054936363499605E-151;
        }
        return r;
    }

    private static class RPOLoopVerification {
        int endsVisited;
        int exitsVisited;
        LoopBeginNode lb;

        RPOLoopVerification(LoopBeginNode lb) {
            this.lb = lb;
        }

        boolean loopFullyProcessed() {
            return this.lb.getLoopEndCount() == this.endsVisited && this.exitsVisited == this.lb.loopExits().count();
        }

        boolean allEndsVisited() {
            return this.lb.getLoopEndCount() == this.endsVisited;
        }
    }

    public static final class DeferredExit {
        private final Block block;
        private final DeferredExit next;

        public DeferredExit(Block block, DeferredExit next) {
            this.block = block;
            this.next = next;
        }

        public Block getBlock() {
            return this.block;
        }

        public DeferredExit getNext() {
            return this.next;
        }
    }

    public static interface RecursiveVisitor<V> {
        public V enter(Block var1);

        public void exit(Block var1, V var2);
    }

    public static class CFGOptions {
        public static final OptionKey<Boolean> UseLoopEndFrequencies = new OptionKey<Boolean>(false);
        public static final OptionKey<Boolean> DumpEndVersusExitLoopFrequencies = new OptionKey<Boolean>(false);
        public static final OptionKey<Double> LoopExitVsLoopEndFrequencyDiff = new OptionKey<Double>(1000.0);
    }
}

