/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingIntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.SignedRemNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_1, shortName="%")
public class SignedFloatingIntegerRemNode
extends FloatingIntegerDivRemNode<ArithmeticOpTable.BinaryOp.Rem> {
    public static final NodeClass<SignedFloatingIntegerRemNode> TYPE = NodeClass.create(SignedFloatingIntegerRemNode.class);

    protected SignedFloatingIntegerRemNode(ValueNode x, ValueNode y) {
        super(TYPE, SignedFloatingIntegerRemNode.getArithmeticOpTable(x).getRem(), x, y, null);
    }

    protected SignedFloatingIntegerRemNode(ValueNode x, ValueNode y, GuardingNode floatingGuard) {
        super(TYPE, SignedFloatingIntegerRemNode.getArithmeticOpTable(x).getRem(), x, y, floatingGuard);
    }

    protected SignedFloatingIntegerRemNode(ValueNode x, ValueNode y, GuardingNode floatingGuard, boolean divisionOverflowIsJVMSCompliant) {
        super(TYPE, SignedFloatingIntegerRemNode.getArithmeticOpTable(x).getRem(), x, y, floatingGuard, divisionOverflowIsJVMSCompliant);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view, GuardingNode floatingGuard, boolean divisionOverflowIsJVMSCompliant) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Rem> op = ArithmeticOpTable.forStamp(x.stamp(view)).getRem();
        ConstantNode tryConstantFold = SignedFloatingIntegerRemNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return (ValueNode)new SignedFloatingIntegerRemNode(x, y, floatingGuard, divisionOverflowIsJVMSCompliant).canonical(null);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode v;
        NodeView view = NodeView.from(tool);
        if (forX.isConstant() && forY.isConstant()) {
            long yConst = forY.asJavaConstant().asLong();
            if (yConst == 0L) {
                if (this.floatingGuard == null) {
                    throw GraalError.shouldNotReachHere("Must have never been a floating rem");
                }
                return this;
            }
            return ConstantNode.forIntegerStamp(this.stamp, forX.asJavaConstant().asLong() % yConst);
        }
        if (forY.isConstant() && (v = SignedRemNode.canonical(this, this.stamp(view), forX, forY, view, tool)) != null) {
            return v;
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        assert (this.x.stamp(NodeView.DEFAULT) instanceof IntegerStamp);
        assert (this.y.stamp(NodeView.DEFAULT) instanceof IntegerStamp);
        builder.setResult(this, builder.getLIRGeneratorTool().getArithmetic().emitRem(builder.operand(this.getX()), builder.operand(this.getY()), null));
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Rem> getOp(ArithmeticOpTable table) {
        return table.getRem();
    }
}

