/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.SignedDivNode;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_1)
public abstract class FloatingIntegerDivRemNode<OP>
extends BinaryArithmeticNode<OP>
implements IterableNodeType,
GuardedNode,
Lowerable {
    public static final NodeClass<FloatingIntegerDivRemNode> TYPE = NodeClass.create(FloatingIntegerDivRemNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    protected GuardingNode floatingGuard;
    private boolean divisionOverflowIsJVMSCompliant;

    protected FloatingIntegerDivRemNode(NodeClass<? extends FloatingIntegerDivRemNode<OP>> c, ArithmeticOpTable.BinaryOp<OP> op, ValueNode x, ValueNode y, GuardingNode floatingGuard) {
        super(c, op, x, y);
        this.floatingGuard = floatingGuard;
    }

    protected FloatingIntegerDivRemNode(NodeClass<? extends FloatingIntegerDivRemNode<OP>> c, ArithmeticOpTable.BinaryOp<OP> op, ValueNode x, ValueNode y, GuardingNode floatingGuard, boolean divisionOverflowIsJVMSCompliant) {
        super(c, op, x, y);
        this.floatingGuard = floatingGuard;
        this.divisionOverflowIsJVMSCompliant = divisionOverflowIsJVMSCompliant;
    }

    @Override
    public GuardingNode getGuard() {
        return this.floatingGuard;
    }

    public void setDivisionOverflowIsJVMSCompliant() {
        this.divisionOverflowIsJVMSCompliant = true;
    }

    public boolean divisionOverflowIsJVMSCompliant() {
        return this.divisionOverflowIsJVMSCompliant;
    }

    @Override
    public void setGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.floatingGuard, guard);
        this.floatingGuard = guard;
    }

    protected boolean canDivideByZero() {
        IntegerStamp yStamp = (IntegerStamp)this.y.stamp(NodeView.DEFAULT);
        return yStamp.contains(0L);
    }

    private boolean overflowVisibleSideEffect() {
        return !SignedDivNode.divisionIsJVMSCompliant(this.x, this.y, this.divisionOverflowIsJVMSCompliant);
    }

    @Override
    public boolean verify() {
        boolean guardWillAlwaysDeopt = this.getGuard() != null && this.getGuard() instanceof GuardNode && ((GuardNode)this.getGuard()).willDeoptUnconditionally();
        boolean cannotDeopt = !this.canDivideByZero() && !this.overflowVisibleSideEffect();
        boolean isAfterStage = this.graph().isAfterStage(GraphState.StageFlag.FIXED_READS);
        GraalError.guarantee(guardWillAlwaysDeopt || cannotDeopt || isAfterStage, "Floating irem must never create an exception or trap");
        return super.verify();
    }
}

