/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the time of a loop", size=NodeSize.SIZE_64)
public final class EncodeArrayNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<EncodeArrayNode> TYPE = NodeClass.create(EncodeArrayNode.class);
    @Node.Input
    protected ValueNode src;
    @Node.Input
    protected ValueNode dst;
    @Node.Input
    protected ValueNode len;
    private final LIRGeneratorTool.CharsetName charset;

    public EncodeArrayNode(ValueNode src, ValueNode dst, ValueNode len, LIRGeneratorTool.CharsetName charset) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, (Stamp)StampFactory.forInteger(32, 0L, ((IntegerStamp)len.stamp(NodeView.DEFAULT)).upperBound()));
        this.src = src;
        this.dst = dst;
        this.len = len;
        this.charset = charset;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitEncodeArray(gen.operand(this.src), gen.operand(this.dst), gen.operand(this.len), this.charset));
    }
}

