/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import java.util.Optional;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.GuardedValueNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.MultiGuardNode;
import org.graalvm.compiler.nodes.loop.CountedLoopInfo;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.loop.MathUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Speculative;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.PostRunCanonicalizationPhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;

public class LoopPredicationPhase
extends PostRunCanonicalizationPhase<MidTierContext>
implements Speculative {
    private static final SpeculationReasonGroup LOOP_PREDICATION = new SpeculationReasonGroup("Loop Predication", BytecodePosition.class);

    public LoopPredicationPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
    }

    @Override
    public Optional<BasePhase.NotApplicable> canApply(GraphState graphState) {
        return BasePhase.NotApplicable.combineConstraints(super.canApply(graphState), BasePhase.NotApplicable.undefinedSpeculationLog(this, graphState), BasePhase.NotApplicable.notApplicableIf(!graphState.getGuardsStage().allowsFloatingGuards(), Optional.of(new BasePhase.NotApplicable("Floating guards must be allowed."))));
    }

    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        DebugContext debug = graph.getDebug();
        SpeculationLog speculationLog = graph.getSpeculationLog();
        if (graph.hasLoops() && context.getOptimisticOptimizations().useLoopLimitChecks(graph.getOptions())) {
            LoopsData data = context.getLoopsDataProvider().getLoopsData(graph);
            ControlFlowGraph cfg = data.getCFG();
            try (DebugContext.Scope s = debug.scope((Object)"predication", cfg);){
                for (LoopEx loop : data.loops()) {
                    if (!loop.loop().getChildren().isEmpty() || !loop.detectCounted()) continue;
                    FrameState state = loop.loopBegin().stateAfter();
                    BytecodePosition pos = new BytecodePosition(null, state.getMethod(), state.bci);
                    SpeculationLog.SpeculationReason reason = LOOP_PREDICATION.createSpeculationReason(pos);
                    if (!speculationLog.maySpeculate(reason)) continue;
                    CountedLoopInfo counted = loop.counted();
                    InductionVariable counter = counted.getLimitCheckedIV();
                    Condition condition = ((CompareNode)counted.getLimitTest().condition()).condition().asCondition();
                    boolean inverted = loop.counted().isInverted();
                    if (((IntegerStamp)counter.valueNode().stamp(NodeView.DEFAULT)).getBits() != 32 || counted.isUnsignedCheck() || (condition == Condition.NE || condition == Condition.EQ) && (!counter.isConstantStride() || Math.abs(counter.constantStride()) != 1L) || !loop.loopBegin().isMainLoop() && !loop.loopBegin().isSimpleLoop()) continue;
                    NodeIterable<GuardNode> guards = loop.whole().nodes().filter(GuardNode.class);
                    if (GraalOptions.LoopPredicationMainPath.getValue(graph.getOptions()).booleanValue()) {
                        NodeIterable<LoopEndNode> loopEndNodes = loop.loopBegin().loopEnds();
                        Block end = data.getCFG().commonDominatorFor(loopEndNodes);
                        guards = guards.filter(guard -> {
                            ValueNode anchor = ((GuardNode)guard).getAnchor().asNode();
                            Block anchorBlock = data.getCFG().getNodeToBlock().get(anchor);
                            return AbstractControlFlowGraph.dominates(anchorBlock, end);
                        });
                    }
                    AbstractBeginNode body = loop.counted().getBody();
                    Block bodyBlock = cfg.getNodeToBlock().get(body);
                    for (GuardNode guard2 : guards) {
                        AnchoringNode anchor = guard2.getAnchor();
                        Block anchorBlock = cfg.getNodeToBlock().get(anchor.asNode());
                        if (!inverted && !AbstractControlFlowGraph.dominates(bodyBlock, anchorBlock)) continue;
                        LoopPredicationPhase.processGuard(loop, guard2);
                    }
                }
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    private static void processGuard(LoopEx loop, GuardNode guard) {
        ValueNode x;
        LogicNode condition = guard.getCondition();
        if (!(condition instanceof IntegerBelowNode) || guard.isNegated()) {
            return;
        }
        IntegerBelowNode rangeCheck = (IntegerBelowNode)condition;
        ValueNode range = rangeCheck.getY();
        if (!loop.isOutsideLoop(range) || ((IntegerStamp)range.stamp(NodeView.DEFAULT)).lowerBound() < 0L) {
            return;
        }
        EconomicMap<Node, InductionVariable> inductionVariables = loop.getInductionVariables();
        if (!inductionVariables.containsKey((Object)(x = rangeCheck.getX()))) {
            return;
        }
        StructuredGraph graph = guard.graph();
        InductionVariable iv = (InductionVariable)inductionVariables.get((Object)x);
        Long scale = null;
        InductionVariable counter = loop.counted().getLimitCheckedIV();
        if (iv.isConstantScale(counter)) {
            scale = iv.constantScale(counter);
        }
        ValueNode offset = null;
        offset = iv.offsetIsZero(counter) ? (ValueNode)graph.unique(ConstantNode.forInt(0)) : iv.offsetNode(counter);
        if (offset == null || scale == null || !loop.isOutsideLoop(offset)) {
            return;
        }
        long scaleCon = scale;
        LoopPredicationPhase.replaceGuardNode(loop, guard, range, graph, scaleCon, offset);
    }

    private static void replaceGuardNode(LoopEx loop, GuardNode guard, ValueNode range, StructuredGraph graph, long scaleCon, ValueNode offset) {
        InductionVariable counter = loop.counted().getLimitCheckedIV();
        ValueNode rangeLong = IntegerConvertNode.convert(range, (Stamp)StampFactory.forInteger(64), graph, NodeView.DEFAULT);
        ValueNode extremumNode = counter.extremumNode(false, StampFactory.forInteger(64));
        GuardingNode overFlowGuard = loop.counted().createOverFlowGuard();
        assert (overFlowGuard != null || loop.counted().counterNeverOverflows());
        if (overFlowGuard != null) {
            extremumNode = graph.unique(new GuardedValueNode(extremumNode, overFlowGuard));
        }
        ValueNode upperNode = MathUtil.add(graph, MathUtil.mul(graph, extremumNode, ConstantNode.forLong(scaleCon, graph)), IntegerConvertNode.convert(offset, (Stamp)StampFactory.forInteger(64), graph, NodeView.DEFAULT));
        LogicNode upperCond = IntegerBelowNode.create(upperNode, rangeLong, NodeView.DEFAULT);
        ValueNode initNode = IntegerConvertNode.convert(loop.counted().getBodyIVStart(), (Stamp)StampFactory.forInteger(64), graph, NodeView.DEFAULT);
        ValueNode lowerNode = MathUtil.add(graph, MathUtil.mul(graph, initNode, ConstantNode.forLong(scaleCon, graph)), IntegerConvertNode.convert(offset, (Stamp)StampFactory.forInteger(64), graph, NodeView.DEFAULT));
        LogicNode lowerCond = IntegerBelowNode.create(lowerNode, rangeLong, NodeView.DEFAULT);
        FrameState state = loop.loopBegin().stateAfter();
        BytecodePosition pos = new BytecodePosition(null, state.getMethod(), state.bci);
        SpeculationLog.SpeculationReason reason = LOOP_PREDICATION.createSpeculationReason(pos);
        SpeculationLog.Speculation speculation = graph.getSpeculationLog().speculate(reason);
        AbstractBeginNode anchor = AbstractBeginNode.prevBegin(loop.entryPoint());
        GuardNode upperGuard = graph.addOrUniqueWithInputs(new GuardNode(upperCond, anchor, guard.getReason(), guard.getAction(), guard.isNegated(), speculation, null));
        GuardNode lowerGuard = graph.addOrUniqueWithInputs(new GuardNode(lowerCond, anchor, guard.getReason(), guard.getAction(), guard.isNegated(), speculation, null));
        GuardingNode combinedGuard = MultiGuardNode.combine(lowerGuard, upperGuard);
        guard.replaceAtUsagesAndDelete(combinedGuard.asNode());
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }
}

