/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.gen;

import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;

public abstract class MoveFactory {
    public boolean mayEmbedConstantLoad(Constant constant) {
        return false;
    }

    public abstract boolean canInlineConstant(Constant var1);

    public abstract boolean allowConstantToStackMove(Constant var1);

    public abstract LIRInstruction createMove(AllocatableValue var1, Value var2);

    public abstract LIRInstruction createStackMove(AllocatableValue var1, AllocatableValue var2);

    public abstract LIRInstruction createLoad(AllocatableValue var1, Constant var2);

    public abstract LIRInstruction createStackLoad(AllocatableValue var1, Constant var2);

    public static final class BackupSlotProvider {
        private final FrameMapBuilder frameMapBuilder;
        private EconomicMap<PlatformKind.Key, RegisterBackupPair> categorized;

        public BackupSlotProvider(FrameMapBuilder frameMapBuilder) {
            this.frameMapBuilder = frameMapBuilder;
        }

        public RegisterBackupPair getScratchRegister(PlatformKind kind) {
            PlatformKind.Key key = kind.getKey();
            if (this.categorized == null) {
                this.categorized = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            } else if (this.categorized.containsKey((Object)key)) {
                return (RegisterBackupPair)this.categorized.get((Object)key);
            }
            RegisterConfig registerConfig = this.frameMapBuilder.getRegisterConfig();
            RegisterArray availableRegister = registerConfig.filterAllocatableRegisters(kind, registerConfig.getAllocatableRegisters());
            assert (availableRegister != null && availableRegister.size() > 1);
            Register scratchRegister = availableRegister.get(0);
            Architecture arch = this.frameMapBuilder.getCodeCache().getTarget().arch;
            LIRKind largestKind = LIRKind.value(arch.getLargestStorableKind(scratchRegister.getRegisterCategory()));
            VirtualStackSlot backupSlot = this.frameMapBuilder.allocateSpillSlot(largestKind);
            RegisterBackupPair value = new RegisterBackupPair(scratchRegister, backupSlot);
            this.categorized.put((Object)key, (Object)value);
            return value;
        }
    }

    public static class RegisterBackupPair {
        public final Register register;
        public final VirtualStackSlot backupSlot;

        RegisterBackupPair(Register register, VirtualStackSlot backupSlot) {
            this.register = register;
            this.backupSlot = backupSlot;
        }
    }
}

