/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64.vector;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.vector.AMD64VectorInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64VectorBinary {

    public static final class AVXBinaryMemoryOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXBinaryMemoryOp> TYPE = LIRInstructionClass.create(AVXBinaryMemoryOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue y;
        @LIRInstruction.State
        protected LIRFrameState state;

        public AVXBinaryMemoryOp(AMD64Assembler.VexRVMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, AMD64AddressValue y, LIRFrameState state) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), this.y.toAddress());
        }
    }

    public static final class AVXBinaryConstFloatOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXBinaryConstFloatOp> TYPE = LIRInstructionClass.create(AVXBinaryConstFloatOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        protected ConstantValue y;

        public AVXBinaryConstFloatOp(AMD64Assembler.VexRVMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, ConstantValue y) {
            super(TYPE, size);
            assert (y.getPlatformKind() == AMD64Kind.SINGLE || y.getPlatformKind() == AMD64Kind.DOUBLE);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.y.getPlatformKind() == AMD64Kind.SINGLE) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asFloatConstRef(this.y.getJavaConstant(), this.opcode.isPacked() ? AMD64BaseAssembler.OperandSize.PS.getBytes() : 4));
            } else {
                assert (this.y.getPlatformKind() == AMD64Kind.DOUBLE);
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asDoubleConstRef(this.y.getJavaConstant(), this.opcode.isPacked() ? AMD64BaseAssembler.OperandSize.PD.getBytes() : 8));
            }
        }
    }

    public static final class AVXBinaryConstOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXBinaryConstOp> TYPE = LIRInstructionClass.create(AVXBinaryConstOp.class);
        @Opcode
        private final AMD64Assembler.VexRRIOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        protected int y;

        public AVXBinaryConstOp(AMD64Assembler.VexRRIOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, int y) {
            super(TYPE, size);
            assert ((y & 0xFF) == y);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            this.opcode.emit(masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), this.y);
        }
    }

    public static final class AVXBinaryOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXBinaryOp> TYPE = LIRInstructionClass.create(AVXBinaryOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue y;

        public AVXBinaryOp(AMD64Assembler.VexRVMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.y)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
            } else {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y));
            }
        }
    }
}

