/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.CompositeValue;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIRInstruction;

public final class AArch64AddressValue
extends CompositeValue {
    private static final EnumSet<LIRInstruction.OperandFlag> flags = EnumSet.of(LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL);
    @CompositeValue.Component(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected AllocatableValue base;
    @CompositeValue.Component(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected AllocatableValue offset;
    private final int bitMemoryTransferSize;
    private final int displacement;
    private final int scaleFactor;
    private final AArch64Address.AddressingMode addressingMode;

    public AArch64AddressValue(ValueKind<?> kind, int bitMemoryTransferSize, AllocatableValue base, AllocatableValue offset, int displacement, int scaleFactor, AArch64Address.AddressingMode addressingMode) {
        super(kind);
        assert (scaleFactor == 1 || bitMemoryTransferSize / 8 == scaleFactor);
        this.bitMemoryTransferSize = bitMemoryTransferSize;
        this.base = base;
        this.offset = offset;
        this.displacement = displacement;
        this.scaleFactor = scaleFactor;
        this.addressingMode = addressingMode;
    }

    public static AArch64AddressValue makeAddress(ValueKind<?> kind, int bitMemoryTransferSize, AllocatableValue base) {
        return AArch64AddressValue.makeAddress(kind, bitMemoryTransferSize, base, 0);
    }

    public static AArch64AddressValue makeAddress(ValueKind<?> kind, int bitMemoryTransferSize, AllocatableValue base, int displacement) {
        AArch64Address.AddressingMode mode;
        assert (displacement == 0 || bitMemoryTransferSize == 8 || bitMemoryTransferSize == 16 || bitMemoryTransferSize == 32 || bitMemoryTransferSize == 64 || bitMemoryTransferSize == 128);
        if (displacement == 0) {
            return new AArch64AddressValue(kind, bitMemoryTransferSize, base, Value.ILLEGAL, 0, 1, AArch64Address.AddressingMode.BASE_REGISTER_ONLY);
        }
        int byteMemoryTransferSize = bitMemoryTransferSize / 8;
        boolean canScale = displacement >= 0 && AArch64Address.isOffsetAligned(bitMemoryTransferSize, displacement);
        AArch64Address.AddressingMode addressingMode = mode = canScale ? AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED : AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED;
        if (AArch64Address.isValidImmediateAddress(bitMemoryTransferSize, mode, displacement)) {
            int scalingFactor = AArch64Address.isImmediateScaled(mode) ? byteMemoryTransferSize : 1;
            return new AArch64AddressValue(kind, bitMemoryTransferSize, base, Value.ILLEGAL, displacement, scalingFactor, mode);
        }
        throw GraalError.shouldNotReachHere("Could not create AddressValue with requested displacement.");
    }

    private static Register toRegister(AllocatableValue value) {
        if (value.equals((Object)Value.ILLEGAL)) {
            return AArch64.zr;
        }
        return ((RegisterValue)value).getRegister();
    }

    public AllocatableValue getBase() {
        return this.base;
    }

    public AllocatableValue getOffset() {
        return this.offset;
    }

    public int getDisplacement() {
        return this.displacement;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public AArch64Address.AddressingMode getAddressingMode() {
        return this.addressingMode;
    }

    public int getBitMemoryTransferSize() {
        return this.bitMemoryTransferSize;
    }

    public AArch64Address toAddress() {
        assert (this.addressingMode != AArch64Address.AddressingMode.EXTENDED_REGISTER_OFFSET);
        Register baseReg = AArch64AddressValue.toRegister(this.base);
        Register offsetReg = AArch64AddressValue.toRegister(this.offset);
        boolean registerOffsetScaled = this.addressingMode == AArch64Address.AddressingMode.REGISTER_OFFSET && this.scaleFactor > 1;
        return AArch64Address.createAddress(this.bitMemoryTransferSize, this.addressingMode, baseReg, offsetReg, this.displacement / this.scaleFactor, registerOffsetScaled, null);
    }

    @Override
    public CompositeValue forEachComponent(LIRInstruction inst, LIRInstruction.OperandMode mode, InstructionValueProcedure proc) {
        AllocatableValue newBase = (AllocatableValue)proc.doValue(inst, (Value)this.base, mode, flags);
        AllocatableValue newOffset = (AllocatableValue)proc.doValue(inst, (Value)this.offset, mode, flags);
        if (!this.base.identityEquals((Value)newBase) || !this.offset.identityEquals((Value)newOffset)) {
            return new AArch64AddressValue(this.getValueKind(), this.bitMemoryTransferSize, newBase, newOffset, this.displacement, this.scaleFactor, this.addressingMode);
        }
        return this;
    }

    @Override
    protected void visitEachComponent(LIRInstruction inst, LIRInstruction.OperandMode mode, InstructionValueConsumer proc) {
        proc.visitValue(inst, (Value)this.base, mode, flags);
        proc.visitValue(inst, (Value)this.offset, mode, flags);
    }
}

