/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.code.Register;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.stubs.CreateExceptionStub;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.options.OptionValues;

public class ClassCastExceptionStub
extends CreateExceptionStub {
    public ClassCastExceptionStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super("createClassCastException", options, providers, linkage);
    }

    @Override
    protected Object getConstantParameterValue(int index, String name) {
        GraalError.guarantee(index == 2, "unknown parameter %s at index %d", (Object)name, (Object)index);
        return this.providers.getRegisters().getThreadRegister();
    }

    @Snippet
    private static Object createClassCastException(@Snippet.NonNullParameter Object object, KlassPointer targetKlass, @Snippet.ConstantParameter Register threadRegister) {
        KlassPointer objKlass = HotSpotReplacementsUtil.loadHub(object);
        if (targetKlass.isNull()) {
            return ClassCastExceptionStub.createException(threadRegister, ClassCastException.class, objKlass);
        }
        return ClassCastExceptionStub.createException(threadRegister, ClassCastException.class, objKlass, targetKlass);
    }
}

