/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.Random;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.core.phases.fuzzing.FuzzedSuites;
import org.graalvm.compiler.hotspot.meta.HotSpotSuitesProvider;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.Suites;

public class HotSpotFuzzedSuitesProvider
extends HotSpotSuitesProvider {
    private static ThreadLocal<Long> lastSeed = new ThreadLocal();
    private final HotSpotSuitesProvider provider;
    private final Random random;

    public HotSpotFuzzedSuitesProvider(HotSpotSuitesProvider provider) {
        super(provider.defaultSuitesCreator, provider.config, provider.runtime);
        this.provider = provider;
        this.random = new Random();
    }

    @Override
    public Suites getDefaultSuites(OptionValues options, Architecture arch) {
        long seed = this.random.nextLong();
        lastSeed.set(seed);
        return this.createSuites(options, seed);
    }

    public FuzzedSuites getLastSuitesForThread(OptionValues options) {
        return this.createSuites(options, lastSeed.get());
    }

    private FuzzedSuites createSuites(OptionValues options, long seed) {
        return FuzzedSuites.createFuzzedSuites(this.getOriginalSuites(options), GraphState.defaultGraphState(), GraphState.MandatoryStages.getFromName(this.runtime.getCompilerConfigurationName()), seed);
    }

    private Suites getOriginalSuites(OptionValues options) {
        return this.provider.getDefaultSuites(options, this.provider.runtime.getTarget().arch);
    }
}

