/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.lir.amd64.AMD64CalcStringAttributesOp;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayRegionEqualsWithMaskNode;
import org.graalvm.compiler.replacements.amd64.AMD64CalcStringAttributesNode;
import org.graalvm.word.Pointer;

public class AMD64HotspotIntrinsicStubsGen
extends SnippetStub {
    public AMD64HotspotIntrinsicStubsGen(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(linkage.getDescriptor().getName(), options, providers, linkage);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS1S2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S1, Stride.S2, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS2S2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S2, Stride.S2, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS1S1(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S1, Stride.S1, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS1S2(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S1, Stride.S2, Stride.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS1S4(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S1, Stride.S4, Stride.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S2, Stride.S1, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS2S2(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S2, Stride.S2, Stride.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS2S4(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S2, Stride.S4, Stride.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS4S1(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S4, Stride.S1, Stride.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS4S2(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S4, Stride.S2, Stride.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskS4S4(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, Stride.S4, Stride.S4, Stride.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsWithMaskDynamicStrides(Object arrayA, long offsetA, Object arrayB, long offsetB, Pointer mask, int length, int stride) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, stride);
    }

    @Snippet
    private static int calcStringAttributesLatin1(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.intReturnValue(array, offset, length, AMD64CalcStringAttributesOp.Op.LATIN1, false);
    }

    @Snippet
    private static int calcStringAttributesBMP(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.intReturnValue(array, offset, length, AMD64CalcStringAttributesOp.Op.BMP, false);
    }

    @Snippet
    private static int calcStringAttributesUTF32(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.intReturnValue(array, offset, length, AMD64CalcStringAttributesOp.Op.UTF_32, false);
    }

    @Snippet
    private static long calcStringAttributesUTF8Valid(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.longReturnValue(array, offset, length, AMD64CalcStringAttributesOp.Op.UTF_8, true);
    }

    @Snippet
    private static long calcStringAttributesUTF8Unknown(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.longReturnValue(array, offset, length, AMD64CalcStringAttributesOp.Op.UTF_8, false);
    }

    @Snippet
    private static long calcStringAttributesUTF16Valid(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.longReturnValue(array, offset, length, AMD64CalcStringAttributesOp.Op.UTF_16, true);
    }

    @Snippet
    private static long calcStringAttributesUTF16Unknown(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.longReturnValue(array, offset, length, AMD64CalcStringAttributesOp.Op.UTF_16, false);
    }
}

