/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="PATCH_RETURN")
final class AMD64HotSpotPatchReturnAddressOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64HotSpotPatchReturnAddressOp> TYPE = LIRInstructionClass.create(AMD64HotSpotPatchReturnAddressOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue address;

    AMD64HotSpotPatchReturnAddressOp(AllocatableValue address) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.address = address;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        int returnAddressOffset = crb.frameMap.totalFrameSize() - masm.getReturnAddressSize();
        masm.movq(new AMD64Address(AMD64.rsp, returnAddressOffset), ValueUtil.asRegister((Value)this.address));
    }
}

