/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="CRUNTIME_CALL_EPILOGUE")
public class AArch64HotSpotCRuntimeCallEpilogueOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64HotSpotCRuntimeCallEpilogueOp> TYPE = LIRInstructionClass.create(AArch64HotSpotCRuntimeCallEpilogueOp.class);
    private final int threadLastJavaSpOffset;
    private final int threadLastJavaPcOffset;
    private final Register thread;
    private final Label label;

    public AArch64HotSpotCRuntimeCallEpilogueOp(int threadLastJavaSpOffset, int threadLastJavaPcOffset, Register thread, Label label) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.threadLastJavaSpOffset = threadLastJavaSpOffset;
        this.threadLastJavaPcOffset = threadLastJavaPcOffset;
        this.thread = thread;
        this.label = label;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        masm.str(64, AArch64.zr, masm.makeAddress(64, this.thread, this.threadLastJavaSpOffset));
        masm.str(64, AArch64.zr, masm.makeAddress(64, this.thread, this.threadLastJavaPcOffset));
    }
}

