/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigAccess;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.options.OptionValues;

public class GraalHotSpotVMConfig
extends GraalHotSpotVMConfigAccess {
    public static final GraalHotSpotVMConfig INJECTED_VMCONFIG = null;
    public static final MetaAccessProvider INJECTED_METAACCESS = null;
    public static final OptionValues INJECTED_OPTIONVALUES = null;
    public static final IntrinsicContext INJECTED_INTRINSIC_CONTEXT = null;
    private final CompressEncoding oopEncoding;
    private final CompressEncoding klassEncoding;
    private final String markWord;
    private final boolean gr21761;
    private final boolean jdk13Backport;
    public final boolean cAssertions;
    public final int codeEntryAlignment;
    public final boolean verifyOops;
    public final boolean dontCompileHugeMethods;
    public final int hugeMethodLimit;
    public final boolean printInlining;
    public final boolean inline;
    public final boolean inlineNotify = true;
    public final boolean useFastLocking;
    public final boolean forceUnreachable;
    public final boolean foldStableValues;
    public final int maxVectorSize;
    public final boolean verifyBeforeGC;
    public final boolean verifyAfterGC;
    public final boolean useTLAB;
    public final boolean useBiasedLocking;
    public final boolean usePopCountInstruction;
    public final boolean useUnalignedAccesses;
    public final boolean useAESIntrinsics;
    public final boolean useAESCTRIntrinsics;
    public final boolean useCRC32Intrinsics;
    public final boolean useCRC32CIntrinsics;
    public final boolean useThreadLocalPolling;
    private final boolean useMultiplyToLenIntrinsic;
    private final boolean useSHA1Intrinsics;
    private final boolean useSHA256Intrinsics;
    private final boolean useSHA512Intrinsics;
    private final boolean useGHASHIntrinsics;
    private final boolean useMontgomeryMultiplyIntrinsic;
    private final boolean useMontgomerySquareIntrinsic;
    private final boolean useMulAddIntrinsic;
    private final boolean useSquareToLenIntrinsic;
    public final boolean useVectorizedMismatchIntrinsic;
    public final boolean useFMAIntrinsics;
    public final int useAVX3Threshold;
    public final boolean preserveFramePointer;
    public final int diagnoseSyncOnValueBasedClasses;
    public final boolean useG1GC;
    public final boolean useCMSGC;
    public final int allocatePrefetchStyle;
    public final int allocatePrefetchInstr;
    public final int allocatePrefetchLines;
    public final int allocateInstancePrefetchLines;
    public final int allocatePrefetchStepSize;
    public final int allocatePrefetchDistance;
    private final long universeCollectedHeap;
    private final int collectedHeapTotalCollectionsOffset;
    public final boolean useDeferredInitBarriers;
    public final boolean useCompressedOops;
    public final boolean useCompressedClassPointers;
    public final long narrowOopBase;
    public final int narrowOopShift;
    public final int objectAlignment;
    public final int narrowKlassSize;
    public final long narrowKlassBase;
    public final int narrowKlassShift;
    public final int logKlassAlignment;
    public final int stackShadowPages;
    public final boolean useStackBanging;
    public final int stackBias;
    public final int vmPageSize;
    public final int markOffset;
    public final int hubOffset;
    public final int prototypeMarkWordOffset;
    public final int superCheckOffsetOffset;
    public final int secondarySuperCacheOffset;
    public final int secondarySupersOffset;
    public final boolean classMirrorIsHandle;
    public final int classMirrorOffset;
    public final int klassSuperKlassOffset;
    public final int klassModifierFlagsOffset;
    public final int klassAccessFlagsOffset;
    public final int klassLayoutHelperOffset;
    public final int klassLayoutHelperNeutralValue;
    public final int layoutHelperLog2ElementSizeShift;
    public final int layoutHelperLog2ElementSizeMask;
    public final int layoutHelperHeaderSizeShift;
    public final int layoutHelperHeaderSizeMask;
    public final int instanceKlassInitStateOffset;
    public final int instanceKlassInitThreadOffset;
    public final int instanceKlassStateBeingInitialized;
    public final int instanceKlassStateFullyInitialized;
    public final int arrayOopDescSize;
    public final int metaspaceArrayLengthOffset;
    public final int metaspaceArrayBaseOffset;
    public final int arrayClassElementOffset;
    public final int jvmAccHasFinalizer;
    public final int jvmAccWrittenFlags;
    public final int jvmAccIsHiddenClass;
    public final int jvmAccIsValueBasedClass;
    public final int jvmciCompileStateCanPostOnExceptionsOffset;
    public final int jvmciCompileStateCanPopFrameOffset;
    public final int jvmciCompileStateCanAccessLocalVariablesOffset;
    public final int threadTlabOffset;
    public final int javaThreadAnchorOffset;
    public final int javaThreadShouldPostOnExceptionsFlagOffset;
    public final boolean threadObjectFieldIsHandle;
    public final int threadCurrentThreadObjectOffset;
    public final int osThreadOffset;
    public final int threadObjectResultOffset;
    public final int jvmciCountersThreadOffset;
    public final int jvmciReserved0Offset;
    public final int jvmciReservedReference0Offset;
    public final int doingUnsafeAccessOffset;
    public final int javaThreadReservedStackActivationOffset;
    public final int jniEnvironmentOffset;
    public final int threadExceptionOopOffset;
    public final int threadExceptionPcOffset;
    public final int pendingExceptionOffset;
    public final int pendingDeoptimizationOffset;
    public final int pendingTransferToInterpreterOffset;
    private final int javaFrameAnchorLastJavaSpOffset;
    private final int javaFrameAnchorLastJavaPcOffset;
    public final int pendingFailedSpeculationOffset;
    public final int frameInterpreterFrameSenderSpOffset;
    public final int frameInterpreterFrameLastSpOffset;
    public final int osThreadInterruptedOffset;
    public final int biasedLockMaskInPlace;
    public final int ageMaskInPlace;
    public final int epochMaskInPlace;
    public final int unlockedMask;
    public final int monitorMask;
    public final int biasedLockPattern;
    public final int objectMonitorOwner;
    public final int objectMonitorRecursions;
    public final int objectMonitorCxq;
    public final int objectMonitorEntryList;
    public final int objectMonitorSucc;
    public final int markWordNoHashInPlace;
    public final int markWordNoLockInPlace;
    public final int identityHashCodeShift;
    public final int uninitializedIdentityHashCodeValue;
    public final int methodCompiledEntryOffset;
    public final int invocationCounterOffset;
    public final int backedgeCounterOffset;
    public final int invocationCounterIncrement;
    public final int invocationCounterShift;
    public final int compilationLevelFullOptimization;
    public final int heapWordSize;
    public final long nonOopBits;
    public final long verifyOopCounterAddress;
    public final long verifyOopMask;
    public final long verifyOopBits;
    public final int logOfHRGrainBytes;
    public final int cardtableShift;
    public final long cardtableStartAddress;
    public final int maxOopMapStackOffset;
    public final long safepointPollingAddress;
    public final byte dirtyCardValue;
    public final byte g1YoungCardValue;
    public final int g1SATBQueueMarkingActiveOffset;
    public final int g1SATBQueueIndexOffset;
    public final int g1SATBQueueBufferOffset;
    public final int g1CardQueueIndexOffset;
    public final int g1CardQueueBufferOffset;
    public final int klassOffset;
    public final int arrayKlassOffset;
    public final int basicLockSize;
    public final int basicLockDisplacedHeaderOffset;
    public final int threadPollingPageOffset;
    private final int threadLocalAllocBufferEndOffset;
    private final int threadLocalAllocBufferTopOffset;
    public final int psrInfoDczidValue;
    public final int zvaLength;
    public final long inlineCacheMissStub;
    public final long handleWrongMethodStub;
    public final long deoptBlobUnpack;
    public final long deoptBlobUnpackWithExceptionInTLS;
    public final long deoptBlobUncommonTrap;
    public final long codeCacheLowBound;
    public final long codeCacheHighBound;
    public final long aescryptEncryptBlockStub;
    public final long aescryptDecryptBlockStub;
    public final long cipherBlockChainingEncryptAESCryptStub;
    public final long cipherBlockChainingDecryptAESCryptStub;
    public final long updateBytesCRC32Stub;
    public final long crcTableAddress;
    public final long md5ImplCompress;
    public final long md5ImplCompressMultiBlock;
    public final long sha1ImplCompress;
    public final long sha1ImplCompressMultiBlock;
    public final long sha256ImplCompress;
    public final long sha256ImplCompressMultiBlock;
    public final long sha512ImplCompress;
    public final long sha512ImplCompressMultiBlock;
    public final long sha3ImplCompress;
    public final long sha3ImplCompressMultiBlock;
    public final long multiplyToLen;
    public final long counterModeAESCrypt;
    public final long ghashProcessBlocks;
    public final long base64EncodeBlock;
    public final long base64DecodeBlock;
    public final long crc32cTableTddr;
    public final long updateBytesCRC32C;
    public final long updateBytesAdler32;
    public final long squareToLen;
    public final long mulAdd;
    public final long montgomeryMultiply;
    public final long montgomerySquare;
    public final long vectorizedMismatch;
    public final long bigIntegerLeftShiftWorker;
    public final long bigIntegerRightShiftWorker;
    public final long electronicCodeBookEncrypt;
    public final long electronicCodeBookDecrypt;
    public final long throwDelayedStackOverflowErrorEntry;
    public final long jbyteArraycopy;
    public final long jshortArraycopy;
    public final long jintArraycopy;
    public final long jlongArraycopy;
    public final long oopArraycopy;
    public final long oopArraycopyUninit;
    public final long jbyteDisjointArraycopy;
    public final long jshortDisjointArraycopy;
    public final long jintDisjointArraycopy;
    public final long jlongDisjointArraycopy;
    public final long oopDisjointArraycopy;
    public final long oopDisjointArraycopyUninit;
    public final long jbyteAlignedArraycopy;
    public final long jshortAlignedArraycopy;
    public final long jintAlignedArraycopy;
    public final long jlongAlignedArraycopy;
    public final long oopAlignedArraycopy;
    public final long oopAlignedArraycopyUninit;
    public final long jbyteAlignedDisjointArraycopy;
    public final long jshortAlignedDisjointArraycopy;
    public final long jintAlignedDisjointArraycopy;
    public final long jlongAlignedDisjointArraycopy;
    public final long oopAlignedDisjointArraycopy;
    public final long oopAlignedDisjointArraycopyUninit;
    public final long checkcastArraycopy;
    public final long checkcastArraycopyUninit;
    public final long unsafeArraycopy;
    public final long genericArraycopy;
    public final long contDoYield;
    public final long newInstanceAddress;
    public final long newArrayAddress;
    public final long newMultiArrayAddress;
    public final long dynamicNewInstanceAddress;
    public final long newInstanceOrNullAddress;
    public final long newArrayOrNullAddress;
    public final long newMultiArrayOrNullAddress;
    public final long dynamicNewInstanceOrNullAddress;
    public final long invokeJavaMethodAddress;
    public final long vmMessageAddress;
    public final long identityHashCodeAddress;
    public final long exceptionHandlerForPcAddress;
    public final long monitorenterAddress;
    public final long monitorexitAddress;
    public final long notifyAddress;
    public final long notifyAllAddress;
    public final long throwAndPostJvmtiExceptionAddress;
    public final long throwKlassExternalNameExceptionAddress;
    public final long throwClassCastExceptionAddress;
    public final long logPrimitiveAddress;
    public final long logObjectAddress;
    public final long logPrintfAddress;
    public final long vmErrorAddress;
    public final long loadAndClearExceptionAddress;
    public final long writeBarrierPreAddress;
    public final long writeBarrierPostAddress;
    public final long validateObject;
    public final long testDeoptimizeCallInt;
    public final long registerFinalizerAddress;
    public final long exceptionHandlerForReturnAddressAddress;
    public final long osrMigrationEndAddress;
    public final long enableStackReservedZoneAddress;
    public final long javaTimeMillisAddress;
    public final long javaTimeNanosAddress;
    public final long arithmeticSinAddress;
    public final long arithmeticCosAddress;
    public final long arithmeticTanAddress;
    public final long arithmeticExpAddress;
    public final long arithmeticLogAddress;
    public final long arithmeticLog10Address;
    public final long arithmeticPowAddress;
    public final long fremAddress;
    public final long dremAddress;
    public final int jvmciCountersSize;
    public final boolean deoptimizationSupportLargeAccessByteArrayVirtualization;
    private static final boolean JDK_8245443 = JDK == 11 && JDK_UPDATE >= 8 || JDK >= 15;
    public final int VMINTRINSIC_FIRST_MH_SIG_POLY;
    public final int VMINTRINSIC_LAST_MH_SIG_POLY;
    public final int VMINTRINSIC_INVOKE_GENERIC;
    public final int VMINTRINSIC_COMPILED_LAMBDA_FORM;
    public final boolean CPU_HAS_INTEL_JCC_ERRATUM;

    GraalHotSpotVMConfig(HotSpotVMConfigStore store) {
        super(store);
        int offset;
        String string = this.markWord = JDK < 14 ? "markOop" : "markWord";
        boolean bl = JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_20_0_b03) : (this.gr21761 = JDK >= 15);
        this.jdk13Backport = JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_19_3_b03) : JDK >= 13;
        this.cAssertions = this.getConstant("ASSERT", Boolean.class);
        this.codeEntryAlignment = this.getFlag("CodeEntryAlignment", Integer.class);
        this.verifyOops = this.getFlag("VerifyOops", Boolean.class);
        this.dontCompileHugeMethods = this.getFlag("DontCompileHugeMethods", Boolean.class);
        this.hugeMethodLimit = this.getFlag("HugeMethodLimit", Integer.class);
        this.printInlining = this.getFlag("PrintInlining", Boolean.class);
        this.inline = this.getFlag("Inline", Boolean.class);
        this.inlineNotify = true;
        this.useFastLocking = this.getFlag("JVMCIUseFastLocking", Boolean.class);
        this.forceUnreachable = this.getFlag("ForceUnreachable", Boolean.class);
        this.foldStableValues = this.getFlag("FoldStableValues", Boolean.class);
        this.maxVectorSize = this.getFlag("MaxVectorSize", Integer.class);
        this.verifyBeforeGC = this.getFlag("VerifyBeforeGC", Boolean.class);
        this.verifyAfterGC = this.getFlag("VerifyAfterGC", Boolean.class);
        this.useTLAB = this.getFlag("UseTLAB", Boolean.class);
        this.useBiasedLocking = this.getFlag("UseBiasedLocking", Boolean.class, false, JDK < 18);
        this.usePopCountInstruction = this.getFlag("UsePopCountInstruction", Boolean.class);
        this.useUnalignedAccesses = this.getFlag("UseUnalignedAccesses", Boolean.class);
        this.useAESIntrinsics = this.getFlag("UseAESIntrinsics", Boolean.class);
        this.useAESCTRIntrinsics = this.getFlag("UseAESCTRIntrinsics", Boolean.class);
        this.useCRC32Intrinsics = this.getFlag("UseCRC32Intrinsics", Boolean.class);
        this.useCRC32CIntrinsics = this.getFlag("UseCRC32CIntrinsics", Boolean.class);
        this.useThreadLocalPolling = JDK >= 14 ? true : (JDK >= 10 ? this.getFlag("ThreadLocalHandshakes", Boolean.class) : false);
        this.useMultiplyToLenIntrinsic = this.getFlag("UseMultiplyToLenIntrinsic", Boolean.class);
        this.useSHA1Intrinsics = this.getFlag("UseSHA1Intrinsics", Boolean.class);
        this.useSHA256Intrinsics = this.getFlag("UseSHA256Intrinsics", Boolean.class);
        this.useSHA512Intrinsics = this.getFlag("UseSHA512Intrinsics", Boolean.class);
        this.useGHASHIntrinsics = this.getFlag("UseGHASHIntrinsics", Boolean.class);
        this.useMontgomeryMultiplyIntrinsic = this.getFlag("UseMontgomeryMultiplyIntrinsic", Boolean.class);
        this.useMontgomerySquareIntrinsic = this.getFlag("UseMontgomerySquareIntrinsic", Boolean.class);
        this.useMulAddIntrinsic = this.getFlag("UseMulAddIntrinsic", Boolean.class);
        this.useSquareToLenIntrinsic = this.getFlag("UseSquareToLenIntrinsic", Boolean.class);
        this.useVectorizedMismatchIntrinsic = this.getFlag("UseVectorizedMismatchIntrinsic", Boolean.class);
        this.useFMAIntrinsics = this.getFlag("UseFMA", Boolean.class);
        this.useAVX3Threshold = this.getFlag("AVX3Threshold", Integer.class, 4096, this.osArch.equals("amd64") && (JDK >= 14 || JDK == 11 && JDK_UPDATE >= 6));
        this.preserveFramePointer = this.getFlag("PreserveFramePointer", Boolean.class);
        this.diagnoseSyncOnValueBasedClasses = this.getFlag("DiagnoseSyncOnValueBasedClasses", Integer.class, 0, JDK >= 16);
        this.useG1GC = this.getFlag("UseG1GC", Boolean.class);
        this.useCMSGC = this.getFlag("UseConcMarkSweepGC", Boolean.class, false, JDK < 14);
        this.allocatePrefetchStyle = this.getFlag("AllocatePrefetchStyle", Integer.class);
        this.allocatePrefetchInstr = this.getFlag("AllocatePrefetchInstr", Integer.class);
        this.allocatePrefetchLines = this.getFlag("AllocatePrefetchLines", Integer.class);
        this.allocateInstancePrefetchLines = this.getFlag("AllocateInstancePrefetchLines", Integer.class);
        this.allocatePrefetchStepSize = this.getFlag("AllocatePrefetchStepSize", Integer.class);
        this.allocatePrefetchDistance = this.getFlag("AllocatePrefetchDistance", Integer.class);
        this.universeCollectedHeap = this.getFieldValue("CompilerToVM::Data::Universe_collectedHeap", Long.class, "CollectedHeap*");
        this.collectedHeapTotalCollectionsOffset = this.getFieldOffset("CollectedHeap::_total_collections", Integer.class, "unsigned int");
        this.useDeferredInitBarriers = this.getFlag("ReduceInitialCardMarks", Boolean.class);
        this.useCompressedOops = this.getFlag("UseCompressedOops", Boolean.class);
        this.useCompressedClassPointers = this.getFlag("UseCompressedClassPointers", Boolean.class);
        this.narrowOopBase = this.getFieldValue("CompilerToVM::Data::Universe_narrow_oop_base", Long.class, "address");
        this.narrowOopShift = this.getFieldValue("CompilerToVM::Data::Universe_narrow_oop_shift", Integer.class, "int");
        this.objectAlignment = this.getFlag("ObjectAlignmentInBytes", Integer.class);
        this.narrowKlassSize = this.getFieldValue("CompilerToVM::Data::sizeof_narrowKlass", Integer.class, "int");
        this.narrowKlassBase = this.getFieldValue("CompilerToVM::Data::Universe_narrow_klass_base", Long.class, "address");
        this.narrowKlassShift = this.getFieldValue("CompilerToVM::Data::Universe_narrow_klass_shift", Integer.class, "int");
        this.logKlassAlignment = this.getConstant("LogKlassAlignmentInBytes", Integer.class);
        this.stackShadowPages = this.getFlag("StackShadowPages", Integer.class);
        this.useStackBanging = this.getFlag("UseStackBanging", Boolean.class, true, JDK < 17);
        this.stackBias = this.getConstant("STACK_BIAS", Integer.class, 0, JDK < 15);
        this.vmPageSize = this.getFieldValue("CompilerToVM::Data::vm_page_size", Integer.class, "int");
        this.markOffset = this.getFieldOffset("oopDesc::_mark", Integer.class, this.markWord);
        this.hubOffset = this.getFieldOffset("oopDesc::_metadata._klass", Integer.class, "Klass*");
        this.prototypeMarkWordOffset = this.getFieldOffset("Klass::_prototype_header", Integer.class, this.markWord, -1, JDK < 18);
        this.superCheckOffsetOffset = this.getFieldOffset("Klass::_super_check_offset", Integer.class, "juint");
        this.secondarySuperCacheOffset = this.getFieldOffset("Klass::_secondary_super_cache", Integer.class, "Klass*");
        this.secondarySupersOffset = this.getFieldOffset("Klass::_secondary_supers", Integer.class, "Array<Klass*>*");
        this.classMirrorIsHandle = true;
        this.classMirrorOffset = this.getFieldOffset("Klass::_java_mirror", Integer.class, "OopHandle");
        this.klassSuperKlassOffset = this.getFieldOffset("Klass::_super", Integer.class, "Klass*");
        this.klassModifierFlagsOffset = this.getFieldOffset("Klass::_modifier_flags", Integer.class, "jint");
        this.klassAccessFlagsOffset = this.getFieldOffset("Klass::_access_flags", Integer.class, "AccessFlags");
        this.klassLayoutHelperOffset = this.getFieldOffset("Klass::_layout_helper", Integer.class, "jint");
        this.klassLayoutHelperNeutralValue = this.getConstant("Klass::_lh_neutral_value", Integer.class);
        this.layoutHelperLog2ElementSizeShift = this.getConstant("Klass::_lh_log2_element_size_shift", Integer.class);
        this.layoutHelperLog2ElementSizeMask = this.getConstant("Klass::_lh_log2_element_size_mask", Integer.class);
        this.layoutHelperHeaderSizeShift = this.getConstant("Klass::_lh_header_size_shift", Integer.class);
        this.layoutHelperHeaderSizeMask = this.getConstant("Klass::_lh_header_size_mask", Integer.class);
        this.instanceKlassInitStateOffset = this.getFieldOffset("InstanceKlass::_init_state", Integer.class, "u1");
        this.instanceKlassInitThreadOffset = this.getFieldOffset("InstanceKlass::_init_thread", Integer.class, "Thread*", -1, JDK >= 15 || JVMCI && GraalHotSpotVMConfig.jvmciGE(JVMCI_20_0_b03));
        this.instanceKlassStateBeingInitialized = this.getConstant("InstanceKlass::being_initialized", Integer.class, -1, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_20_0_b03) : JDK >= 14);
        this.instanceKlassStateFullyInitialized = this.getConstant("InstanceKlass::fully_initialized", Integer.class);
        this.arrayOopDescSize = this.getFieldValue("CompilerToVM::Data::sizeof_arrayOopDesc", Integer.class, "int");
        this.metaspaceArrayLengthOffset = this.getFieldOffset("Array<Klass*>::_length", Integer.class, "int");
        this.metaspaceArrayBaseOffset = this.getFieldOffset("Array<Klass*>::_data[0]", Integer.class, "Klass*");
        this.arrayClassElementOffset = this.getFieldOffset("ObjArrayKlass::_element_klass", Integer.class, "Klass*");
        this.jvmAccHasFinalizer = this.getConstant("JVM_ACC_HAS_FINALIZER", Integer.class);
        this.jvmAccWrittenFlags = this.getConstant("JVM_ACC_WRITTEN_FLAGS", Integer.class);
        this.jvmAccIsHiddenClass = this.getConstant("JVM_ACC_IS_HIDDEN_CLASS", Integer.class, 0, JDK >= 15);
        this.jvmAccIsValueBasedClass = this.verifyConstant("JVM_ACC_IS_VALUE_BASED_CLASS", Integer.class, 0x8000000);
        this.jvmciCompileStateCanPostOnExceptionsOffset = this.getJvmciJvmtiCapabilityOffset("_jvmti_can_post_on_exceptions");
        this.jvmciCompileStateCanPopFrameOffset = this.getJvmciJvmtiCapabilityOffset("_jvmti_can_pop_frame");
        this.jvmciCompileStateCanAccessLocalVariablesOffset = this.getJvmciJvmtiCapabilityOffset("_jvmti_can_access_local_variables");
        this.threadTlabOffset = this.getFieldOffset("Thread::_tlab", Integer.class, "ThreadLocalAllocBuffer");
        this.javaThreadAnchorOffset = this.getFieldOffset("JavaThread::_anchor", Integer.class, "JavaFrameAnchor");
        this.javaThreadShouldPostOnExceptionsFlagOffset = this.getFieldOffset("JavaThread::_should_post_on_exceptions_flag", Integer.class, "int", Integer.MIN_VALUE, JVMCI || JDK >= 12);
        if (JDK <= 15) {
            this.threadObjectFieldIsHandle = false;
            this.threadCurrentThreadObjectOffset = this.getFieldOffset("JavaThread::_threadObj", Integer.class, "oop");
        } else if (JDK < 19) {
            this.threadObjectFieldIsHandle = true;
            this.threadCurrentThreadObjectOffset = this.getFieldOffset("JavaThread::_threadObj", Integer.class, "OopHandle");
        } else {
            this.threadObjectFieldIsHandle = true;
            this.threadCurrentThreadObjectOffset = this.getFieldOffset("JavaThread::_vthread", Integer.class, "OopHandle");
        }
        this.osThreadOffset = this.getFieldOffset("JavaThread::_osthread", Integer.class, "OSThread*");
        this.threadObjectResultOffset = this.getFieldOffset("JavaThread::_vm_result", Integer.class, "oop");
        this.jvmciCountersThreadOffset = this.getFieldOffset("JavaThread::_jvmci_counters", Integer.class, "jlong*");
        try {
            offset = this.getFieldOffset("JavaThread::_jvmci_reserved0", Integer.class, "jlong", -1, GraalHotSpotVMConfig.hasJVMCIReservedFields());
        }
        catch (JVMCIError t) {
            offset = this.getFieldOffset("JavaThread::_jvmci_reserved0", Integer.class, "intptr_t*", -1, GraalHotSpotVMConfig.hasJVMCIReservedFields());
        }
        this.jvmciReserved0Offset = offset;
        this.jvmciReservedReference0Offset = this.getFieldOffset("JavaThread::_jvmci_reserved_oop0", Integer.class, "oop", -1, GraalHotSpotVMConfig.hasJVMCIReservedFields());
        this.doingUnsafeAccessOffset = this.getFieldOffset("JavaThread::_doing_unsafe_access", Integer.class, "bool", Integer.MAX_VALUE, JVMCI || JDK >= 14);
        this.javaThreadReservedStackActivationOffset = JDK <= 15 ? this.getFieldOffset("JavaThread::_reserved_stack_activation", Integer.class, "address").intValue() : this.getFieldOffset("JavaThread::_stack_overflow_state._reserved_stack_activation", Integer.class, "address").intValue();
        this.jniEnvironmentOffset = this.getFieldOffset("JavaThread::_jni_environment", Integer.class, "JNIEnv", Integer.MIN_VALUE, JVMCI || JDK >= 14);
        this.threadExceptionOopOffset = this.getFieldOffset("JavaThread::_exception_oop", Integer.class, "oop");
        this.threadExceptionPcOffset = this.getFieldOffset("JavaThread::_exception_pc", Integer.class, "address");
        this.pendingExceptionOffset = this.getFieldOffset("ThreadShadow::_pending_exception", Integer.class, "oop");
        this.pendingDeoptimizationOffset = this.getFieldOffset("JavaThread::_pending_deoptimization", Integer.class, "int");
        this.pendingTransferToInterpreterOffset = this.getFieldOffset("JavaThread::_pending_transfer_to_interpreter", Integer.class, "bool");
        this.javaFrameAnchorLastJavaSpOffset = this.getFieldOffset("JavaFrameAnchor::_last_Java_sp", Integer.class, "intptr_t*");
        this.javaFrameAnchorLastJavaPcOffset = this.getFieldOffset("JavaFrameAnchor::_last_Java_pc", Integer.class, "address");
        String name = "JavaThread::_pending_failed_speculation";
        int offset2 = -1;
        try {
            offset2 = this.getFieldOffset(name, Integer.class, "jlong");
        }
        catch (JVMCIError e) {
            try {
                offset2 = this.getFieldOffset(name, Integer.class, "long");
            }
            catch (JVMCIError jVMCIError) {
                // empty catch block
            }
        }
        if (offset2 == -1) {
            throw new JVMCIError("cannot get offset of field " + name + " with type long or jlong");
        }
        this.pendingFailedSpeculationOffset = offset2;
        this.frameInterpreterFrameSenderSpOffset = this.getConstant("frame::interpreter_frame_sender_sp_offset", Integer.class, 0, this.osArch.equals("amd64"));
        this.frameInterpreterFrameLastSpOffset = this.getConstant("frame::interpreter_frame_last_sp_offset", Integer.class, 0, this.osArch.equals("amd64"));
        this.osThreadInterruptedOffset = this.getFieldOffset("OSThread::_interrupted", Integer.class, "jint", Integer.MAX_VALUE, JDK < 14);
        this.biasedLockMaskInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("biased_lock_mask_in_place"), Integer.class, -1, JDK < 18);
        this.ageMaskInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("age_mask_in_place"), Integer.class);
        this.epochMaskInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("epoch_mask_in_place"), Integer.class, -1, JDK < 18);
        this.unlockedMask = this.getConstant(GraalHotSpotVMConfig.markWordField("unlocked_value"), Integer.class);
        this.monitorMask = this.getConstant(GraalHotSpotVMConfig.markWordField("monitor_value"), Integer.class, -1, this.gr21761);
        this.biasedLockPattern = this.getConstant(GraalHotSpotVMConfig.markWordField("biased_lock_pattern"), Integer.class, -1, JDK < 18);
        this.objectMonitorOwner = this.getFieldOffset("ObjectMonitor::_owner", Integer.class, null, -1, this.gr21761);
        this.objectMonitorRecursions = this.getFieldOffset("ObjectMonitor::_recursions", Integer.class, "intptr_t", -1, this.gr21761);
        this.objectMonitorCxq = this.getFieldOffset("ObjectMonitor::_cxq", Integer.class, "ObjectWaiter*", -1, this.jdk13Backport);
        this.objectMonitorEntryList = this.getFieldOffset("ObjectMonitor::_EntryList", Integer.class, "ObjectWaiter*", -1, this.jdk13Backport);
        this.objectMonitorSucc = this.getFieldOffset("ObjectMonitor::_succ", Integer.class, JDK < 17 ? "Thread*" : "JavaThread*", -1, this.jdk13Backport);
        this.markWordNoHashInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("no_hash_in_place"), Integer.class);
        this.markWordNoLockInPlace = this.getConstant(GraalHotSpotVMConfig.markWordField("no_lock_in_place"), Integer.class);
        this.identityHashCodeShift = this.getConstant(GraalHotSpotVMConfig.markWordField("hash_shift"), Integer.class);
        this.uninitializedIdentityHashCodeValue = this.getConstant(GraalHotSpotVMConfig.markWordField("no_hash"), Integer.class);
        this.methodCompiledEntryOffset = this.getFieldOffset("Method::_from_compiled_entry", Integer.class, "address");
        this.invocationCounterOffset = this.getFieldOffset("MethodCounters::_invocation_counter", Integer.class, "InvocationCounter");
        this.backedgeCounterOffset = this.getFieldOffset("MethodCounters::_backedge_counter", Integer.class, "InvocationCounter");
        this.invocationCounterIncrement = this.getConstant("InvocationCounter::count_increment", Integer.class);
        this.invocationCounterShift = this.getConstant("InvocationCounter::count_shift", Integer.class);
        this.compilationLevelFullOptimization = this.getConstant("CompLevel_full_optimization", Integer.class);
        this.heapWordSize = this.getConstant("HeapWordSize", Integer.class);
        this.nonOopBits = this.getFieldValue("CompilerToVM::Data::Universe_non_oop_bits", Long.class, "void*");
        this.verifyOopCounterAddress = this.getFieldAddress("StubRoutines::_verify_oop_count", "jint");
        this.verifyOopMask = this.getFieldValue("CompilerToVM::Data::Universe_verify_oop_mask", Long.class, "uintptr_t");
        this.verifyOopBits = this.getFieldValue("CompilerToVM::Data::Universe_verify_oop_bits", Long.class, "uintptr_t");
        this.logOfHRGrainBytes = this.getFieldValue("HeapRegion::LogOfHRGrainBytes", Integer.class, "int");
        this.cardtableShift = this.getFieldValue("CompilerToVM::Data::cardtable_shift", Integer.class, "int");
        this.cardtableStartAddress = JDK < 15 ? this.getFieldValue("CompilerToVM::Data::cardtable_start_address", Long.class, "jbyte*").longValue() : this.getFieldValue("CompilerToVM::Data::cardtable_start_address", Long.class, "CardTable::CardValue*").longValue();
        this.maxOopMapStackOffset = this.getFieldValue("CompilerToVM::Data::_max_oop_map_stack_offset", Integer.class, "int");
        this.safepointPollingAddress = this.getFieldValue("os::_polling_page", Long.class, "address");
        this.dirtyCardValue = this.getConstant("CardTable::dirty_card", Byte.class);
        this.g1YoungCardValue = this.getConstant("G1CardTable::g1_young_gen", Byte.class);
        this.g1SATBQueueMarkingActiveOffset = this.getConstant("G1ThreadLocalData::satb_mark_queue_active_offset", Integer.class);
        this.g1SATBQueueIndexOffset = this.getConstant("G1ThreadLocalData::satb_mark_queue_index_offset", Integer.class);
        this.g1SATBQueueBufferOffset = this.getConstant("G1ThreadLocalData::satb_mark_queue_buffer_offset", Integer.class);
        this.g1CardQueueIndexOffset = this.getConstant("G1ThreadLocalData::dirty_card_queue_index_offset", Integer.class);
        this.g1CardQueueBufferOffset = this.getConstant("G1ThreadLocalData::dirty_card_queue_buffer_offset", Integer.class);
        this.klassOffset = this.getFieldValue("java_lang_Class::_klass_offset", Integer.class, "int");
        this.arrayKlassOffset = this.getFieldValue("java_lang_Class::_array_klass_offset", Integer.class, "int");
        this.basicLockSize = this.getFieldValue("CompilerToVM::Data::sizeof_BasicLock", Integer.class, "int");
        this.basicLockDisplacedHeaderOffset = this.getFieldOffset("BasicLock::_displaced_header", Integer.class, this.markWord);
        if (JDK < 15) {
            this.threadPollingPageOffset = this.getFieldOffset("Thread::_polling_page", Integer.class, "address");
        } else if (JDK < 16) {
            this.threadPollingPageOffset = this.getFieldOffset("Thread::_polling_page", Integer.class, "volatile void*");
        } else {
            name = JDK == 16 ? "Thread::_poll_data" : "JavaThread::_poll_data";
            this.threadPollingPageOffset = this.getFieldOffset(name, Integer.class, "SafepointMechanism::ThreadData") + this.getFieldOffset("SafepointMechanism::ThreadData::_polling_page", Integer.class, "volatile uintptr_t");
        }
        this.threadLocalAllocBufferEndOffset = this.getFieldOffset("ThreadLocalAllocBuffer::_end", Integer.class, "HeapWord*");
        this.threadLocalAllocBufferTopOffset = this.getFieldOffset("ThreadLocalAllocBuffer::_top", Integer.class, "HeapWord*");
        this.psrInfoDczidValue = (Integer)this.access.getFieldValue("VM_Version::_psr_info.dczid_el0", Integer.class, "uint32_t", (Object)16);
        this.zvaLength = (Integer)this.access.getFieldValue("VM_Version::_zva_length", Integer.class, "int", (Object)Integer.MAX_VALUE);
        this.inlineCacheMissStub = this.getFieldValue("CompilerToVM::Data::SharedRuntime_ic_miss_stub", Long.class, "address");
        this.handleWrongMethodStub = this.getFieldValue("CompilerToVM::Data::SharedRuntime_handle_wrong_method_stub", Long.class, "address");
        this.deoptBlobUnpack = this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_unpack", Long.class, "address");
        this.deoptBlobUnpackWithExceptionInTLS = this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_unpack_with_exception_in_tls", Long.class, "address", 0L, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_19_3_b07) : JDK >= 14);
        this.deoptBlobUncommonTrap = this.getFieldValue("CompilerToVM::Data::SharedRuntime_deopt_blob_uncommon_trap", Long.class, "address");
        this.codeCacheLowBound = this.getFieldValue("CodeCache::_low_bound", Long.class, "address");
        this.codeCacheHighBound = this.getFieldValue("CodeCache::_high_bound", Long.class, "address");
        this.aescryptEncryptBlockStub = this.getFieldValue("StubRoutines::_aescrypt_encryptBlock", Long.class, "address");
        this.aescryptDecryptBlockStub = this.getFieldValue("StubRoutines::_aescrypt_decryptBlock", Long.class, "address");
        this.cipherBlockChainingEncryptAESCryptStub = this.getFieldValue("StubRoutines::_cipherBlockChaining_encryptAESCrypt", Long.class, "address");
        this.cipherBlockChainingDecryptAESCryptStub = this.getFieldValue("StubRoutines::_cipherBlockChaining_decryptAESCrypt", Long.class, "address");
        this.updateBytesCRC32Stub = this.getFieldValue("StubRoutines::_updateBytesCRC32", Long.class, "address");
        this.crcTableAddress = this.getFieldValue("StubRoutines::_crc_table_adr", Long.class, "address");
        this.md5ImplCompress = this.getFieldValue("StubRoutines::_md5_implCompress", Long.class, "address", 0L, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_22_1_b01) && JDK >= 17 : JDK >= 19);
        this.md5ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_md5_implCompressMB", Long.class, "address", 0L, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_22_1_b01) && JDK >= 17 : JDK >= 19);
        this.sha1ImplCompress = this.getFieldValue("StubRoutines::_sha1_implCompress", Long.class, "address");
        this.sha1ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha1_implCompressMB", Long.class, "address");
        this.sha256ImplCompress = this.getFieldValue("StubRoutines::_sha256_implCompress", Long.class, "address");
        this.sha256ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha256_implCompressMB", Long.class, "address");
        this.sha512ImplCompress = this.getFieldValue("StubRoutines::_sha512_implCompress", Long.class, "address");
        this.sha512ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha512_implCompressMB", Long.class, "address");
        this.sha3ImplCompress = this.getFieldValue("StubRoutines::_sha3_implCompress", Long.class, "address", 0L, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_22_1_b01) && JDK >= 17 : JDK >= 19);
        this.sha3ImplCompressMultiBlock = this.getFieldValue("StubRoutines::_sha3_implCompressMB", Long.class, "address", 0L, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_22_1_b01) && JDK >= 17 : JDK >= 19);
        this.multiplyToLen = this.getFieldValue("StubRoutines::_multiplyToLen", Long.class, "address");
        this.counterModeAESCrypt = this.getFieldValue("StubRoutines::_counterMode_AESCrypt", Long.class, "address");
        this.ghashProcessBlocks = this.getFieldValue("StubRoutines::_ghash_processBlocks", Long.class, "address");
        this.base64EncodeBlock = this.getFieldValue("StubRoutines::_base64_encodeBlock", Long.class, "address");
        this.base64DecodeBlock = this.getFieldValue("StubRoutines::_base64_decodeBlock", Long.class, "address", 0L, JDK >= 16);
        this.crc32cTableTddr = this.getFieldValue("StubRoutines::_crc32c_table_addr", Long.class, "address");
        this.updateBytesCRC32C = this.getFieldValue("StubRoutines::_updateBytesCRC32C", Long.class, "address");
        this.updateBytesAdler32 = this.getFieldValue("StubRoutines::_updateBytesAdler32", Long.class, "address");
        this.squareToLen = this.getFieldValue("StubRoutines::_squareToLen", Long.class, "address");
        this.mulAdd = this.getFieldValue("StubRoutines::_mulAdd", Long.class, "address");
        this.montgomeryMultiply = this.getFieldValue("StubRoutines::_montgomeryMultiply", Long.class, "address");
        this.montgomerySquare = this.getFieldValue("StubRoutines::_montgomerySquare", Long.class, "address");
        this.vectorizedMismatch = this.getFieldValue("StubRoutines::_vectorizedMismatch", Long.class, "address");
        this.bigIntegerLeftShiftWorker = this.getFieldValue("StubRoutines::_bigIntegerLeftShiftWorker", Long.class, "address", 0L, JDK >= 14);
        this.bigIntegerRightShiftWorker = this.getFieldValue("StubRoutines::_bigIntegerRightShiftWorker", Long.class, "address", 0L, JDK >= 14);
        this.electronicCodeBookEncrypt = this.getFieldValue("StubRoutines::_electronicCodeBook_encryptAESCrypt", Long.class, "address");
        this.electronicCodeBookDecrypt = this.getFieldValue("StubRoutines::_electronicCodeBook_decryptAESCrypt", Long.class, "address");
        this.throwDelayedStackOverflowErrorEntry = this.getFieldValue("StubRoutines::_throw_delayed_StackOverflowError_entry", Long.class, "address");
        this.jbyteArraycopy = this.getFieldValue("StubRoutines::_jbyte_arraycopy", Long.class, "address");
        this.jshortArraycopy = this.getFieldValue("StubRoutines::_jshort_arraycopy", Long.class, "address");
        this.jintArraycopy = this.getFieldValue("StubRoutines::_jint_arraycopy", Long.class, "address");
        this.jlongArraycopy = this.getFieldValue("StubRoutines::_jlong_arraycopy", Long.class, "address");
        this.oopArraycopy = this.getFieldValue("StubRoutines::_oop_arraycopy", Long.class, "address");
        this.oopArraycopyUninit = this.getFieldValue("StubRoutines::_oop_arraycopy_uninit", Long.class, "address");
        this.jbyteDisjointArraycopy = this.getFieldValue("StubRoutines::_jbyte_disjoint_arraycopy", Long.class, "address");
        this.jshortDisjointArraycopy = this.getFieldValue("StubRoutines::_jshort_disjoint_arraycopy", Long.class, "address");
        this.jintDisjointArraycopy = this.getFieldValue("StubRoutines::_jint_disjoint_arraycopy", Long.class, "address");
        this.jlongDisjointArraycopy = this.getFieldValue("StubRoutines::_jlong_disjoint_arraycopy", Long.class, "address");
        this.oopDisjointArraycopy = this.getFieldValue("StubRoutines::_oop_disjoint_arraycopy", Long.class, "address");
        this.oopDisjointArraycopyUninit = this.getFieldValue("StubRoutines::_oop_disjoint_arraycopy_uninit", Long.class, "address");
        this.jbyteAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jbyte_arraycopy", Long.class, "address");
        this.jshortAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jshort_arraycopy", Long.class, "address");
        this.jintAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jint_arraycopy", Long.class, "address");
        this.jlongAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_jlong_arraycopy", Long.class, "address");
        this.oopAlignedArraycopy = this.getFieldValue("StubRoutines::_arrayof_oop_arraycopy", Long.class, "address");
        this.oopAlignedArraycopyUninit = this.getFieldValue("StubRoutines::_arrayof_oop_arraycopy_uninit", Long.class, "address");
        this.jbyteAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jbyte_disjoint_arraycopy", Long.class, "address");
        this.jshortAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jshort_disjoint_arraycopy", Long.class, "address");
        this.jintAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jint_disjoint_arraycopy", Long.class, "address");
        this.jlongAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_jlong_disjoint_arraycopy", Long.class, "address");
        this.oopAlignedDisjointArraycopy = this.getFieldValue("StubRoutines::_arrayof_oop_disjoint_arraycopy", Long.class, "address");
        this.oopAlignedDisjointArraycopyUninit = this.getFieldValue("StubRoutines::_arrayof_oop_disjoint_arraycopy_uninit", Long.class, "address");
        this.checkcastArraycopy = this.getFieldValue("StubRoutines::_checkcast_arraycopy", Long.class, "address");
        this.checkcastArraycopyUninit = this.getFieldValue("StubRoutines::_checkcast_arraycopy_uninit", Long.class, "address");
        this.unsafeArraycopy = this.getFieldValue("StubRoutines::_unsafe_arraycopy", Long.class, "address");
        this.genericArraycopy = this.getFieldValue("StubRoutines::_generic_arraycopy", Long.class, "address");
        this.contDoYield = this.getFieldValue("StubRoutines::_cont_doYield", Long.class, "address", 0L, JDK >= 19);
        this.newInstanceAddress = this.getAddress("JVMCIRuntime::new_instance");
        this.newArrayAddress = this.getAddress("JVMCIRuntime::new_array");
        this.newMultiArrayAddress = this.getAddress("JVMCIRuntime::new_multi_array");
        this.dynamicNewInstanceAddress = this.getAddress("JVMCIRuntime::dynamic_new_instance");
        this.newInstanceOrNullAddress = this.getAddress("JVMCIRuntime::new_instance_or_null", 0L, JVMCI || JDK >= 12 || !IS_OPENJDK && JDK == 11 && JDK_UPDATE >= 7);
        this.newArrayOrNullAddress = this.getAddress("JVMCIRuntime::new_array_or_null", 0L, JVMCI || JDK >= 12 || !IS_OPENJDK && JDK == 11 && JDK_UPDATE >= 7);
        this.newMultiArrayOrNullAddress = this.getAddress("JVMCIRuntime::new_multi_array_or_null", 0L, JVMCI || JDK >= 12 || !IS_OPENJDK && JDK == 11 && JDK_UPDATE >= 7);
        this.dynamicNewInstanceOrNullAddress = this.getAddress("JVMCIRuntime::dynamic_new_instance_or_null", 0L, JVMCI || JDK >= 12 || !IS_OPENJDK && JDK == 11 && JDK_UPDATE >= 7);
        this.invokeJavaMethodAddress = this.getAddress("JVMCIRuntime::invoke_static_method_one_arg", 0L, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_21_1_b02) : JDK >= 17 || IS_OPENJDK && JDK == 11 && JDK_UPDATE >= 13);
        this.vmMessageAddress = this.getAddress("JVMCIRuntime::vm_message");
        this.identityHashCodeAddress = this.getAddress("JVMCIRuntime::identity_hash_code");
        this.exceptionHandlerForPcAddress = this.getAddress("JVMCIRuntime::exception_handler_for_pc");
        this.monitorenterAddress = this.getAddress("JVMCIRuntime::monitorenter");
        this.monitorexitAddress = this.getAddress("JVMCIRuntime::monitorexit");
        this.notifyAddress = this.getAddress("JVMCIRuntime::object_notify");
        this.notifyAllAddress = this.getAddress("JVMCIRuntime::object_notifyAll");
        this.throwAndPostJvmtiExceptionAddress = this.getAddress("JVMCIRuntime::throw_and_post_jvmti_exception");
        this.throwKlassExternalNameExceptionAddress = this.getAddress("JVMCIRuntime::throw_klass_external_name_exception");
        this.throwClassCastExceptionAddress = this.getAddress("JVMCIRuntime::throw_class_cast_exception");
        this.logPrimitiveAddress = this.getAddress("JVMCIRuntime::log_primitive");
        this.logObjectAddress = this.getAddress("JVMCIRuntime::log_object");
        this.logPrintfAddress = this.getAddress("JVMCIRuntime::log_printf");
        this.vmErrorAddress = this.getAddress("JVMCIRuntime::vm_error");
        this.loadAndClearExceptionAddress = this.getAddress("JVMCIRuntime::load_and_clear_exception");
        this.writeBarrierPreAddress = this.getAddress("JVMCIRuntime::write_barrier_pre");
        this.writeBarrierPostAddress = this.getAddress("JVMCIRuntime::write_barrier_post");
        this.validateObject = this.getAddress("JVMCIRuntime::validate_object");
        this.testDeoptimizeCallInt = this.getAddress("JVMCIRuntime::test_deoptimize_call_int");
        this.registerFinalizerAddress = this.getAddress("SharedRuntime::register_finalizer");
        this.exceptionHandlerForReturnAddressAddress = this.getAddress("SharedRuntime::exception_handler_for_return_address");
        this.osrMigrationEndAddress = this.getAddress("SharedRuntime::OSR_migration_end");
        this.enableStackReservedZoneAddress = this.getAddress("SharedRuntime::enable_stack_reserved_zone");
        this.javaTimeMillisAddress = this.getAddress("os::javaTimeMillis");
        this.javaTimeNanosAddress = this.getAddress("os::javaTimeNanos");
        this.arithmeticSinAddress = this.getFieldValue("CompilerToVM::Data::dsin", Long.class, "address");
        this.arithmeticCosAddress = this.getFieldValue("CompilerToVM::Data::dcos", Long.class, "address");
        this.arithmeticTanAddress = this.getFieldValue("CompilerToVM::Data::dtan", Long.class, "address");
        this.arithmeticExpAddress = this.getFieldValue("CompilerToVM::Data::dexp", Long.class, "address");
        this.arithmeticLogAddress = this.getFieldValue("CompilerToVM::Data::dlog", Long.class, "address");
        this.arithmeticLog10Address = this.getFieldValue("CompilerToVM::Data::dlog10", Long.class, "address");
        this.arithmeticPowAddress = this.getFieldValue("CompilerToVM::Data::dpow", Long.class, "address");
        this.fremAddress = this.getAddress("SharedRuntime::frem");
        this.dremAddress = this.getAddress("SharedRuntime::drem");
        this.jvmciCountersSize = this.getFlag("JVMCICounterSize", Integer.class);
        this.deoptimizationSupportLargeAccessByteArrayVirtualization = this.getConstant("Deoptimization::_support_large_access_byte_array_virtualization", Boolean.class, false, JVMCI || JDK >= 15);
        this.VMINTRINSIC_FIRST_MH_SIG_POLY = this.getConstant("vmIntrinsics::FIRST_MH_SIG_POLY", Integer.class, -1, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_20_2_b01) : JDK >= 16);
        this.VMINTRINSIC_LAST_MH_SIG_POLY = this.getConstant("vmIntrinsics::LAST_MH_SIG_POLY", Integer.class, -1, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_20_2_b01) : JDK >= 16);
        this.VMINTRINSIC_INVOKE_GENERIC = this.getConstant("vmIntrinsics::_invokeGeneric", Integer.class, -1, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_20_2_b01) : JDK >= 16);
        this.VMINTRINSIC_COMPILED_LAMBDA_FORM = this.getConstant("vmIntrinsics::_compiledLambdaForm", Integer.class, -1, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_20_2_b01) : JDK >= 16);
        this.CPU_HAS_INTEL_JCC_ERRATUM = this.getFieldValue("VM_Version::_has_intel_jcc_erratum", Boolean.class, "bool", true, "amd64".equals(this.osArch) && (JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_20_1_b01) : JDK >= 15));
        assert (this.narrowKlassShift <= this.logKlassAlignment);
        assert (this.narrowOopShift <= this.logMinObjAlignment());
        this.oopEncoding = new CompressEncoding(this.narrowOopBase, this.narrowOopShift);
        this.klassEncoding = new CompressEncoding(this.narrowKlassBase, this.narrowKlassShift);
        assert (this.check());
        this.reportErrors();
        this.populateMarkConstants();
    }

    public CompressEncoding getOopEncoding() {
        return this.oopEncoding;
    }

    public CompressEncoding getKlassEncoding() {
        return this.klassEncoding;
    }

    public boolean useMultiplyToLenIntrinsic() {
        return this.useMultiplyToLenIntrinsic && this.multiplyToLen != 0L;
    }

    public boolean useSHA1Intrinsics() {
        return this.useSHA1Intrinsics && this.sha1ImplCompress != 0L && this.sha1ImplCompressMultiBlock != 0L;
    }

    public boolean useSHA256Intrinsics() {
        return this.useSHA256Intrinsics && this.sha256ImplCompress != 0L && this.sha256ImplCompressMultiBlock != 0L;
    }

    public boolean useSHA512Intrinsics() {
        return this.useSHA512Intrinsics && this.sha512ImplCompress != 0L && this.sha512ImplCompressMultiBlock != 0L;
    }

    public boolean useGHASHIntrinsics() {
        return this.useGHASHIntrinsics && this.ghashProcessBlocks != 0L;
    }

    public boolean useMontgomeryMultiplyIntrinsic() {
        return this.useMontgomeryMultiplyIntrinsic && this.montgomeryMultiply != 0L;
    }

    public boolean useMontgomerySquareIntrinsic() {
        return this.useMontgomerySquareIntrinsic && this.montgomerySquare != 0L;
    }

    public boolean useMulAddIntrinsic() {
        return this.useMulAddIntrinsic && this.mulAdd != 0L;
    }

    public boolean useSquareToLenIntrinsic() {
        return this.useSquareToLenIntrinsic && this.squareToLen != 0L;
    }

    public boolean inlineNotify() {
        return this.notifyAddress != 0L;
    }

    public boolean inlineNotifyAll() {
        return this.notifyAllAddress != 0L;
    }

    public boolean useCRC32Intrinsics() {
        return this.useCRC32Intrinsics && this.updateBytesCRC32Stub != 0L;
    }

    public boolean useCRC32CIntrinsics() {
        return this.useCRC32CIntrinsics && this.updateBytesCRC32C != 0L;
    }

    public boolean useAESCTRIntrinsics() {
        return this.useAESCTRIntrinsics && this.counterModeAESCrypt != 0L;
    }

    public boolean useVectorizedMismatchIntrinsic() {
        return this.useVectorizedMismatchIntrinsic && this.vectorizedMismatch != 0L;
    }

    public long gcTotalCollectionsAddress() {
        return this.universeCollectedHeap + (long)this.collectedHeapTotalCollectionsOffset;
    }

    public final int logMinObjAlignment() {
        return (int)(Math.log(this.objectAlignment) / Math.log(2.0));
    }

    public final int arrayOopDescLengthOffset() {
        return this.useCompressedClassPointers ? this.hubOffset + this.narrowKlassSize : this.arrayOopDescSize;
    }

    private int getJvmciJvmtiCapabilityOffset(String name) {
        if (JVMCI) {
            return this.getFieldOffset("JVMCICompileState::" + name, Integer.class, "jbyte");
        }
        if (JDK >= 13) {
            return this.getFieldOffset("JVMCICompileState::" + name, Integer.class, "jbyte");
        }
        if (JDK == 12) {
            return this.getFieldOffset("JVMCIEnv::" + name, Integer.class, "jbyte");
        }
        return Integer.MIN_VALUE;
    }

    private static boolean hasJVMCIReservedFields() {
        return JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_21_1_b02) : JDK >= 17 || IS_OPENJDK && JDK == 11 && JDK_UPDATE >= 13;
    }

    public boolean requiresReservedStackCheck(List<ResolvedJavaMethod> methods) {
        if (this.enableStackReservedZoneAddress != 0L && methods != null) {
            for (ResolvedJavaMethod method : methods) {
                if (!(method instanceof HotSpotResolvedJavaMethod) || !((HotSpotResolvedJavaMethod)method).hasReservedStackAccess()) continue;
                return true;
            }
        }
        return false;
    }

    public int threadLastJavaSpOffset() {
        return this.javaThreadAnchorOffset + this.javaFrameAnchorLastJavaSpOffset;
    }

    public int threadLastJavaPcOffset() {
        return this.javaThreadAnchorOffset + this.javaFrameAnchorLastJavaPcOffset;
    }

    public int threadLastJavaFpOffset() {
        assert (this.osArch.equals("aarch64") || this.osArch.equals("amd64"));
        return this.javaThreadAnchorOffset + this.getFieldOffset("JavaFrameAnchor::_last_Java_fp", Integer.class, "intptr_t*");
    }

    public long defaultPrototypeMarkWord() {
        return this.markWordNoHashInPlace | this.markWordNoLockInPlace;
    }

    private static String markWordField(String simpleName) {
        return (JDK < 14 ? "markOopDesc::" : "markWord::") + simpleName;
    }

    public int threadTlabEndOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferEndOffset;
    }

    public int threadTlabTopOffset() {
        return this.threadTlabOffset + this.threadLocalAllocBufferTopOffset;
    }

    public static final boolean base64DecodeBlockHasIsMIMEParameter() {
        try {
            Base64.Decoder.class.getDeclaredMethod("decodeBlock", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean areNullAllocationStubsAvailable() {
        return this.newInstanceOrNullAddress != 0L;
    }

    private boolean checkNullAllocationStubs() {
        if (this.newInstanceOrNullAddress == 0L) {
            assert (this.newArrayOrNullAddress == 0L);
            assert (this.newMultiArrayOrNullAddress == 0L);
            assert (this.dynamicNewInstanceOrNullAddress == 0L);
        } else {
            assert (this.newArrayOrNullAddress != 0L);
            assert (this.newMultiArrayOrNullAddress != 0L);
            assert (this.dynamicNewInstanceOrNullAddress != 0L);
        }
        return true;
    }

    private static void checkForMissingRequiredValue(HotSpotMarkId markId, boolean required) {
        if (!markId.isAvailable() && required) {
            GraalHotSpotVMConfigAccess.reportError("Unsupported Mark " + markId);
        }
    }

    private void populateMarkConstants() {
        boolean jdk13JvmciBackport = JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_19_3_b03) : JDK > 9;
        boolean verifyOopsMarkSupported = JDK >= 16;
        Map constants = this.getStore().getConstants();
        block6: for (HotSpotMarkId markId : HotSpotMarkId.values()) {
            Integer value = null;
            String key = "CodeInstaller::" + markId.name();
            Long result = (Long)constants.get(key);
            if (result != null) {
                value = result.intValue();
            }
            markId.setValue(value);
            switch (markId) {
                case FRAME_COMPLETE: {
                    GraalHotSpotVMConfig.checkForMissingRequiredValue(markId, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_20_1_b01) : JDK_8245443);
                    continue block6;
                }
                case DEOPT_MH_HANDLER_ENTRY: {
                    GraalHotSpotVMConfig.checkForMissingRequiredValue(markId, JVMCI ? GraalHotSpotVMConfig.jvmciGE(JVMCI_20_2_b01) : JDK >= 16);
                    continue block6;
                }
                case NARROW_KLASS_BASE_ADDRESS: 
                case CRC_TABLE_ADDRESS: 
                case NARROW_OOP_BASE_ADDRESS: 
                case LOG_OF_HEAP_REGION_GRAIN_BYTES: {
                    GraalHotSpotVMConfig.checkForMissingRequiredValue(markId, jdk13JvmciBackport);
                    continue block6;
                }
                case VERIFY_OOPS: 
                case VERIFY_OOP_BITS: 
                case VERIFY_OOP_MASK: 
                case VERIFY_OOP_COUNT_ADDRESS: {
                    GraalHotSpotVMConfig.checkForMissingRequiredValue(markId, verifyOopsMarkSupported);
                    continue block6;
                }
                default: {
                    GraalHotSpotVMConfig.checkForMissingRequiredValue(markId, true);
                }
            }
        }
    }

    protected boolean check() {
        for (Field f : this.getClass().getDeclaredFields()) {
            int modifiers = f.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) assert (Modifier.isFinal(modifiers)) : "field should be final: " + f;
        }
        assert (this.codeEntryAlignment > 0) : this.codeEntryAlignment;
        assert (this.checkNullAllocationStubs());
        return true;
    }

    public boolean isMethodHandleCall(HotSpotResolvedJavaMethod targetMethod) {
        int intrinsicId = targetMethod.intrinsicId();
        return intrinsicId >= this.VMINTRINSIC_FIRST_MH_SIG_POLY && intrinsicId <= this.VMINTRINSIC_LAST_MH_SIG_POLY && intrinsicId != this.VMINTRINSIC_INVOKE_GENERIC || intrinsicId == this.VMINTRINSIC_COMPILED_LAMBDA_FORM;
    }

    public boolean supportsMethodHandleDeoptimizationEntry() {
        return HotSpotMarkId.DEOPT_MH_HANDLER_ENTRY.isAvailable() && this.VMINTRINSIC_FIRST_MH_SIG_POLY != -1 && this.VMINTRINSIC_LAST_MH_SIG_POLY != -1 && this.VMINTRINSIC_INVOKE_GENERIC != -1 && this.VMINTRINSIC_COMPILED_LAMBDA_FORM != -1;
    }
}

