/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeIdAccessor;
import org.graalvm.compiler.graph.iterators.NodeIterable;

public final class NodeBitMap
extends NodeIdAccessor
implements NodeIterable<Node> {
    private static final int SHIFT = 6;
    private long[] bits;
    private int nodeCount;
    private int counter;

    public NodeBitMap(Graph graph) {
        super(graph);
        this.nodeCount = graph.nodeIdCount();
        this.bits = new long[NodeBitMap.sizeForNodeCount(this.nodeCount)];
    }

    private static int sizeForNodeCount(int nodeCount) {
        return nodeCount + 64 - 1 >> 6;
    }

    public int getCounter() {
        return this.counter;
    }

    private NodeBitMap(NodeBitMap other) {
        super(other.graph);
        this.bits = (long[])other.bits.clone();
        this.nodeCount = other.nodeCount;
    }

    public Graph graph() {
        return this.graph;
    }

    public boolean isNew(Node node) {
        return this.getNodeId(node) >= this.nodeCount;
    }

    public boolean isMarked(Node node) {
        assert (this.check(node, false));
        return this.isMarked(this.getNodeId(node));
    }

    public boolean checkAndMarkInc(Node node) {
        if (!this.isMarked(node)) {
            ++this.counter;
            this.mark(node);
            return true;
        }
        return false;
    }

    public boolean isMarked(int id) {
        return (this.bits[id >> 6] & 1L << id) != 0L;
    }

    public boolean isMarkedAndGrow(Node node) {
        assert (this.check(node, true));
        int id = this.getNodeId(node);
        this.checkGrow(id);
        return this.isMarked(id);
    }

    public void mark(Node node) {
        assert (this.check(node, false));
        int id = this.getNodeId(node);
        int n = id >> 6;
        this.bits[n] = this.bits[n] | 1L << id;
    }

    public void markAndGrow(Node node) {
        assert (this.check(node, true));
        int id = this.getNodeId(node);
        this.checkGrow(id);
        int n = id >> 6;
        this.bits[n] = this.bits[n] | 1L << id;
    }

    public void clear(Node node) {
        assert (this.check(node, false));
        int id = this.getNodeId(node);
        int n = id >> 6;
        this.bits[n] = this.bits[n] & (1L << id ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clearAndGrow(Node node) {
        assert (this.check(node, true));
        int id = this.getNodeId(node);
        this.checkGrow(id);
        int n = id >> 6;
        this.bits[n] = this.bits[n] & (1L << id ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void checkGrow(int id) {
        if (id >= this.nodeCount) {
            if (id >> 6 >= this.bits.length) {
                this.grow();
            } else {
                this.nodeCount = id + 1;
            }
        }
    }

    public void clearAll() {
        Arrays.fill(this.bits, 0L);
    }

    public void intersect(NodeBitMap other) {
        int commonLength;
        int i;
        assert (this.graph() == other.graph());
        for (i = commonLength = Math.min(this.bits.length, other.bits.length); i < this.bits.length; ++i) {
            this.bits[i] = 0L;
        }
        for (i = 0; i < commonLength; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & other.bits[i];
        }
    }

    public void subtract(NodeBitMap other) {
        assert (this.graph() == other.graph());
        int commonLength = Math.min(this.bits.length, other.bits.length);
        for (int i = 0; i < commonLength; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & (other.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void union(NodeBitMap other) {
        assert (this.graph() == other.graph());
        this.grow();
        if (this.bits.length < other.bits.length) {
            this.bits = Arrays.copyOf(this.bits, other.bits.length);
        }
        for (int i = 0; i < Math.min(this.bits.length, other.bits.length); ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | other.bits[i];
        }
    }

    public void invert() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void grow() {
        this.nodeCount = Math.max(this.nodeCount, this.graph().nodeIdCount());
        int newLength = NodeBitMap.sizeForNodeCount(this.nodeCount);
        if (newLength > this.bits.length) {
            newLength = Math.max(newLength, this.bits.length * 3 / 2 + 1);
            this.bits = Arrays.copyOf(this.bits, newLength);
        }
    }

    private boolean check(Node node, boolean grow) {
        assert (node.graph() == this.graph()) : "this node is not part of the graph: " + node;
        assert (grow || !this.isNew(node)) : "node was added to the graph after creating the node bitmap: " + node;
        assert (node.isAlive()) : "node is deleted!" + node;
        return true;
    }

    public <T extends Node> void markAll(Iterable<T> nodes) {
        for (Node node : nodes) {
            this.mark(node);
        }
    }

    protected Node nextMarkedNode(int fromNodeId) {
        assert (fromNodeId >= 0);
        int wordIndex = fromNodeId >> 6;
        int wordsInUse = this.bits.length;
        if (wordIndex < wordsInUse) {
            long word = NodeBitMap.getPartOfWord(this.bits[wordIndex], fromNodeId);
            while (true) {
                if (word != 0L) {
                    int bitIndex = Long.numberOfTrailingZeros(word);
                    int nodeId = wordIndex * 64 + bitIndex;
                    Node result = this.graph.getNode(nodeId);
                    if (result == null) {
                        this.bits[wordIndex] = this.bits[wordIndex] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
                        int nextNodeId = nodeId + 1;
                        if ((nextNodeId & 0x3F) != 0) {
                            word = NodeBitMap.getPartOfWord(word, nextNodeId);
                            continue;
                        }
                    } else {
                        return result;
                    }
                }
                if (++wordIndex == wordsInUse) break;
                word = this.bits[wordIndex];
            }
        }
        return null;
    }

    private static long getPartOfWord(long word, int firstNodeIdToInclude) {
        return word & -1L << firstNodeIdToInclude;
    }

    @Override
    public Iterator<Node> iterator() {
        return new MarkedNodeIterator();
    }

    public NodeBitMap copy() {
        return new NodeBitMap(this);
    }

    @Override
    public int count() {
        int count = 0;
        for (long l : this.bits) {
            count += Long.bitCount(l);
        }
        return count;
    }

    @Override
    public boolean contains(Node node) {
        return this.isMarked(node);
    }

    public String toString() {
        return this.snapshot().toString();
    }

    private class MarkedNodeIterator
    implements Iterator<Node> {
        private int currentNodeId = -1;
        private Node currentNode;

        MarkedNodeIterator() {
            this.forward();
        }

        private void forward() {
            assert (this.currentNode == null);
            this.currentNode = NodeBitMap.this.nextMarkedNode(this.currentNodeId + 1);
            if (this.currentNode != null) {
                assert (this.currentNode.isAlive());
                this.currentNodeId = NodeBitMap.this.getNodeId(this.currentNode);
            } else {
                this.currentNodeId = -1;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentNode == null && this.currentNodeId >= 0) {
                this.forward();
            }
            return this.currentNodeId >= 0;
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.currentNode.isAlive()) {
                throw new ConcurrentModificationException("NodeBitMap was modified between the calls to hasNext() and next()");
            }
            Node result = this.currentNode;
            this.currentNode = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

