/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.phases.fuzzing;

import org.graalvm.compiler.core.phases.fuzzing.FullFuzzedCompilationPlan;
import org.graalvm.compiler.core.phases.fuzzing.MinimalFuzzedCompilationPlan;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.phases.tiers.Suites;

public final class FuzzedSuites
extends Suites {
    private final FullFuzzedCompilationPlan fullFuzzedCompilationPlan;

    private FuzzedSuites(FullFuzzedCompilationPlan fullFuzzedCompilationPlan) {
        super(fullFuzzedCompilationPlan.getSuites().getHighTier(), fullFuzzedCompilationPlan.getSuites().getMidTier(), fullFuzzedCompilationPlan.getSuites().getLowTier());
        this.fullFuzzedCompilationPlan = fullFuzzedCompilationPlan;
    }

    public static FuzzedSuites createFuzzedSuites(Suites originalSuites, GraphState graphState, GraphState.MandatoryStages mandatoryStages, long seed) {
        MinimalFuzzedCompilationPlan minimalFuzzedCompilationPlan = MinimalFuzzedCompilationPlan.createMinimalFuzzedCompilationPlan(originalSuites, graphState, mandatoryStages, seed);
        FullFuzzedCompilationPlan fullFuzzedCompilationPlan = FullFuzzedCompilationPlan.createFullFuzzedCompilationPlan(minimalFuzzedCompilationPlan, graphState);
        return new FuzzedSuites(fullFuzzedCompilationPlan);
    }

    public void saveFuzzedSuites(String dumpPath) {
        this.fullFuzzedCompilationPlan.saveCompilationPlan(dumpPath);
    }

    public String toString() {
        return this.fullFuzzedCompilationPlan.toString();
    }
}

