/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.spi;

import java.util.Arrays;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.word.LocationIdentity;

public class ForeignCallDescriptor {
    protected final ForeignCallSignature signature;
    protected final boolean isReexecutable;
    protected final boolean canDeoptimize;
    protected final boolean isGuaranteedSafepoint;
    protected final LocationIdentity[] killedLocations;

    public ForeignCallDescriptor(String name, Class<?> resultType, Class<?>[] argumentTypes, boolean isReexecutable, LocationIdentity[] killedLocations, boolean canDeoptimize, boolean isGuaranteedSafepoint) {
        this.isReexecutable = isReexecutable;
        this.killedLocations = killedLocations;
        this.canDeoptimize = canDeoptimize;
        this.isGuaranteedSafepoint = isGuaranteedSafepoint;
        this.signature = new ForeignCallSignature(name, resultType, argumentTypes);
    }

    public ForeignCallSignature getSignature() {
        return this.signature;
    }

    public String getName() {
        return this.signature.getName();
    }

    public Class<?> getResultType() {
        return this.signature.getResultType();
    }

    public Class<?>[] getArgumentTypes() {
        return this.signature.getArgumentTypes();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public boolean isReexecutable() {
        return this.isReexecutable;
    }

    public LocationIdentity[] getKilledLocations() {
        return this.killedLocations;
    }

    public boolean canDeoptimize() {
        return this.canDeoptimize;
    }

    public boolean isGuaranteedSafepoint() {
        return this.isGuaranteedSafepoint;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.signature + ", isReexecutable=" + this.isReexecutable + ", canDeoptimize=" + this.canDeoptimize + ", isGuaranteedSafepoint=" + this.isGuaranteedSafepoint + ", killedLocations=" + Arrays.toString(this.killedLocations) + "}";
    }
}

