/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.encTicketPart.actions;

import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.encTicketPart.EncTicketPartContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.EncTicketPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncTicketPartInit
extends GrammarAction<EncTicketPartContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(EncTicketPartInit.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public EncTicketPartInit() {
        super("Creates a EncTicketPart instance");
    }

    public void action(EncTicketPartContainer encTicketPartContainer) throws DecoderException {
        TLV tlv = encTicketPartContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        EncTicketPart encTicketPart = new EncTicketPart();
        encTicketPartContainer.setEncTicketPart(encTicketPart);
        if (IS_DEBUG) {
            LOG.debug("EncTicketPart created");
        }
    }
}

