/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.schema.compaction;

import com.datastax.oss.driver.api.querybuilder.schema.compaction.CompactionStrategy;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface SizeTieredCompactionStrategy<SelfT extends SizeTieredCompactionStrategy<SelfT>>
extends CompactionStrategy<SelfT> {
    @NonNull
    @CheckReturnValue
    default public SelfT withMaxThreshold(int maxThreshold) {
        return (SelfT)((SizeTieredCompactionStrategy)this.withOption("max_threshold", maxThreshold));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withMinThreshold(int minThreshold) {
        return (SelfT)((SizeTieredCompactionStrategy)this.withOption("min_threshold", minThreshold));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withMinSSTableSizeInBytes(long bytes) {
        return (SelfT)((SizeTieredCompactionStrategy)this.withOption("min_sstable_size", bytes));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withOnlyPurgeRepairedTombstones(boolean enabled) {
        return (SelfT)((SizeTieredCompactionStrategy)this.withOption("only_purge_repaired_tombstones", enabled));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withBucketHigh(double bucketHigh) {
        return (SelfT)((SizeTieredCompactionStrategy)this.withOption("bucket_high", bucketHigh));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withBucketLow(double bucketHigh) {
        return (SelfT)((SizeTieredCompactionStrategy)this.withOption("bucket_low", bucketHigh));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withColdReadsToOmit(double ratio) {
        return (SelfT)((SizeTieredCompactionStrategy)this.withOption("cold_reads_to_omit", ratio));
    }
}

