/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.janusgraph.diskstorage.hbase.AdminMask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseAdmin1_0
implements AdminMask {
    private static final Logger log = LoggerFactory.getLogger(HBaseAdmin1_0.class);
    private final Admin adm;

    public HBaseAdmin1_0(Admin adm) {
        this.adm = adm;
    }

    @Override
    public void clearTable(String tableString, long timestamp) throws IOException {
        TableName tableName = TableName.valueOf((String)tableString);
        if (!this.adm.tableExists(tableName)) {
            log.debug("Attempted to clear table {} before it exists (noop)", (Object)tableString);
            return;
        }
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        scan.setCaching(2000);
        scan.setTimeRange(0L, Long.MAX_VALUE);
        scan.setMaxVersions(1);
        try (Table table = this.adm.getConnection().getTable(tableName);
             ResultScanner scanner = table.getScanner(scan);){
            Iterator iterator = scanner.iterator();
            int batchSize = 1000;
            ArrayList<Delete> deleteList = new ArrayList<Delete>();
            while (iterator.hasNext()) {
                deleteList.add(new Delete(((Result)iterator.next()).getRow(), timestamp));
                if (iterator.hasNext() && deleteList.size() != 1000) continue;
                table.delete(deleteList);
                deleteList.clear();
            }
        }
    }

    @Override
    public void dropTable(String tableString) throws IOException {
        TableName tableName = TableName.valueOf((String)tableString);
        if (!this.adm.tableExists(tableName)) {
            log.debug("Attempted to drop table {} before it exists (noop)", (Object)tableString);
            return;
        }
        if (this.adm.isTableEnabled(tableName)) {
            this.adm.disableTable(tableName);
        }
        this.adm.deleteTable(tableName);
    }

    @Override
    public HTableDescriptor getTableDescriptor(String tableString) throws IOException {
        return this.adm.getTableDescriptor(TableName.valueOf((String)tableString));
    }

    @Override
    public boolean tableExists(String tableString) throws IOException {
        return this.adm.tableExists(TableName.valueOf((String)tableString));
    }

    @Override
    public void createTable(HTableDescriptor desc) throws IOException {
        this.adm.createTable((TableDescriptor)desc);
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.adm.createTable((TableDescriptor)desc, startKey, endKey, numRegions);
    }

    @Override
    public int getEstimatedRegionServerCount() {
        int serverCount = -1;
        try {
            serverCount = this.adm.getClusterStatus().getServers().size();
            log.debug("Read {} servers from HBase ClusterStatus", (Object)serverCount);
        }
        catch (IOException e) {
            log.debug("Unable to retrieve HBase cluster status", (Throwable)e);
        }
        return serverCount;
    }

    @Override
    public void disableTable(String tableString) throws IOException {
        this.adm.disableTable(TableName.valueOf((String)tableString));
    }

    @Override
    public void enableTable(String tableString) throws IOException {
        this.adm.enableTable(TableName.valueOf((String)tableString));
    }

    @Override
    public boolean isTableDisabled(String tableString) throws IOException {
        return this.adm.isTableDisabled(TableName.valueOf((String)tableString));
    }

    @Override
    public void addColumn(String tableString, HColumnDescriptor columnDescriptor) throws IOException {
        this.adm.addColumn(TableName.valueOf((String)tableString), (ColumnFamilyDescriptor)columnDescriptor);
    }

    @Override
    public void close() throws IOException {
        this.adm.close();
    }

    @Override
    public void snapshot(String snapshotName, String table) throws IllegalArgumentException, IOException {
        this.adm.snapshot(snapshotName, TableName.valueOf((String)table));
    }

    @Override
    public void deleteSnapshot(String snapshotName) throws IOException {
        this.adm.deleteSnapshot(snapshotName);
    }
}

