/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.indextype;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.SchemaSource;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;

public abstract class IndexTypeWrapper
implements IndexType {
    protected final SchemaSource base;
    private volatile Map<PropertyKey, IndexField> fieldMap = null;
    private volatile boolean cachedTypeConstraint = false;
    private volatile JanusGraphSchemaType schemaTypeConstraint = null;

    public IndexTypeWrapper(SchemaSource base) {
        Preconditions.checkNotNull((Object)base);
        this.base = base;
    }

    public SchemaSource getSchemaBase() {
        return this.base;
    }

    @Override
    public ElementCategory getElement() {
        return this.base.getDefinition().getValue(TypeDefinitionCategory.ELEMENT_CATEGORY, ElementCategory.class);
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public boolean equals(Object oth) {
        return this == oth || oth instanceof IndexTypeWrapper && this.base.equals(((IndexTypeWrapper)oth).base);
    }

    public String toString() {
        return this.base.name();
    }

    @Override
    public String getName() {
        return this.base.name();
    }

    @Override
    public IndexField getField(PropertyKey key) {
        Map<PropertyKey, IndexField> result = this.fieldMap;
        if (result == null) {
            IndexField[] fieldKeys = this.getFieldKeys();
            result = new HashMap<PropertyKey, IndexField>(fieldKeys.length);
            for (IndexField f : fieldKeys) {
                result.put(f.getFieldKey(), f);
            }
            this.fieldMap = result = Collections.unmodifiableMap(result);
        }
        assert (result != null);
        return result.get(key);
    }

    @Override
    public boolean hasSchemaTypeConstraint() {
        return this.getSchemaTypeConstraint() != null;
    }

    @Override
    public JanusGraphSchemaType getSchemaTypeConstraint() {
        JanusGraphSchemaType constraint;
        if (!this.cachedTypeConstraint) {
            List<SchemaSource.Entry> related = this.base.getRelated(TypeDefinitionCategory.INDEX_SCHEMA_CONSTRAINT, Direction.OUT);
            if (related.isEmpty()) {
                constraint = null;
            } else {
                constraint = (JanusGraphSchemaType)((Object)((SchemaSource.Entry)Iterables.getOnlyElement(related)).getSchemaType());
                assert (constraint != null);
            }
            this.schemaTypeConstraint = constraint;
            this.cachedTypeConstraint = true;
        } else {
            constraint = this.schemaTypeConstraint;
        }
        return constraint;
    }

    @Override
    public void resetCache() {
        this.base.resetCache();
        this.fieldMap = null;
    }

    @Override
    public boolean indexesKey(PropertyKey key) {
        return this.getField(key) != null;
    }

    @Override
    public String getBackingIndexName() {
        return this.base.getDefinition().getValue(TypeDefinitionCategory.BACKING_INDEX, String.class);
    }
}

