/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import org.apache.commons.lang.ArrayUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.graphdb.tinkerpop.ElementUtils;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphStep;

public class JanusGraphStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final JanusGraphStepStrategy INSTANCE = new JanusGraphStepStrategy();

    private JanusGraphStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.onGraphComputer(traversal)) {
            return;
        }
        TraversalHelper.getStepsOfClass(GraphStep.class, traversal).forEach(originalGraphStep -> {
            if (ArrayUtils.isEmpty((Object[])originalGraphStep.getIds())) {
                JanusGraphStep janusGraphStep = new JanusGraphStep(originalGraphStep);
                TraversalHelper.replaceStep((Step)originalGraphStep, janusGraphStep, (Traversal.Admin)traversal);
                HasStepFolder.foldInIds(janusGraphStep, traversal);
                HasStepFolder.foldInHasContainer(janusGraphStep, traversal, traversal);
                if (ArrayUtils.isEmpty((Object[])janusGraphStep.getIds())) {
                    HasStepFolder.foldInOrder(janusGraphStep, janusGraphStep.getNextStep(), traversal, traversal, janusGraphStep.returnsVertex(), null);
                    HasStepFolder.foldInRange(janusGraphStep, JanusGraphTraversalUtil.getNextNonIdentityStep(janusGraphStep), traversal, null);
                }
            } else {
                Object[] ids = originalGraphStep.getIds();
                ElementUtils.verifyArgsMustBeEitherIdOrElement(ids);
                if (ids[0] instanceof Element) {
                    Object[] elementIds = new Object[ids.length];
                    for (int i = 0; i < ids.length; ++i) {
                        elementIds[i] = ((Element)ids[i]).id();
                    }
                    originalGraphStep.setIteratorSupplier(() -> originalGraphStep.returnsVertex() ? ((Graph)originalGraphStep.getTraversal().getGraph().get()).vertices(elementIds) : ((Graph)originalGraphStep.getTraversal().getGraph().get()).edges(elementIds));
                }
            }
        });
    }

    public static JanusGraphStepStrategy instance() {
        return INSTANCE;
    }
}

