/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphEdgeVertexStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphPropertiesStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphVertexStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.AdjacentVertexFilterOptimizerStrategy;

public class JanusGraphLocalQueryOptimizerStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final JanusGraphLocalQueryOptimizerStrategy INSTANCE = new JanusGraphLocalQueryOptimizerStrategy();
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = Collections.singleton(AdjacentVertexFilterOptimizerStrategy.class);

    private JanusGraphLocalQueryOptimizerStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!traversal.getGraph().isPresent()) {
            return;
        }
        StandardJanusGraph janusGraph = JanusGraphTraversalUtil.getJanusGraph(traversal);
        if (janusGraph == null) {
            return;
        }
        boolean batchPropertyPrefetching = janusGraph.getConfiguration().batchPropertyPrefetching();
        int txVertexCacheSize = janusGraph.getConfiguration().getTxVertexCacheSize();
        this.applyJanusGraphVertexSteps(traversal, batchPropertyPrefetching, txVertexCacheSize);
        this.applyJanusGraphPropertiesSteps(traversal);
        this.inspectLocalTraversals(traversal);
    }

    private void applyJanusGraphVertexSteps(Traversal.Admin<?, ?> traversal, boolean batchPropertyPrefetching, int txVertexCacheSize) {
        TraversalHelper.getStepsOfAssignableClass(VertexStep.class, traversal).forEach(originalStep -> {
            JanusGraphVertexStep vertexStep = new JanusGraphVertexStep(originalStep);
            TraversalHelper.replaceStep((Step)originalStep, vertexStep, (Traversal.Admin)originalStep.getTraversal());
            if (JanusGraphTraversalUtil.isEdgeReturnStep(vertexStep)) {
                HasStepFolder.foldInHasContainer(vertexStep, originalStep.getTraversal(), originalStep.getTraversal());
            }
            assert (JanusGraphTraversalUtil.isEdgeReturnStep(vertexStep) || JanusGraphTraversalUtil.isVertexReturnStep(vertexStep));
            Step nextStep = JanusGraphTraversalUtil.getNextNonIdentityStep(vertexStep);
            if (nextStep instanceof RangeGlobalStep) {
                int limit = QueryUtil.convertLimit(((RangeGlobalStep)nextStep).getHighRange());
                vertexStep.setLimit(0, QueryUtil.mergeHighLimits(limit, vertexStep.getHighLimit()));
            }
            if (batchPropertyPrefetching) {
                this.applyBatchPropertyPrefetching(originalStep.getTraversal(), vertexStep, nextStep, txVertexCacheSize);
            }
        });
    }

    private void applyJanusGraphPropertiesSteps(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfAssignableClass(PropertiesStep.class, traversal).forEach(originalStep -> {
            JanusGraphPropertiesStep propertiesStep = new JanusGraphPropertiesStep(originalStep);
            TraversalHelper.replaceStep((Step)originalStep, propertiesStep, (Traversal.Admin)originalStep.getTraversal());
            if (propertiesStep.getReturnType().forProperties()) {
                HasStepFolder.foldInHasContainer(propertiesStep, originalStep.getTraversal(), originalStep.getTraversal());
            }
        });
    }

    private void inspectLocalTraversals(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfClass(LocalStep.class, traversal).forEach(localStep -> {
            Traversal.Admin localTraversal = (Traversal.Admin)localStep.getLocalChildren().get(0);
            Step localStart = localTraversal.getStartStep();
            if (localStart instanceof VertexStep) {
                JanusGraphVertexStep vertexStep = new JanusGraphVertexStep((VertexStep)localStart);
                TraversalHelper.replaceStep((Step)localStart, vertexStep, (Traversal.Admin)localTraversal);
                if (JanusGraphTraversalUtil.isEdgeReturnStep(vertexStep)) {
                    HasStepFolder.foldInHasContainer(vertexStep, localTraversal, traversal);
                    HasStepFolder.foldInOrder(vertexStep, vertexStep.getNextStep(), localTraversal, traversal, false, null);
                }
                HasStepFolder.foldInRange(vertexStep, JanusGraphTraversalUtil.getNextNonIdentityStep(vertexStep), localTraversal, null);
                JanusGraphLocalQueryOptimizerStrategy.unfoldLocalTraversal(traversal, localStep, localTraversal, vertexStep);
            }
            if (localStart instanceof PropertiesStep) {
                JanusGraphPropertiesStep propertiesStep = new JanusGraphPropertiesStep((PropertiesStep)localStart);
                TraversalHelper.replaceStep((Step)localStart, propertiesStep, (Traversal.Admin)localTraversal);
                if (propertiesStep.getReturnType().forProperties()) {
                    HasStepFolder.foldInHasContainer(propertiesStep, localTraversal, traversal);
                    HasStepFolder.foldInOrder(propertiesStep, propertiesStep.getNextStep(), localTraversal, traversal, false, null);
                }
                HasStepFolder.foldInRange(propertiesStep, JanusGraphTraversalUtil.getNextNonIdentityStep(propertiesStep), localTraversal, null);
                JanusGraphLocalQueryOptimizerStrategy.unfoldLocalTraversal(traversal, localStep, localTraversal, propertiesStep);
            }
        });
    }

    private void applyBatchPropertyPrefetching(Traversal.Admin<?, ?> traversal, JanusGraphVertexStep vertexStep, Step nextStep, int txVertexCacheSize) {
        EdgeVertexStep edgeVertexStep;
        if (Vertex.class.isAssignableFrom(vertexStep.getReturnClass())) {
            if (HasStepFolder.foldableHasContainerNoLimit(vertexStep)) {
                vertexStep.setBatchPropertyPrefetching(true);
                vertexStep.setTxVertexCacheSize(txVertexCacheSize);
            }
        } else if (nextStep instanceof EdgeVertexStep && HasStepFolder.foldableHasContainerNoLimit(edgeVertexStep = (EdgeVertexStep)nextStep)) {
            JanusGraphEdgeVertexStep estep = new JanusGraphEdgeVertexStep(edgeVertexStep, txVertexCacheSize);
            TraversalHelper.replaceStep((Step)nextStep, (Step)estep, traversal);
        }
    }

    private static void unfoldLocalTraversal(Traversal.Admin<?, ?> traversal, LocalStep<?, ?> localStep, Traversal.Admin localTraversal, MultiQueriable vertexStep) {
        assert (localTraversal.asAdmin().getSteps().size() > 0);
        if (localTraversal.asAdmin().getSteps().size() == 1) {
            assert (localTraversal.getStartStep() == vertexStep);
            vertexStep.setTraversal(traversal);
            TraversalHelper.replaceStep(localStep, (Step)vertexStep, traversal);
        }
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static JanusGraphLocalQueryOptimizerStrategy instance() {
        return INSTANCE;
    }
}

