/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;

public abstract class MultiQueriableStepBatchFetcher<R> {
    private final Set<JanusGraphVertex> verticesToPrefetch = new HashSet<JanusGraphVertex>();
    private Map<JanusGraphVertex, R> multiQueryResults = null;

    public void registerFutureVertexForPrefetching(Vertex futureVertex) {
        this.verticesToPrefetch.add((JanusGraphVertex)futureVertex);
    }

    public R fetchData(Traversal.Admin<?, ?> traversal, Vertex forVertex) {
        if (this.hasNoFetchedData(forVertex)) {
            this.prefetchNextBatch(traversal, forVertex);
        }
        return this.multiQueryResults.get(forVertex);
    }

    protected boolean hasNoFetchedData(Vertex forVertex) {
        return this.multiQueryResults == null || !this.multiQueryResults.containsKey(forVertex);
    }

    public void prefetchNextBatch(Traversal.Admin<?, ?> traversal, Vertex requiredFetchVertex) {
        this.verticesToPrefetch.add((JanusGraphVertex)requiredFetchVertex);
        JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> multiQuery = JanusGraphTraversalUtil.getTx(traversal).multiQuery(this.verticesToPrefetch);
        this.verticesToPrefetch.clear();
        try {
            this.multiQueryResults = this.makeQueryAndExecute(multiQuery);
        }
        catch (JanusGraphException janusGraphException) {
            if (janusGraphException.isCausedBy(InterruptedException.class)) {
                TraversalInterruptedException traversalInterruptedException = new TraversalInterruptedException();
                traversalInterruptedException.initCause((Throwable)janusGraphException);
                throw traversalInterruptedException;
            }
            throw janusGraphException;
        }
    }

    protected abstract Map<JanusGraphVertex, R> makeQueryAndExecute(JanusGraphMultiVertexQuery var1);
}

