/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import java.util.ArrayList;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.MixedIndexCountQuery;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.query.graph.GraphCentricQuery;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.graph.MixedIndexCountQueryBuilder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphStep;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;

public class JanusGraphMixedIndexCountStep<S>
extends ReducingBarrierStep<S, Long>
implements Profiling {
    private final ArrayList<HasContainer> hasContainers = new ArrayList();
    private MixedIndexCountQuery mixedIndexCountQuery = null;
    private boolean done;

    public JanusGraphMixedIndexCountStep(JanusGraphStep janusGraphStep, Traversal.Admin<?, ?> traversal) {
        super(traversal);
        JanusGraphTransaction tx = JanusGraphTraversalUtil.getTx(traversal);
        MixedIndexCountQueryBuilder countQueryBuilder = (MixedIndexCountQueryBuilder)tx.mixedIndexCountQuery();
        GraphCentricQuery query = janusGraphStep.buildGlobalGraphCentricQuery();
        if (query != null && query.getIndexQuery().isFitted()) {
            JointIndexQuery indexQuery = query.getIndexQuery().getBackendQuery();
            this.mixedIndexCountQuery = countQueryBuilder.constructIndex(indexQuery, Vertex.class.isAssignableFrom(janusGraphStep.getReturnClass()) ? ElementCategory.VERTEX : ElementCategory.EDGE);
        }
    }

    public Long projectTraverser(Traverser.Admin<S> traverser) {
        return traverser.bulk();
    }

    public Traverser.Admin<Long> processNextStart() {
        if (!this.done) {
            this.done = true;
            return this.getTraversal().getTraverserGenerator().generate((Object)this.mixedIndexCountQuery.executeTotals(), (Step)this, 1L);
        }
        return this.getTraversal().getTraverserGenerator().generate(EmptyIterator.INSTANCE.next(), (Step)this, 1L);
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    public void setMetrics(MutableMetrics metrics) {
        TP3ProfileWrapper queryProfiler = new TP3ProfileWrapper(metrics);
        this.mixedIndexCountQuery.observeWith(queryProfiler);
    }

    public MixedIndexCountQuery getMixedIndexCountQuery() {
        return this.mixedIndexCountQuery;
    }
}

