/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.computer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.search.path.ShortestPathVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.DefaultComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.util.GraphComputerHelper;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.HaltedTraverserStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;
import org.janusgraph.core.JanusGraphComputer;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.keycolumnvalue.scan.StandardScanner;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.olap.computer.FulgoraMapEmitter;
import org.janusgraph.graphdb.olap.computer.FulgoraMemory;
import org.janusgraph.graphdb.olap.computer.FulgoraReduceEmitter;
import org.janusgraph.graphdb.olap.computer.FulgoraVertexMemory;
import org.janusgraph.graphdb.olap.computer.PartitionedVertexProgramExecutor;
import org.janusgraph.graphdb.olap.computer.VertexMapJob;
import org.janusgraph.graphdb.olap.computer.VertexProgramScanJob;
import org.janusgraph.graphdb.util.WorkerPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FulgoraGraphComputer
implements JanusGraphComputer {
    private static final Logger log = LoggerFactory.getLogger(FulgoraGraphComputer.class);
    private VertexProgram<?> vertexProgram;
    private final Set<MapReduce> mapReduces = new HashSet<MapReduce>();
    private final StandardJanusGraph graph;
    private final int expectedNumVertices = 10000;
    private FulgoraMemory memory;
    private FulgoraVertexMemory vertexMemory;
    private boolean executed = false;
    private int numThreads = 1;
    private final int readBatchSize;
    private final int writeBatchSize;
    private GraphComputer.ResultGraph resultGraphMode = null;
    private GraphComputer.Persist persistMode = null;
    private static final AtomicInteger computerCounter = new AtomicInteger(0);
    private final String name;
    private String jobId;
    private final GraphFilter graphFilter = new GraphFilter();

    public FulgoraGraphComputer(StandardJanusGraph graph, Configuration configuration) {
        this.graph = graph;
        this.writeBatchSize = configuration.get(GraphDatabaseConfiguration.BUFFER_SIZE, new String[0]);
        this.readBatchSize = this.writeBatchSize * 10;
        this.name = "compute" + computerCounter.incrementAndGet();
    }

    public GraphComputer vertices(Traversal<Vertex, Vertex> vertexFilter) {
        this.graphFilter.setVertexFilter(vertexFilter);
        return this;
    }

    public GraphComputer edges(Traversal<Vertex, Edge> edgeFilter) {
        this.graphFilter.setEdgeFilter(edgeFilter);
        return this;
    }

    public GraphComputer result(GraphComputer.ResultGraph resultGraph) {
        Preconditions.checkNotNull((Object)resultGraph, (Object)"Need to specify mode");
        this.resultGraphMode = resultGraph;
        return this;
    }

    public GraphComputer persist(GraphComputer.Persist persist) {
        Preconditions.checkNotNull((Object)persist, (Object)"Need to specify mode");
        this.persistMode = persist;
        return this;
    }

    @Override
    public JanusGraphComputer workers(int threads) {
        Preconditions.checkArgument((threads > 0 ? 1 : 0) != 0, (String)"Invalid number of threads: %s", (int)threads);
        this.numThreads = threads;
        return this;
    }

    public GraphComputer program(VertexProgram vertexProgram) {
        Preconditions.checkState((this.vertexProgram == null ? 1 : 0) != 0, (Object)"A vertex program has already been set");
        this.vertexProgram = vertexProgram;
        return this;
    }

    public GraphComputer mapReduce(MapReduce mapReduce) {
        this.mapReduces.add(mapReduce);
        return this;
    }

    public Future<ComputerResult> submit() {
        this.guardAgainstDuplicateSubmission();
        this.ensureSettingsAreValid();
        this.initializeMemory();
        return CompletableFuture.supplyAsync(this::submitAsync);
    }

    private void guardAgainstDuplicateSubmission() {
        if (this.executed) {
            throw GraphComputer.Exceptions.computerHasAlreadyBeenSubmittedAVertexProgram();
        }
        this.executed = true;
    }

    private void ensureSettingsAreValid() {
        if (null == this.vertexProgram && this.mapReduces.isEmpty()) {
            throw GraphComputer.Exceptions.computerHasNoVertexProgramNorMapReducers();
        }
        if (null != this.vertexProgram) {
            GraphComputerHelper.validateProgramOnComputer((GraphComputer)this, this.vertexProgram);
            this.mapReduces.addAll(this.vertexProgram.getMapReducers());
        }
        this.persistMode = GraphComputerHelper.getPersistState(Optional.ofNullable(this.vertexProgram), Optional.ofNullable(this.persistMode));
        this.resultGraphMode = GraphComputerHelper.getResultGraphState(Optional.ofNullable(this.vertexProgram), Optional.ofNullable(this.resultGraphMode));
        if (!this.features().supportsResultGraphPersistCombination(this.resultGraphMode, this.persistMode)) {
            throw GraphComputer.Exceptions.resultGraphPersistCombinationNotSupported((GraphComputer.ResultGraph)this.resultGraphMode, (GraphComputer.Persist)this.persistMode);
        }
        if (this.numThreads > this.features().getMaxWorkers()) {
            throw GraphComputer.Exceptions.computerRequiresMoreWorkersThanSupported((int)this.numThreads, (int)this.features().getMaxWorkers());
        }
    }

    private void initializeMemory() {
        this.memory = new FulgoraMemory(this.vertexProgram, this.mapReduces);
    }

    private ComputerResult submitAsync() {
        long time = System.currentTimeMillis();
        this.executeVertexProgram();
        Map<MapReduce, FulgoraMapEmitter> mapJobs = this.collectMapJobs();
        this.executeMapJobs(mapJobs);
        Graph resultgraph = this.writeMutatedPropertiesBackIntoGraph();
        this.memory.setRuntime(System.currentTimeMillis() - time);
        this.memory.complete();
        return new DefaultComputerResult(resultgraph, (Memory)this.memory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeVertexProgram() {
        if (null == this.vertexProgram) {
            return;
        }
        this.vertexMemory = new FulgoraVertexMemory(10000, this.graph.getIDManager(), this.vertexProgram);
        this.vertexProgram.setup((Memory)this.memory);
        try (VertexProgramScanJob.Executor job = VertexProgramScanJob.getVertexProgramScanJob(this.graph, this.memory, this.vertexMemory, this.vertexProgram);){
            int iteration = 1;
            while (true) {
                block17: {
                    this.memory.completeSubRound();
                    this.executeIterationOfJob(job, iteration);
                    this.memory.completeSubRound();
                    try {
                        if (!this.vertexProgram.terminate((Memory)this.memory)) break block17;
                        break;
                    }
                    finally {
                        this.memory.incrIteration();
                    }
                }
                ++iteration;
            }
        }
    }

    private void executeIterationOfJob(VertexProgramScanJob.Executor job, int iteration) {
        this.initializeVertexMemoryForIteration();
        StandardScanner.Builder scanBuilder = this.createScanBuilderForJob(job, iteration);
        PartitionedVertexProgramExecutor programExecutor = new PartitionedVertexProgramExecutor(this.graph, this.memory, this.vertexMemory, this.vertexProgram);
        try {
            ScanMetrics jobResult = this.executeOnNonPartitionedVertices(iteration, scanBuilder);
            this.executeOnPartitionedVertices(iteration, programExecutor, jobResult);
        }
        catch (Exception e) {
            throw new JanusGraphException(e);
        }
        this.vertexMemory.completeIteration();
    }

    private void initializeVertexMemoryForIteration() {
        if (this.vertexProgram instanceof ShortestPathVertexProgram) {
            HashSet<MessageScope> locals = new HashSet<MessageScope>();
            locals.add((MessageScope)MessageScope.Local.of(() -> __.bothE((String[])new String[0])));
            locals.add((MessageScope)MessageScope.Global.instance());
            this.vertexMemory.nextIteration(locals);
        } else {
            this.vertexMemory.nextIteration(this.vertexProgram.getMessageScopes((Memory)this.memory));
        }
    }

    private StandardScanner.Builder createScanBuilderForJob(VertexProgramScanJob.Executor job, int iteration) {
        this.jobId = this.name + "#" + iteration;
        StandardScanner.Builder scanBuilder = this.graph.getBackend().buildEdgeScanJob();
        scanBuilder.setJobId(this.jobId);
        scanBuilder.setNumProcessingThreads(this.numThreads);
        scanBuilder.setWorkBlockSize(this.readBatchSize);
        scanBuilder.setJob(job);
        return scanBuilder;
    }

    private ScanMetrics executeOnNonPartitionedVertices(int iteration, StandardScanner.Builder scanBuilder) throws InterruptedException, ExecutionException, BackendException {
        ScanMetrics jobResult = (ScanMetrics)scanBuilder.execute().get();
        long failures = jobResult.get(ScanMetrics.Metric.FAILURE);
        if (failures > 0L) {
            throw new JanusGraphException("Failed to process [" + failures + "] vertices in vertex program iteration [" + iteration + "]. Computer is aborting.");
        }
        return jobResult;
    }

    private void executeOnPartitionedVertices(int iteration, PartitionedVertexProgramExecutor programExecutor, ScanMetrics jobResult) {
        programExecutor.run(this.numThreads, jobResult);
        long failures = jobResult.getCustom("partition-fail");
        if (failures > 0L) {
            throw new JanusGraphException("Failed to process [" + failures + "] partitioned vertices in vertex program iteration [" + iteration + "]. Computer is aborting.");
        }
    }

    private Map<MapReduce, FulgoraMapEmitter> collectMapJobs() {
        HashMap<MapReduce, FulgoraMapEmitter> mapJobs = new HashMap<MapReduce, FulgoraMapEmitter>(this.mapReduces.size());
        for (MapReduce mapReduce : this.mapReduces) {
            if (!mapReduce.doStage(MapReduce.Stage.MAP)) continue;
            FulgoraMapEmitter mapEmitter = new FulgoraMapEmitter(mapReduce.doStage(MapReduce.Stage.REDUCE));
            mapJobs.put(mapReduce, mapEmitter);
        }
        return mapJobs;
    }

    private void executeMapJobs(Map<MapReduce, FulgoraMapEmitter> mapJobs) {
        this.jobId = this.name + "#map";
        try (VertexMapJob.Executor job = VertexMapJob.getVertexMapJob(this.graph, this.vertexMemory, mapJobs);){
            this.executeMapJob(job);
            this.executeReducePhase(mapJobs);
        }
        this.memory.attachReferenceElements(this.graph);
    }

    private void executeMapJob(VertexMapJob.Executor job) {
        StandardScanner.Builder scanBuilder = this.graph.getBackend().buildEdgeScanJob();
        scanBuilder.setJobId(this.jobId);
        scanBuilder.setNumProcessingThreads(this.numThreads);
        scanBuilder.setWorkBlockSize(this.readBatchSize);
        scanBuilder.setJob(job);
        try {
            ScanMetrics jobResult = (ScanMetrics)scanBuilder.execute().get();
            long failures = jobResult.get(ScanMetrics.Metric.FAILURE);
            if (failures > 0L) {
                throw new JanusGraphException("Failed to process [" + failures + "] vertices in map phase. Computer is aborting.");
            }
            failures = jobResult.getCustom("map-fail");
            if (failures > 0L) {
                throw new JanusGraphException("Failed to process [" + failures + "] individual map jobs. Computer is aborting.");
            }
        }
        catch (JanusGraphException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JanusGraphException(e);
        }
    }

    private void executeReducePhase(Map<MapReduce, FulgoraMapEmitter> mapJobs) {
        for (Map.Entry<MapReduce, FulgoraMapEmitter> mapJob : mapJobs.entrySet()) {
            FulgoraMapEmitter mapEmitter = mapJob.getValue();
            MapReduce mapReduce = mapJob.getKey();
            mapEmitter.complete(mapReduce);
            if (mapReduce.doStage(MapReduce.Stage.REDUCE)) {
                FulgoraReduceEmitter reduceEmitter = new FulgoraReduceEmitter();
                try (WorkerPool workers = new WorkerPool(this.numThreads);){
                    workers.submit(() -> mapReduce.workerStart(MapReduce.Stage.REDUCE));
                    for (Map.Entry queueEntry : mapEmitter.reduceMap.entrySet()) {
                        if (null == queueEntry) break;
                        workers.submit(() -> mapReduce.reduce(queueEntry.getKey(), ((Iterable)queueEntry.getValue()).iterator(), (MapReduce.ReduceEmitter)reduceEmitter));
                    }
                    workers.submit(() -> mapReduce.workerEnd(MapReduce.Stage.REDUCE));
                }
                catch (Exception e) {
                    throw new JanusGraphException("Exception while executing reduce phase", e);
                }
                reduceEmitter.complete(mapReduce);
                mapReduce.addResultToMemory((Memory.Admin)this.memory, reduceEmitter.reduceQueue.iterator());
                continue;
            }
            mapReduce.addResultToMemory((Memory.Admin)this.memory, mapEmitter.mapQueue.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Graph writeMutatedPropertiesBackIntoGraph() {
        Transaction resultgraph = this.graph;
        if (this.persistMode == GraphComputer.Persist.NOTHING && this.resultGraphMode == GraphComputer.ResultGraph.NEW) {
            resultgraph = EmptyGraph.instance();
        } else if (this.persistMode != GraphComputer.Persist.NOTHING && this.vertexProgram != null && !this.vertexProgram.getVertexComputeKeys().isEmpty()) {
            JanusGraphManagement management = this.graph.openManagement();
            try {
                for (VertexComputeKey key : this.vertexProgram.getVertexComputeKeys()) {
                    if (!management.containsPropertyKey(key.getKey())) {
                        log.warn("Property key [{}] is not part of the schema and will be created. It is advised to initialize all keys.", (Object)key.getKey());
                    }
                    management.getOrCreatePropertyKey(key.getKey());
                }
                management.commit();
            }
            finally {
                if (management != null && management.isOpen()) {
                    management.rollback();
                }
            }
            HaltedTraverserStrategy haltedTraverserStrategy = HaltedTraverserStrategy.reference();
            Map mutatedProperties = Maps.transformValues(this.vertexMemory.getMutableVertexProperties(), o -> {
                Map nonTransientKeys = Maps.filterKeys((Map)o, s -> !VertexProgramHelper.isTransientVertexComputeKey((String)s, (Set)this.vertexProgram.getVertexComputeKeys()));
                return Maps.transformEntries((Map)nonTransientKeys, (k, v) -> {
                    if (k != null && k.equals("gremlin.traversalVertexProgram.haltedTraversers") && v instanceof TraverserSet) {
                        TraverserSet halted = new TraverserSet();
                        for (Traverser.Admin t : (TraverserSet)v) {
                            halted.add(haltedTraverserStrategy.halt(t));
                        }
                        return halted;
                    }
                    return v;
                });
            });
            if (this.resultGraphMode == GraphComputer.ResultGraph.ORIGINAL) {
                AtomicInteger failures = new AtomicInteger(0);
                try (WorkerPool workers = new WorkerPool(this.numThreads);){
                    ArrayList subset = new ArrayList(this.writeBatchSize / this.vertexProgram.getVertexComputeKeys().size());
                    int currentSize = 0;
                    for (Map.Entry entry : mutatedProperties.entrySet()) {
                        subset.add(entry);
                        if ((currentSize += ((Map)entry.getValue()).size()) < this.writeBatchSize) continue;
                        workers.submit(new VertexPropertyWriter(subset, failures));
                        subset = new ArrayList(subset.size());
                        currentSize = 0;
                    }
                    if (!subset.isEmpty()) {
                        workers.submit(new VertexPropertyWriter(subset, failures));
                    }
                }
                catch (Exception e) {
                    throw new JanusGraphException("Exception while attempting to persist result into graph", e);
                }
                if (failures.get() > 0) {
                    throw new JanusGraphException("Could not persist program results to graph. Check log for details.");
                }
            } else if (this.resultGraphMode == GraphComputer.ResultGraph.NEW) {
                resultgraph = this.graph.newTransaction();
                for (Map.Entry vertexProperty : mutatedProperties.entrySet()) {
                    Vertex v = (Vertex)resultgraph.vertices(new Object[]{vertexProperty.getKey()}).next();
                    for (Map.Entry prop : ((Map)vertexProperty.getValue()).entrySet()) {
                        if (prop.getValue() instanceof List) {
                            ((List)prop.getValue()).forEach(value -> v.property(VertexProperty.Cardinality.list, (String)prop.getKey(), value, new Object[0]));
                            continue;
                        }
                        v.property(VertexProperty.Cardinality.single, (String)prop.getKey(), prop.getValue(), new Object[0]);
                    }
                }
            }
        }
        return resultgraph;
    }

    public String toString() {
        return StringFactory.graphComputerString((GraphComputer)this);
    }

    public GraphComputer.Features features() {
        return new GraphComputer.Features(){

            public boolean supportsVertexAddition() {
                return false;
            }

            public boolean supportsVertexRemoval() {
                return false;
            }

            public boolean supportsVertexPropertyAddition() {
                return true;
            }

            public boolean supportsVertexPropertyRemoval() {
                return false;
            }

            public boolean supportsEdgeAddition() {
                return false;
            }

            public boolean supportsEdgeRemoval() {
                return false;
            }

            public boolean supportsEdgePropertyAddition() {
                return false;
            }

            public boolean supportsEdgePropertyRemoval() {
                return false;
            }

            public boolean supportsGraphFilter() {
                return false;
            }
        };
    }

    private class VertexPropertyWriter
    implements Runnable {
        private final List<Map.Entry<Long, Map<String, Object>>> properties;
        private final AtomicInteger failures;

        private VertexPropertyWriter(List<Map.Entry<Long, Map<String, Object>>> properties, AtomicInteger failures) {
            assert (properties != null && !properties.isEmpty() && failures != null);
            this.properties = properties;
            this.failures = failures;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JanusGraphTransaction tx = FulgoraGraphComputer.this.graph.buildTransaction().enableBatchLoading().start();
            try {
                for (Map.Entry<Long, Map<String, Object>> vertexProperty : this.properties) {
                    JanusGraphVertex v = tx.getVertex(vertexProperty.getKey());
                    if (v == null) continue;
                    for (Map.Entry<String, Object> prop : vertexProperty.getValue().entrySet()) {
                        v.property(VertexProperty.Cardinality.single, prop.getKey(), prop.getValue(), new Object[0]);
                    }
                }
                tx.commit();
            }
            catch (Throwable e) {
                this.failures.incrementAndGet();
                log.error("Encountered exception while trying to write properties: ", e);
            }
            finally {
                if (tx != null && tx.isOpen()) {
                    tx.rollback();
                }
            }
        }
    }
}

