/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockStatus$;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus$NonRddStorageInfo$;
import org.apache.spark.storage.StorageStatus$RddStorageInfo$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.MapLike;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t]g!\u0002.\\\u0001u\u001b\u0007\u0002\u00036\u0001\u0005\u000b\u0007I\u0011\u00017\t\u0011E\u0004!\u0011!Q\u0001\n5D\u0001B\u001d\u0001\u0003\u0006\u0004%\ta\u001d\u0005\to\u0002\u0011\t\u0011)A\u0005i\"A\u0001\u0010\u0001BC\u0002\u0013\u0005\u0011\u0010\u0003\u0005~\u0001\t\u0005\t\u0015!\u0003{\u0011!q\bA!b\u0001\n\u0003I\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!I\u0011q\u0002\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u0002\u0014!I\u0011Q\b\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u0002B\u00191\u0011Q\t\u0001E\u0003\u000fB\u0011\"!\u0016\u000f\u0005+\u0007I\u0011A:\t\u0013\u0005]cB!E!\u0002\u0013!\b\"CA-\u001d\tU\r\u0011\"\u0001t\u0011%\tYF\u0004B\tB\u0003%A\u000f\u0003\u0006\u0002^9\u0011)\u001a!C\u0001\u0003?B!\"a\u001a\u000f\u0005#\u0005\u000b\u0011BA1\u0011\u001d\t\tA\u0004C\u0001\u0003SB\u0011\"!\u001e\u000f\u0003\u0003%\t!a\u001e\t\u0013\u0005}d\"%A\u0005\u0002\u0005\u0005\u0005\"CAL\u001dE\u0005I\u0011AAA\u0011%\tIJDI\u0001\n\u0003\tY\nC\u0005\u0002 :\t\t\u0011\"\u0011\u0002\"\"I\u00111\u0017\b\u0002\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003os\u0011\u0011!C\u0001\u0003sC\u0011\"!2\u000f\u0003\u0003%\t%a2\t\u0013\u0005Eg\"!A\u0005\u0002\u0005M\u0007\"CAo\u001d\u0005\u0005I\u0011IAp\u0011%\t\tODA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002f:\t\t\u0011\"\u0011\u0002h\u001eI\u00111\u001e\u0001\u0002\u0002#%\u0011Q\u001e\u0004\n\u0003\u000b\u0002\u0011\u0011!E\u0005\u0003_Dq!!\u0001$\t\u0003\ti\u0010C\u0005\u0002b\u000e\n\t\u0011\"\u0012\u0002d\"I\u0011q`\u0012\u0002\u0002\u0013\u0005%\u0011\u0001\u0005\n\u0005\u0013\u0019\u0013\u0011!CA\u0005\u0017A\u0011B!\u0007\u0001\u0005\u0004%IAa\u0007\t\u0011\t}\u0001\u0001)A\u0005\u0005;1aA!\t\u0001\t\n\r\u0002\"\u0003B\u0013U\tE\r\u0011\"\u0001t\u0011)\u00119C\u000bBA\u0002\u0013\u0005!\u0011\u0006\u0005\n\u0005gQ#\u0011#Q!\nQD\u0011B!\u000e+\u0005#\u0007I\u0011A:\t\u0015\t]\"F!a\u0001\n\u0003\u0011I\u0004C\u0005\u0003>)\u0012\t\u0012)Q\u0005i\"I\u0011\u0011\f\u0016\u0003\u0012\u0004%\ta\u001d\u0005\u000b\u0005\u007fQ#\u00111A\u0005\u0002\t\u0005\u0003\"CA.U\tE\t\u0015)\u0003u\u0011\u001d\t\tA\u000bC\u0001\u0005\u000bB\u0011\"!\u001e+\u0003\u0003%\tAa\u0014\t\u0013\u0005}$&%A\u0005\u0002\u0005\u0005\u0005\"CALUE\u0005I\u0011AAA\u0011%\tIJKI\u0001\n\u0003\t\t\tC\u0005\u0002 *\n\t\u0011\"\u0011\u0002\"\"I\u00111\u0017\u0016\u0002\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003oS\u0013\u0011!C\u0001\u0005/B\u0011\"!2+\u0003\u0003%\t%a2\t\u0013\u0005E'&!A\u0005\u0002\tm\u0003\"CAoU\u0005\u0005I\u0011IAp\u0011%\t\tOKA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002f*\n\t\u0011\"\u0011\u0003`\u001dI!1\r\u0001\u0002\u0002#%!Q\r\u0004\n\u0005C\u0001\u0011\u0011!E\u0005\u0005OBq!!\u0001C\t\u0003\u0011Y\u0007C\u0005\u0002b\n\u000b\t\u0011\"\u0012\u0002d\"I\u0011q \"\u0002\u0002\u0013\u0005%Q\u000e\u0005\n\u0005\u0013\u0011\u0015\u0011!CA\u0005kB\u0011B! \u0001\u0005\u0004%IAa \t\u0011\t\u0005\u0005\u0001)A\u0005\u0005\u000fBq!!\u0001\u0001\t\u0003\u0011\u0019\tC\u0004\u0003\u0018\u0002!\tA!'\t\u000f\tm\u0005\u0001\"\u0001\u0003\u001a\"A!Q\u0014\u0001\u0005\u0002u\u0013y\nC\u0004\u0003*\u0002!\tAa+\t\r\tE\u0006\u0001\"\u0001t\u0011\u0019\u0011\u0019\f\u0001C\u0001g\"1!Q\u0017\u0001\u0005\u0002MDaAa.\u0001\t\u0003I\bB\u0002B]\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0003<\u0002!\t!\u001f\u0005\u0007\u0005{\u0003A\u0011A=\t\r\t}\u0006\u0001\"\u0001z\u0011\u0019\u0011\t\r\u0001C\u0001s\"1!1\u0019\u0001\u0005\u0002MDqA!2\u0001\t\u0003\u00119\rC\u0004\u0003N\u0002!IAa4\u0003\u001bM#xN]1hKN#\u0018\r^;t\u0015\taV,A\u0004ti>\u0014\u0018mZ3\u000b\u0005y{\u0016!B:qCJ\\'B\u00011b\u0003\u0019\t\u0007/Y2iK*\t!-A\u0002pe\u001e\u001c\"\u0001\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\r\u0005s\u0017PU3g\u00039\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\u001c\u0001!F\u0001n!\tqw.D\u0001\\\u0013\t\u00018L\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\u0002\u001f\tdwnY6NC:\fw-\u001a:JI\u0002\n\u0011\"\\1y\u001b\u0016lwN]=\u0016\u0003Q\u0004\"!Z;\n\u0005Y4'\u0001\u0002'p]\u001e\f!\"\\1y\u001b\u0016lwN]=!\u00031i\u0017\r_(o\u0011\u0016\f\u0007/T3n+\u0005Q\bcA3|i&\u0011AP\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001b5\f\u0007p\u00148IK\u0006\u0004X*Z7!\u00035i\u0017\r_(gM\"+\u0017\r]'f[\u0006qQ.\u0019=PM\u001aDU-\u00199NK6\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0006\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\u0001\"A\u001c\u0001\t\u000b)L\u0001\u0019A7\t\u000bIL\u0001\u0019\u0001;\t\u000baL\u0001\u0019\u0001>\t\u000byL\u0001\u0019\u0001>\u0002\u0015}\u0013H\r\u001a\"m_\u000e\\7/\u0006\u0002\u0002\u0014AA\u0011QCA\u0010\u0003G\tI#\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u001diW\u000f^1cY\u0016T1!!\bg\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\t9BA\u0004ICNDW*\u00199\u0011\u0007\u0015\f)#C\u0002\u0002(\u0019\u00141!\u00138u!!\t)\"a\u000b\u00020\u0005U\u0012\u0002BA\u0017\u0003/\u00111!T1q!\rq\u0017\u0011G\u0005\u0004\u0003gY&a\u0002\"m_\u000e\\\u0017\n\u001a\t\u0004]\u0006]\u0012bAA\u001d7\nY!\t\\8dWN#\u0018\r^;t\u0003-y&\u000f\u001a3CY>\u001c7n\u001d\u0011\u0002\u001b}swN\u001c*eI\ncwnY6t+\t\t\t\u0005\u0005\u0005\u0002\u0016\u0005}\u0011qFA\u001b\u00039yfn\u001c8SI\u0012\u0014En\\2lg\u0002\u0012aB\u00153e'R|'/Y4f\u0013:4wn\u0005\u0004\u000fI\u0006%\u0013q\n\t\u0004K\u0006-\u0013bAA'M\n9\u0001K]8ek\u000e$\bcA3\u0002R%\u0019\u00111\u000b4\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u00175,Wn\u001c:z+N\fw-Z\u0001\r[\u0016lwN]=Vg\u0006<W\rI\u0001\nI&\u001c8.V:bO\u0016\f!\u0002Z5tWV\u001b\u0018mZ3!\u0003\u0015aWM^3m+\t\t\t\u0007E\u0002o\u0003GJ1!!\u001a\\\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0003\u0019aWM^3mAQA\u00111NA8\u0003c\n\u0019\bE\u0002\u0002n9i\u0011\u0001\u0001\u0005\u0007\u0003+*\u0002\u0019\u0001;\t\r\u0005eS\u00031\u0001u\u0011\u001d\ti&\u0006a\u0001\u0003C\nAaY8qsRA\u00111NA=\u0003w\ni\b\u0003\u0005\u0002VY\u0001\n\u00111\u0001u\u0011!\tIF\u0006I\u0001\u0002\u0004!\b\"CA/-A\u0005\t\u0019AA1\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a!+\u0007Q\f)i\u000b\u0002\u0002\bB!\u0011\u0011RAJ\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015!C;oG\",7m[3e\u0015\r\t\tJZ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAK\u0003\u0017\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u001e*\"\u0011\u0011MAC\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0016\u0001\u00026bm\u0006LA!!-\u0002(\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\t\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111XAa!\r)\u0017QX\u0005\u0004\u0003\u007f3'aA!os\"I\u00111\u0019\u000f\u0002\u0002\u0003\u0007\u00111E\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005%\u0007CBAf\u0003\u001b\fY,\u0004\u0002\u0002\u001c%!\u0011qZA\u000e\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005U\u00171\u001c\t\u0004K\u0006]\u0017bAAmM\n9!i\\8mK\u0006t\u0007\"CAb=\u0005\u0005\t\u0019AA^\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0012\u0003!!xn\u0015;sS:<GCAAR\u0003\u0019)\u0017/^1mgR!\u0011Q[Au\u0011%\t\u0019-IA\u0001\u0002\u0004\tY,\u0001\bSI\u0012\u001cFo\u001c:bO\u0016LeNZ8\u0011\u0007\u000554eE\u0003$\u0003c\fy\u0005\u0005\u0006\u0002t\u0006eH\u000f^A1\u0003Wj!!!>\u000b\u0007\u0005]h-A\u0004sk:$\u0018.\\3\n\t\u0005m\u0018Q\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAAw\u0003\u0015\t\u0007\u000f\u001d7z)!\tYGa\u0001\u0003\u0006\t\u001d\u0001BBA+M\u0001\u0007A\u000f\u0003\u0004\u0002Z\u0019\u0002\r\u0001\u001e\u0005\b\u0003;2\u0003\u0019AA1\u0003\u001d)h.\u00199qYf$BA!\u0004\u0003\u0016A!Qm\u001fB\b!\u001d)'\u0011\u0003;u\u0003CJ1Aa\u0005g\u0005\u0019!V\u000f\u001d7fg!I!qC\u0014\u0002\u0002\u0003\u0007\u00111N\u0001\u0004q\u0012\u0002\u0014aD0sI\u0012\u001cFo\u001c:bO\u0016LeNZ8\u0016\u0005\tu\u0001\u0003CA\u000b\u0003?\t\u0019#a\u001b\u0002!}\u0013H\rZ*u_J\fw-Z%oM>\u0004#!\u0005(p]J#Gm\u0015;pe\u0006<W-\u00138g_N1!\u0006ZA%\u0003\u001f\n1b\u001c8IK\u0006\u0004Xk]1hK\u0006yqN\u001c%fCB,6/Y4f?\u0012*\u0017\u000f\u0006\u0003\u0003,\tE\u0002cA3\u0003.%\u0019!q\u00064\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0007d\u0013\u0011!a\u0001i\u0006aqN\u001c%fCB,6/Y4fA\u0005aqN\u001a4IK\u0006\u0004Xk]1hK\u0006\u0001rN\u001a4IK\u0006\u0004Xk]1hK~#S-\u001d\u000b\u0005\u0005W\u0011Y\u0004\u0003\u0005\u0002D>\n\t\u00111\u0001u\u00035ygM\u001a%fCB,6/Y4fA\u0005iA-[:l+N\fw-Z0%KF$BAa\u000b\u0003D!A\u00111\u0019\u001a\u0002\u0002\u0003\u0007A\u000f\u0006\u0005\u0003H\t%#1\nB'!\r\tiG\u000b\u0005\u0007\u0005K!\u0004\u0019\u0001;\t\r\tUB\u00071\u0001u\u0011\u0019\tI\u0006\u000ea\u0001iRA!q\tB)\u0005'\u0012)\u0006\u0003\u0005\u0003&U\u0002\n\u00111\u0001u\u0011!\u0011)$\u000eI\u0001\u0002\u0004!\b\u0002CA-kA\u0005\t\u0019\u0001;\u0015\t\u0005m&\u0011\f\u0005\n\u0003\u0007\\\u0014\u0011!a\u0001\u0003G!B!!6\u0003^!I\u00111Y\u001f\u0002\u0002\u0003\u0007\u00111\u0018\u000b\u0005\u0003+\u0014\t\u0007C\u0005\u0002D\u0002\u000b\t\u00111\u0001\u0002<\u0006\tbj\u001c8SI\u0012\u001cFo\u001c:bO\u0016LeNZ8\u0011\u0007\u00055$iE\u0003C\u0005S\ny\u0005E\u0005\u0002t\u0006eH\u000f\u001e;\u0003HQ\u0011!Q\r\u000b\t\u0005\u000f\u0012yG!\u001d\u0003t!1!QE#A\u0002QDaA!\u000eF\u0001\u0004!\bBBA-\u000b\u0002\u0007A\u000f\u0006\u0003\u0003x\tm\u0004\u0003B3|\u0005s\u0002b!\u001aB\tiR$\b\"\u0003B\f\r\u0006\u0005\t\u0019\u0001B$\u0003Iyfn\u001c8SI\u0012\u001cFo\u001c:bO\u0016LeNZ8\u0016\u0005\t\u001d\u0013aE0o_:\u0014F\rZ*u_J\fw-Z%oM>\u0004C\u0003DA\u0003\u0005\u000b\u0013IIa#\u0003\u000e\n=\u0005B\u0002BD\u0013\u0002\u0007Q.\u0001\u0003c[&$\u0007\"\u0002:J\u0001\u0004!\b\"\u0002=J\u0001\u0004Q\b\"\u0002@J\u0001\u0004Q\bb\u0002BI\u0013\u0002\u0007!1S\u0001\u000eS:LG/[1m\u00052|7m[:\u0011\u0011\u0005-'QSA\u0018\u0003kIA!!\f\u0002\u001c\u00051!\r\\8dWN,\"Aa%\u0002\u0013I$GM\u00117pG.\u001c\u0018\u0001C1eI\ncwnY6\u0015\r\t-\"\u0011\u0015BS\u0011\u001d\u0011\u0019\u000b\u0014a\u0001\u0003_\tqA\u00197pG.LE\rC\u0004\u0003(2\u0003\r!!\u000e\u0002\u0017\tdwnY6Ti\u0006$Xo]\u0001\tO\u0016$(\t\\8dWR!!Q\u0016BX!\u0011)70!\u000e\t\u000f\t\rV\n1\u0001\u00020\u00051Q.\u0019=NK6\fA\"\\3n%\u0016l\u0017-\u001b8j]\u001e\fq!\\3n+N,G-\u0001\np]\"+\u0017\r]'f[J+W.Y5oS:<\u0017aE8gM\"+\u0017\r]'f[J+W.Y5oS:<\u0017!D8o\u0011\u0016\f\u0007/T3n+N,G-\u0001\bpM\u001aDU-\u00199NK6,6/\u001a3\u0002\u001f=t\u0007*Z1q\u0007\u0006\u001c\u0007.Z*ju\u0016\f\u0001c\u001c4g\u0011\u0016\f\u0007oQ1dQ\u0016\u001c\u0016N_3\u0002\u0011\u0011L7o[+tK\u0012\fQ\u0002Z5tWV\u001bX\r\u001a\"z%\u0012$Gc\u0001;\u0003J\"9!1\u001a-A\u0002\u0005\r\u0012!\u0002:eI&#\u0017!E;qI\u0006$Xm\u0015;pe\u0006<W-\u00138g_R1!1\u0006Bi\u0005'DqAa)Z\u0001\u0004\ty\u0003C\u0004\u0003Vf\u0003\r!!\u000e\u0002\u001d9,wO\u00117pG.\u001cF/\u0019;vg\u0002")
public class StorageStatus {
    private volatile StorageStatus$RddStorageInfo$ RddStorageInfo$module;
    private volatile StorageStatus$NonRddStorageInfo$ NonRddStorageInfo$module;
    private final BlockManagerId blockManagerId;
    private final long maxMemory;
    private final Option<Object> maxOnHeapMem;
    private final Option<Object> maxOffHeapMem;
    private final HashMap<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> _rddBlocks;
    private final HashMap<BlockId, BlockStatus> _nonRddBlocks;
    private final HashMap<Object, RddStorageInfo> _rddStorageInfo;
    private final NonRddStorageInfo _nonRddStorageInfo;

    private StorageStatus$RddStorageInfo$ RddStorageInfo() {
        if (this.RddStorageInfo$module == null) {
            this.RddStorageInfo$lzycompute$1();
        }
        return this.RddStorageInfo$module;
    }

    private StorageStatus$NonRddStorageInfo$ NonRddStorageInfo() {
        if (this.NonRddStorageInfo$module == null) {
            this.NonRddStorageInfo$lzycompute$1();
        }
        return this.NonRddStorageInfo$module;
    }

    public BlockManagerId blockManagerId() {
        return this.blockManagerId;
    }

    public long maxMemory() {
        return this.maxMemory;
    }

    public Option<Object> maxOnHeapMem() {
        return this.maxOnHeapMem;
    }

    public Option<Object> maxOffHeapMem() {
        return this.maxOffHeapMem;
    }

    private HashMap<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> _rddBlocks() {
        return this._rddBlocks;
    }

    private HashMap<BlockId, BlockStatus> _nonRddBlocks() {
        return this._nonRddBlocks;
    }

    private HashMap<Object, RddStorageInfo> _rddStorageInfo() {
        return this._rddStorageInfo;
    }

    private NonRddStorageInfo _nonRddStorageInfo() {
        return this._nonRddStorageInfo;
    }

    public Map<BlockId, BlockStatus> blocks() {
        return this._nonRddBlocks().$plus$plus(this.rddBlocks());
    }

    public Map<BlockId, BlockStatus> rddBlocks() {
        return (Map)this._rddBlocks().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            scala.collection.mutable.Map blocks;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.mutable.Map map = blocks = (scala.collection.mutable.Map)tuple2._2();
            return map;
        }, HashMap$.MODULE$.canBuildFrom());
    }

    public void addBlock(BlockId blockId, BlockStatus blockStatus) {
        this.updateStorageInfo(blockId, blockStatus);
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            ((MapLike)this._rddBlocks().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rddId), (Function0 & Serializable & scala.Serializable)() -> new HashMap())).update((Object)blockId, (Object)blockStatus);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this._nonRddBlocks().update((Object)blockId, (Object)blockStatus);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<BlockStatus> getBlock(BlockId blockId) {
        Option option;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            option = this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get((Object)blockId));
        } else {
            option = this._nonRddBlocks().get((Object)blockId);
        }
        return option;
    }

    public long maxMem() {
        return this.maxMemory();
    }

    public long memRemaining() {
        return this.maxMem() - this.memUsed();
    }

    public long memUsed() {
        return BoxesRunTime.unboxToLong((Object)this.onHeapMemUsed().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) + BoxesRunTime.unboxToLong((Object)this.offHeapMemUsed().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public Option<Object> onHeapMemRemaining() {
        return this.maxOnHeapMem().flatMap((Function1 & Serializable & scala.Serializable)m -> StorageStatus.$anonfun$onHeapMemRemaining$1(this, BoxesRunTime.unboxToLong((Object)m)));
    }

    public Option<Object> offHeapMemRemaining() {
        return this.maxOffHeapMem().flatMap((Function1 & Serializable & scala.Serializable)m -> StorageStatus.$anonfun$offHeapMemRemaining$1(this, BoxesRunTime.unboxToLong((Object)m)));
    }

    public Option<Object> onHeapMemUsed() {
        return this.onHeapCacheSize().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$2 -> x$2 + this._nonRddStorageInfo().onHeapUsage());
    }

    public Option<Object> offHeapMemUsed() {
        return this.offHeapCacheSize().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$3 -> x$3 + this._nonRddStorageInfo().offHeapUsage());
    }

    public Option<Object> onHeapCacheSize() {
        return this.maxOnHeapMem().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$4 -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)this._rddStorageInfo().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, RddStorageInfo>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RddStorageInfo storageInfo;
                A1 A1 = x1;
                Object object = A1 != null && !(storageInfo = (RddStorageInfo)A1._2()).level().useOffHeap() ? BoxesRunTime.boxToLong((long)storageInfo.memoryUsage()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, RddStorageInfo> x1) {
                RddStorageInfo storageInfo;
                Tuple2<Object, RddStorageInfo> tuple2 = x1;
                boolean bl = tuple2 != null && !(storageInfo = (RddStorageInfo)tuple2._2()).level().useOffHeap();
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
    }

    public Option<Object> offHeapCacheSize() {
        return this.maxOffHeapMem().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$5 -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)this._rddStorageInfo().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, RddStorageInfo>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RddStorageInfo storageInfo;
                A1 A1 = x1;
                Object object = A1 != null && (storageInfo = (RddStorageInfo)A1._2()).level().useOffHeap() ? BoxesRunTime.boxToLong((long)storageInfo.memoryUsage()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, RddStorageInfo> x1) {
                RddStorageInfo storageInfo;
                Tuple2<Object, RddStorageInfo> tuple2 = x1;
                boolean bl = tuple2 != null && (storageInfo = (RddStorageInfo)tuple2._2()).level().useOffHeap();
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
    }

    public long diskUsed() {
        return this._nonRddStorageInfo().diskUsage() + BoxesRunTime.unboxToLong((Object)((TraversableOnce)this._rddBlocks().keys().toSeq().map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)rddId -> this.diskUsedByRdd(rddId), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long diskUsedByRdd(int rddId) {
        return BoxesRunTime.unboxToLong((Object)this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.diskUsage())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    private void updateStorageInfo(BlockId blockId, BlockStatus newBlockStatus) {
        Tuple2.mcJJ.sp sp2;
        BlockStatus oldBlockStatus = (BlockStatus)this.getBlock(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> BlockStatus$.MODULE$.empty());
        long changeInMem = newBlockStatus.memSize() - oldBlockStatus.memSize();
        long changeInDisk = newBlockStatus.diskSize() - oldBlockStatus.diskSize();
        StorageLevel level = newBlockStatus.storageLevel();
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            sp2 = (Tuple2)this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                RddStorageInfo rddStorageInfo = x0$1;
                if (rddStorageInfo == null) {
                    throw new MatchError((Object)rddStorageInfo);
                }
                long mem = rddStorageInfo.memoryUsage();
                long disk = rddStorageInfo.diskUsage();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(mem, disk);
                return sp2;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcJJ.sp(0L, 0L));
        } else if (!level.useOffHeap()) {
            sp2 = new Tuple2.mcJJ.sp(this._nonRddStorageInfo().onHeapUsage(), this._nonRddStorageInfo().diskUsage());
        } else if (level.useOffHeap()) {
            sp2 = new Tuple2.mcJJ.sp(this._nonRddStorageInfo().offHeapUsage(), this._nonRddStorageInfo().diskUsage());
        } else {
            throw new MatchError((Object)blockId2);
        }
        Tuple2.mcJJ.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        long oldMem = sp3._1$mcJ$sp();
        long oldDisk = sp3._2$mcJ$sp();
        Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(oldMem, oldDisk);
        Tuple2.mcJJ.sp sp5 = sp4;
        long oldMem2 = sp5._1$mcJ$sp();
        long oldDisk2 = sp5._2$mcJ$sp();
        long newMem = package$.MODULE$.max(oldMem2 + changeInMem, 0L);
        long newDisk = package$.MODULE$.max(oldDisk2 + changeInDisk, 0L);
        BlockId blockId3 = blockId;
        if (blockId3 instanceof RDDBlockId) {
            BoxedUnit boxedUnit;
            RDDBlockId rDDBlockId = (RDDBlockId)blockId3;
            int rddId = rDDBlockId.rddId();
            if (newMem + newDisk == 0L) {
                this._rddStorageInfo().remove((Object)BoxesRunTime.boxToInteger((int)rddId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this._rddStorageInfo().update((Object)BoxesRunTime.boxToInteger((int)rddId), (Object)new RddStorageInfo(this, newMem, newDisk, level));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            if (!level.useOffHeap()) {
                this._nonRddStorageInfo().onHeapUsage_$eq(newMem);
            } else {
                this._nonRddStorageInfo().offHeapUsage_$eq(newMem);
            }
            this._nonRddStorageInfo().diskUsage_$eq(newDisk);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void RddStorageInfo$lzycompute$1() {
        StorageStatus storageStatus = this;
        synchronized (storageStatus) {
            if (this.RddStorageInfo$module == null) {
                this.RddStorageInfo$module = new StorageStatus$RddStorageInfo$(this);
            }
        }
    }

    private final void NonRddStorageInfo$lzycompute$1() {
        StorageStatus storageStatus = this;
        synchronized (storageStatus) {
            if (this.NonRddStorageInfo$module == null) {
                this.NonRddStorageInfo$module = new StorageStatus$NonRddStorageInfo$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$1(StorageStatus $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BlockId bid = (BlockId)tuple2._1();
        BlockStatus bstatus = (BlockStatus)tuple2._2();
        $this.addBlock(bid, bstatus);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Option $anonfun$onHeapMemRemaining$1(StorageStatus $this, long m) {
        return $this.onHeapMemUsed().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)o -> m - o);
    }

    public static final /* synthetic */ Option $anonfun$offHeapMemRemaining$1(StorageStatus $this, long m) {
        return $this.offHeapMemUsed().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)o -> m - o);
    }

    public StorageStatus(BlockManagerId blockManagerId, long maxMemory, Option<Object> maxOnHeapMem, Option<Object> maxOffHeapMem) {
        this.blockManagerId = blockManagerId;
        this.maxMemory = maxMemory;
        this.maxOnHeapMem = maxOnHeapMem;
        this.maxOffHeapMem = maxOffHeapMem;
        this._rddBlocks = new HashMap();
        this._nonRddBlocks = new HashMap();
        this._rddStorageInfo = new HashMap();
        this._nonRddStorageInfo = new NonRddStorageInfo(this, 0L, 0L, 0L);
    }

    public StorageStatus(BlockManagerId bmid, long maxMemory, Option<Object> maxOnHeapMem, Option<Object> maxOffHeapMem, Map<BlockId, BlockStatus> initialBlocks) {
        this(bmid, maxMemory, maxOnHeapMem, maxOffHeapMem);
        initialBlocks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StorageStatus.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public class NonRddStorageInfo
    implements Product,
    scala.Serializable {
        private long onHeapUsage;
        private long offHeapUsage;
        private long diskUsage;
        public final /* synthetic */ StorageStatus $outer;

        public long onHeapUsage() {
            return this.onHeapUsage;
        }

        public void onHeapUsage_$eq(long x$1) {
            this.onHeapUsage = x$1;
        }

        public long offHeapUsage() {
            return this.offHeapUsage;
        }

        public void offHeapUsage_$eq(long x$1) {
            this.offHeapUsage = x$1;
        }

        public long diskUsage() {
            return this.diskUsage;
        }

        public void diskUsage_$eq(long x$1) {
            this.diskUsage = x$1;
        }

        public NonRddStorageInfo copy(long onHeapUsage, long offHeapUsage, long diskUsage) {
            return new NonRddStorageInfo(this.org$apache$spark$storage$StorageStatus$NonRddStorageInfo$$$outer(), onHeapUsage, offHeapUsage, diskUsage);
        }

        public long copy$default$1() {
            return this.onHeapUsage();
        }

        public long copy$default$2() {
            return this.offHeapUsage();
        }

        public long copy$default$3() {
            return this.diskUsage();
        }

        public String productPrefix() {
            return "NonRddStorageInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Long l;
            int n = x$1;
            switch (n) {
                case 0: {
                    l = BoxesRunTime.boxToLong((long)this.onHeapUsage());
                    break;
                }
                case 1: {
                    l = BoxesRunTime.boxToLong((long)this.offHeapUsage());
                    break;
                }
                case 2: {
                    l = BoxesRunTime.boxToLong((long)this.diskUsage());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return l;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NonRddStorageInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.onHeapUsage()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.offHeapUsage()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.diskUsage()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NonRddStorageInfo)) return false;
            if (((NonRddStorageInfo)object).org$apache$spark$storage$StorageStatus$NonRddStorageInfo$$$outer() != this.org$apache$spark$storage$StorageStatus$NonRddStorageInfo$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            NonRddStorageInfo nonRddStorageInfo = (NonRddStorageInfo)x$1;
            if (this.onHeapUsage() != nonRddStorageInfo.onHeapUsage()) return false;
            if (this.offHeapUsage() != nonRddStorageInfo.offHeapUsage()) return false;
            if (this.diskUsage() != nonRddStorageInfo.diskUsage()) return false;
            if (!nonRddStorageInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ StorageStatus org$apache$spark$storage$StorageStatus$NonRddStorageInfo$$$outer() {
            return this.$outer;
        }

        public NonRddStorageInfo(StorageStatus $outer, long onHeapUsage, long offHeapUsage, long diskUsage) {
            this.onHeapUsage = onHeapUsage;
            this.offHeapUsage = offHeapUsage;
            this.diskUsage = diskUsage;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class RddStorageInfo
    implements Product,
    scala.Serializable {
        private final long memoryUsage;
        private final long diskUsage;
        private final StorageLevel level;
        public final /* synthetic */ StorageStatus $outer;

        public long memoryUsage() {
            return this.memoryUsage;
        }

        public long diskUsage() {
            return this.diskUsage;
        }

        public StorageLevel level() {
            return this.level;
        }

        public RddStorageInfo copy(long memoryUsage, long diskUsage, StorageLevel level) {
            return new RddStorageInfo(this.org$apache$spark$storage$StorageStatus$RddStorageInfo$$$outer(), memoryUsage, diskUsage, level);
        }

        public long copy$default$1() {
            return this.memoryUsage();
        }

        public long copy$default$2() {
            return this.diskUsage();
        }

        public StorageLevel copy$default$3() {
            return this.level();
        }

        public String productPrefix() {
            return "RddStorageInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Serializable serializable;
            int n = x$1;
            switch (n) {
                case 0: {
                    serializable = BoxesRunTime.boxToLong((long)this.memoryUsage());
                    break;
                }
                case 1: {
                    serializable = BoxesRunTime.boxToLong((long)this.diskUsage());
                    break;
                }
                case 2: {
                    serializable = this.level();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return serializable;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RddStorageInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.memoryUsage()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.diskUsage()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.level()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RddStorageInfo)) return false;
            if (((RddStorageInfo)object).org$apache$spark$storage$StorageStatus$RddStorageInfo$$$outer() != this.org$apache$spark$storage$StorageStatus$RddStorageInfo$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            RddStorageInfo rddStorageInfo = (RddStorageInfo)x$1;
            if (this.memoryUsage() != rddStorageInfo.memoryUsage()) return false;
            if (this.diskUsage() != rddStorageInfo.diskUsage()) return false;
            StorageLevel storageLevel = this.level();
            StorageLevel storageLevel2 = rddStorageInfo.level();
            if (storageLevel == null) {
                if (storageLevel2 != null) {
                    return false;
                }
            } else if (!((Object)storageLevel).equals(storageLevel2)) return false;
            if (!rddStorageInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ StorageStatus org$apache$spark$storage$StorageStatus$RddStorageInfo$$$outer() {
            return this.$outer;
        }

        public RddStorageInfo(StorageStatus $outer, long memoryUsage, long diskUsage, StorageLevel level) {
            this.memoryUsage = memoryUsage;
            this.diskUsage = diskUsage;
            this.level = level;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

