/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.spark.Partitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.shuffle.api.ShuffleMapOutputWriter;
import org.apache.spark.shuffle.api.ShufflePartitionWriter;
import org.apache.spark.shuffle.api.WritableByteChannelWrapper;
import org.apache.spark.shuffle.sort.BypassMergeSortShuffleHandle;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.DiskBlockObjectWriter;
import org.apache.spark.storage.FileSegment;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.io.Closeables;
import scala.None$;
import scala.Option;
import scala.Product2;
import scala.Tuple2;
import scala.collection.Iterator;

final class BypassMergeSortShuffleWriter<K, V>
extends ShuffleWriter<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(BypassMergeSortShuffleWriter.class);
    private final int fileBufferSize;
    private final boolean transferToEnabled;
    private final int numPartitions;
    private final BlockManager blockManager;
    private final Partitioner partitioner;
    private final ShuffleWriteMetricsReporter writeMetrics;
    private final int shuffleId;
    private final long mapId;
    private final Serializer serializer;
    private final ShuffleExecutorComponents shuffleExecutorComponents;
    private DiskBlockObjectWriter[] partitionWriters;
    private FileSegment[] partitionWriterSegments;
    @Nullable
    private MapStatus mapStatus;
    private long[] partitionLengths;
    private boolean stopping = false;

    BypassMergeSortShuffleWriter(BlockManager blockManager, BypassMergeSortShuffleHandle<K, V> handle, long mapId, SparkConf conf, ShuffleWriteMetricsReporter writeMetrics, ShuffleExecutorComponents shuffleExecutorComponents) {
        this.fileBufferSize = (int)((Long)conf.get(package$.MODULE$.SHUFFLE_FILE_BUFFER_SIZE())).longValue() * 1024;
        this.transferToEnabled = conf.getBoolean("spark.file.transferTo", true);
        this.blockManager = blockManager;
        ShuffleDependency dep = handle.dependency();
        this.mapId = mapId;
        this.shuffleId = dep.shuffleId();
        this.partitioner = dep.partitioner();
        this.numPartitions = this.partitioner.numPartitions();
        this.writeMetrics = writeMetrics;
        this.serializer = dep.serializer();
        this.shuffleExecutorComponents = shuffleExecutorComponents;
    }

    @Override
    public void write(Iterator<Product2<K, V>> records) throws IOException {
        assert (this.partitionWriters == null);
        ShuffleMapOutputWriter mapOutputWriter = this.shuffleExecutorComponents.createMapOutputWriter(this.shuffleId, this.mapId, this.numPartitions);
        try {
            int i;
            if (!records.hasNext()) {
                this.partitionLengths = mapOutputWriter.commitAllPartitions();
                this.mapStatus = MapStatus$.MODULE$.apply(this.blockManager.shuffleServerId(), this.partitionLengths, this.mapId);
                return;
            }
            SerializerInstance serInstance = this.serializer.newInstance();
            long openStartTime = System.nanoTime();
            this.partitionWriters = new DiskBlockObjectWriter[this.numPartitions];
            this.partitionWriterSegments = new FileSegment[this.numPartitions];
            for (i = 0; i < this.numPartitions; ++i) {
                Tuple2<TempShuffleBlockId, File> tempShuffleBlockIdPlusFile = this.blockManager.diskBlockManager().createTempShuffleBlock();
                File file = (File)tempShuffleBlockIdPlusFile._2();
                BlockId blockId = (BlockId)tempShuffleBlockIdPlusFile._1();
                this.partitionWriters[i] = this.blockManager.getDiskWriter(blockId, file, serInstance, this.fileBufferSize, this.writeMetrics);
            }
            this.writeMetrics.incWriteTime(System.nanoTime() - openStartTime);
            while (records.hasNext()) {
                Product2 record = (Product2)records.next();
                Object key = record._1();
                this.partitionWriters[this.partitioner.getPartition(key)].write(key, record._2());
            }
            for (i = 0; i < this.numPartitions; ++i) {
                try (DiskBlockObjectWriter writer = this.partitionWriters[i];){
                    this.partitionWriterSegments[i] = writer.commitAndGet();
                    continue;
                }
            }
            this.partitionLengths = this.writePartitionedData(mapOutputWriter);
            this.mapStatus = MapStatus$.MODULE$.apply(this.blockManager.shuffleServerId(), this.partitionLengths, this.mapId);
        }
        catch (Exception e) {
            try {
                mapOutputWriter.abort(e);
            }
            catch (Exception e2) {
                logger.error("Failed to abort the writer after failing to write map output.", (Throwable)e2);
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @VisibleForTesting
    long[] getPartitionLengths() {
        return this.partitionLengths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] writePartitionedData(ShuffleMapOutputWriter mapOutputWriter) throws IOException {
        if (this.partitionWriters != null) {
            long writeStartTime = System.nanoTime();
            try {
                for (int i = 0; i < this.numPartitions; ++i) {
                    File file = this.partitionWriterSegments[i].file();
                    ShufflePartitionWriter writer = mapOutputWriter.getPartitionWriter(i);
                    if (!file.exists()) continue;
                    if (this.transferToEnabled) {
                        Optional<WritableByteChannelWrapper> maybeOutputChannel = writer.openChannelWrapper();
                        if (maybeOutputChannel.isPresent()) {
                            this.writePartitionedDataWithChannel(file, maybeOutputChannel.get());
                        } else {
                            this.writePartitionedDataWithStream(file, writer);
                        }
                    } else {
                        this.writePartitionedDataWithStream(file, writer);
                    }
                    if (file.delete()) continue;
                    logger.error("Unable to delete file for partition {}", (Object)i);
                }
            }
            finally {
                this.writeMetrics.incWriteTime(System.nanoTime() - writeStartTime);
            }
            this.partitionWriters = null;
        }
        return mapOutputWriter.commitAllPartitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePartitionedDataWithChannel(File file, WritableByteChannelWrapper outputChannel) throws IOException {
        boolean copyThrewException = true;
        try {
            FileInputStream in = new FileInputStream(file);
            try (FileChannel inputChannel = in.getChannel();){
                Utils.copyFileStreamNIO(inputChannel, outputChannel.channel(), 0L, inputChannel.size());
                copyThrewException = false;
            }
            finally {
                Closeables.close((Closeable)in, (boolean)copyThrewException);
            }
        }
        finally {
            Closeables.close((Closeable)outputChannel, (boolean)copyThrewException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePartitionedDataWithStream(File file, ShufflePartitionWriter writer) throws IOException {
        boolean copyThrewException = true;
        FileInputStream in = new FileInputStream(file);
        try {
            OutputStream outputStream = writer.openStream();
            try {
                Utils.copyStream(in, outputStream, false, false);
                copyThrewException = false;
            }
            finally {
                Closeables.close((Closeable)outputStream, (boolean)copyThrewException);
            }
        }
        finally {
            Closeables.close((Closeable)in, (boolean)copyThrewException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<MapStatus> stop(boolean success) {
        if (this.stopping) {
            return None$.empty();
        }
        this.stopping = true;
        if (success) {
            if (this.mapStatus == null) {
                throw new IllegalStateException("Cannot call stop(true) without having called write()");
            }
            return Option.apply((Object)this.mapStatus);
        }
        if (this.partitionWriters != null) {
            try {
                for (DiskBlockObjectWriter writer : this.partitionWriters) {
                    File file = writer.revertPartialWritesAndClose();
                    if (file.delete()) continue;
                    logger.error("Error while deleting file {}", (Object)file.getAbsolutePath());
                }
            }
            finally {
                this.partitionWriters = null;
            }
        }
        return None$.empty();
    }
}

