/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import jdk.vm.ci.code.BytecodePosition;

final class DefaultVirtualInvokeTypeFlow
extends AbstractVirtualInvokeTypeFlow {
    private TypeState seenReceiverTypes = TypeState.forEmpty();

    DefaultVirtualInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        if (this.isSaturated()) {
            return;
        }
        TypeState receiverState = this.getReceiver().getState();
        if (!this.isContextInsensitive()) {
            receiverState = this.filterReceiverState(bb, receiverState);
        }
        for (AnalysisType type : receiverState.types(bb)) {
            if (this.isSaturated()) {
                return;
            }
            if (this.seenReceiverTypes.containsType(type)) continue;
            AnalysisMethod method = null;
            try {
                method = type.resolveConcreteMethod(this.targetMethod);
            }
            catch (UnsupportedFeatureException ex) {
                bb.getUnsupportedFeatures().addMessage("resolve_" + this.targetMethod.format("%H.%n(%p)"), this.targetMethod, ex.getMessage(), null, ex);
            }
            if (method == null || Modifier.isAbstract(method.getModifiers())) continue;
            assert (!Modifier.isAbstract(method.getModifiers()));
            MethodTypeFlow callee = PointsToAnalysis.assertPointsToAnalysisMethod(method).getTypeFlow();
            MethodFlowsGraph calleeFlows = callee.getOrCreateMethodFlowsGraph(bb, this);
            if (this.addCallee(callee.getMethod())) {
                this.linkCallee(bb, false, calleeFlows);
            }
            this.updateReceiver(bb, calleeFlows, TypeState.forExactType(bb, type, false));
        }
        this.seenReceiverTypes = receiverState;
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        this.setSaturated();
        this.getReceiver().removeObserver(this);
        for (AnalysisMethod callee : super.getCallees()) {
            MethodFlowsGraph calleeFlows = PointsToAnalysis.assertPointsToAnalysisMethod(callee).getTypeFlow().getMethodFlowsGraph();
            for (int i = 0; i < this.actualParameters.length; ++i) {
                FormalParamTypeFlow formalParam = calleeFlows.getParameter(i);
                if (this.actualParameters[i] == null || formalParam == null) continue;
                this.actualParameters[i].removeUse(formalParam);
            }
            if (this.actualReturn == null || calleeFlows.getReturnFlow() == null) continue;
            calleeFlows.getReturnFlow().removeUse(this.actualReturn);
        }
        AbstractVirtualInvokeTypeFlow contextInsensitiveInvoke = (AbstractVirtualInvokeTypeFlow)this.targetMethod.initAndGetContextInsensitiveInvoke(bb, (BytecodePosition)this.source, false);
        contextInsensitiveInvoke.addInvokeLocation((BytecodePosition)this.getSource());
        for (int i = 1; i < this.actualParameters.length; ++i) {
            if (this.actualParameters[i] == null) continue;
            this.actualParameters[i].addUse(bb, contextInsensitiveInvoke.getActualParameter(i));
        }
        if (this.actualReturn != null) {
            contextInsensitiveInvoke.getActualReturn().addUse(bb, this.actualReturn);
        }
    }

    @Override
    public void setSaturated() {
        super.setSaturated();
        if (this.isClone()) {
            this.originalInvoke.setSaturated();
        }
    }

    @Override
    public Collection<AnalysisMethod> getCallees() {
        if (this.isSaturated()) {
            return this.targetMethod.getContextInsensitiveVirtualInvoke().getCallees();
        }
        return super.getCallees();
    }

    @Override
    public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
        Collection<AnalysisMethod> calleesList = this.getCallees();
        ArrayList<MethodFlowsGraph> methodFlowsGraphs = new ArrayList<MethodFlowsGraph>(calleesList.size());
        for (AnalysisMethod method : calleesList) {
            methodFlowsGraphs.add(PointsToAnalysis.assertPointsToAnalysisMethod(method).getTypeFlow().getMethodFlowsGraph());
        }
        return methodFlowsGraphs;
    }
}

