/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.plugins;

import com.oracle.graal.pointsto.nodes.AnalysisObjectCloneNode;
import java.lang.reflect.Type;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopySnippets;
import org.graalvm.compiler.replacements.nodes.MacroNode;

public class PointstoGraphBuilderPlugins {
    public static void registerSystemPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, System.class).setAllowOverwrite(true);
        ArrayCopySnippets.registerSystemArraycopyPlugin((InvocationPlugins.Registration)r);
    }

    public static void registerObjectPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Object.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("clone", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Object, (ValueNode)new AnalysisObjectCloneNode(MacroNode.MacroParams.of((GraphBuilderContext)b, (ResolvedJavaMethod)targetMethod, (ValueNode[])new ValueNode[]{object})));
                return true;
            }
        });
    }
}

