/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualParameterTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AtomicUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class PointsToAnalysisMethod
extends AnalysisMethod {
    private MethodTypeFlow typeFlow;
    private ConcurrentMap<InvokeTypeFlow, Object> invokedBy;
    private ConcurrentMap<InvokeTypeFlow, Object> implementationInvokedBy;
    private final AtomicReference<InvokeTypeFlow> contextInsensitiveVirtualInvoke = new AtomicReference();
    private final AtomicReference<InvokeTypeFlow> contextInsensitiveSpecialInvoke = new AtomicReference();

    PointsToAnalysisMethod(AnalysisUniverse universe, ResolvedJavaMethod wrapped) {
        super(universe, wrapped);
        this.typeFlow = universe.analysisPolicy().createMethodTypeFlow(this);
    }

    @Override
    public void startTrackInvocations() {
        if (this.invokedBy == null) {
            this.invokedBy = new ConcurrentHashMap<InvokeTypeFlow, Object>();
        }
        if (this.implementationInvokedBy == null) {
            this.implementationInvokedBy = new ConcurrentHashMap<InvokeTypeFlow, Object>();
        }
    }

    public MethodTypeFlow getTypeFlow() {
        return this.typeFlow;
    }

    public boolean registerAsInvoked(InvokeTypeFlow invoke) {
        if (this.invokedBy != null && invoke != null) {
            this.invokedBy.put(invoke, Boolean.TRUE);
        }
        return super.registerAsInvoked();
    }

    public boolean registerAsImplementationInvoked(InvokeTypeFlow invoke) {
        if (this.implementationInvokedBy != null && invoke != null) {
            this.implementationInvokedBy.put(invoke, Boolean.TRUE);
        }
        return super.registerAsImplementationInvoked();
    }

    @Override
    public List<BytecodePosition> getInvokeLocations() {
        ArrayList<BytecodePosition> locations = new ArrayList<BytecodePosition>();
        for (InvokeTypeFlow invoke : this.implementationInvokedBy.keySet()) {
            if (InvokeTypeFlow.isContextInsensitiveVirtualInvoke(invoke)) {
                locations.addAll(((AbstractVirtualInvokeTypeFlow)invoke).getInvokeLocations());
                continue;
            }
            locations.add((BytecodePosition)invoke.getSource());
        }
        return locations;
    }

    @Override
    public Iterable<? extends InvokeInfo> getInvokes() {
        return this.getTypeFlow().getInvokes().getValues();
    }

    @Override
    public StackTraceElement[] getParsingContext() {
        return this.getTypeFlow().getParsingContext();
    }

    public InvokeTypeFlow initAndGetContextInsensitiveInvoke(PointsToAnalysis bb, BytecodePosition originalLocation, boolean isSpecial) {
        return AtomicUtils.produceAndSetValue(isSpecial ? this.contextInsensitiveSpecialInvoke : this.contextInsensitiveVirtualInvoke, () -> PointsToAnalysisMethod.createContextInsensitiveInvoke(bb, this, originalLocation, isSpecial), t -> PointsToAnalysisMethod.initContextInsensitiveInvoke(bb, this, t));
    }

    private static InvokeTypeFlow createContextInsensitiveInvoke(PointsToAnalysis bb, PointsToAnalysisMethod method, BytecodePosition originalLocation, boolean isSpecial) {
        assert (!method.isStatic());
        TypeFlow[] actualParameters = new TypeFlow[method.getSignature().getParameterCount(true)];
        AnalysisType receiverType = method.getDeclaringClass();
        AllInstantiatedTypeFlow receiverFlow = receiverType.getTypeFlow(bb, false);
        actualParameters[0] = receiverFlow;
        for (int i = 1; i < actualParameters.length; ++i) {
            actualParameters[i] = new ActualParameterTypeFlow((AnalysisType)method.getSignature().getParameterType(i - 1, null));
        }
        ActualReturnTypeFlow actualReturn = null;
        AnalysisType returnType = (AnalysisType)method.getSignature().getReturnType(null);
        if (returnType.getStorageKind() == JavaKind.Object) {
            actualReturn = new ActualReturnTypeFlow(returnType);
        }
        InvokeTypeFlow invoke = isSpecial ? bb.analysisPolicy().createSpecialInvokeTypeFlow(originalLocation, receiverType, method, actualParameters, actualReturn) : bb.analysisPolicy().createVirtualInvokeTypeFlow(originalLocation, receiverType, method, actualParameters, actualReturn);
        invoke.markAsContextInsensitive();
        return invoke;
    }

    private static void initContextInsensitiveInvoke(PointsToAnalysis bb, AnalysisMethod method, InvokeTypeFlow invoke) {
        AnalysisType receiverType = method.getDeclaringClass();
        AllInstantiatedTypeFlow receiverFlow = receiverType.getTypeFlow(bb, false);
        receiverFlow.addObserver(bb, invoke);
    }

    public InvokeTypeFlow getContextInsensitiveVirtualInvoke() {
        InvokeTypeFlow invoke = this.contextInsensitiveVirtualInvoke.get();
        AnalysisError.guarantee(invoke != null);
        return invoke;
    }

    @Override
    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.contextInsensitiveVirtualInvoke.set(null);
        this.contextInsensitiveSpecialInvoke.set(null);
        this.typeFlow = null;
        this.invokedBy = null;
        this.implementationInvokedBy = null;
    }
}

