/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.flow.context.bytecode.ContextSensitiveMultiTypeState;
import com.oracle.graal.pointsto.flow.context.bytecode.ContextSensitiveSingleTypeState;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;

final class TypesObjectsIterator {
    private final int typesCount;
    private final AnalysisObject[] objects;
    private int typeIdx = 0;
    private int objectIdx = 0;

    TypesObjectsIterator(TypeState state) {
        this.typesCount = state.typesCount();
        this.objects = TypesObjectsIterator.objectsArray(state);
    }

    private static AnalysisObject[] objectsArray(TypeState state) {
        if (state.isEmpty() || state.isNull()) {
            return AnalysisObject.EMPTY_ARRAY;
        }
        if (state instanceof ContextSensitiveSingleTypeState) {
            return ((ContextSensitiveSingleTypeState)state).objects;
        }
        if (state instanceof ContextSensitiveMultiTypeState) {
            return ((ContextSensitiveMultiTypeState)state).objects;
        }
        throw AnalysisError.shouldNotReachHere();
    }

    public boolean hasNextType() {
        return this.typeIdx < this.typesCount;
    }

    public boolean hasNextObject(AnalysisType type) {
        return this.objectIdx < this.objects.length && this.objects[this.objectIdx].getTypeId() == type.getId();
    }

    public AnalysisType nextType() {
        assert (this.hasNextType());
        ++this.typeIdx;
        return this.objects[this.objectIdx].type();
    }

    public AnalysisObject nextObject(AnalysisType type) {
        assert (this.hasNextObject(type));
        return this.objects[this.objectIdx++];
    }
}

