/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.protocol.Encoders;

public class ExecutorShuffleInfo
implements Encodable {
    public final String[] localDirs;
    public final int subDirsPerLocalDir;
    public final String shuffleManager;

    @JsonCreator
    public ExecutorShuffleInfo(@JsonProperty(value="localDirs") String[] localDirs, @JsonProperty(value="subDirsPerLocalDir") int subDirsPerLocalDir, @JsonProperty(value="shuffleManager") String shuffleManager) {
        this.localDirs = localDirs;
        this.subDirsPerLocalDir = subDirsPerLocalDir;
        this.shuffleManager = shuffleManager;
    }

    public int hashCode() {
        return Objects.hash(this.subDirsPerLocalDir, this.shuffleManager) * 41 + Arrays.hashCode(this.localDirs);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("localDirs", (Object)Arrays.toString(this.localDirs)).append("subDirsPerLocalDir", this.subDirsPerLocalDir).append("shuffleManager", (Object)this.shuffleManager).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof ExecutorShuffleInfo) {
            ExecutorShuffleInfo o = (ExecutorShuffleInfo)other;
            return Arrays.equals(this.localDirs, o.localDirs) && this.subDirsPerLocalDir == o.subDirsPerLocalDir && Objects.equals(this.shuffleManager, o.shuffleManager);
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.StringArrays.encodedLength((String[])this.localDirs) + 4 + Encoders.Strings.encodedLength((String)this.shuffleManager);
    }

    public void encode(ByteBuf buf) {
        Encoders.StringArrays.encode((ByteBuf)buf, (String[])this.localDirs);
        buf.writeInt(this.subDirsPerLocalDir);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.shuffleManager);
    }

    public static ExecutorShuffleInfo decode(ByteBuf buf) {
        String[] localDirs = Encoders.StringArrays.decode((ByteBuf)buf);
        int subDirsPerLocalDir = buf.readInt();
        String shuffleManager = Encoders.Strings.decode((ByteBuf)buf);
        return new ExecutorShuffleInfo(localDirs, subDirsPerLocalDir, shuffleManager);
    }
}

