/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.BlockStoreClient;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.BlocksRemoved;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.GetLocalDirsForExecutors;
import org.apache.spark.network.shuffle.protocol.LocalDirsForExecutors;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.shuffle.protocol.RemoveBlocks;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.collect.Lists;

public class ExternalBlockStoreClient
extends BlockStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(ExternalBlockStoreClient.class);
    private final TransportConf conf;
    private final boolean authEnabled;
    private final SecretKeyHolder secretKeyHolder;
    private final long registrationTimeoutMs;
    protected volatile TransportClientFactory clientFactory;
    protected String appId;

    public ExternalBlockStoreClient(TransportConf conf, SecretKeyHolder secretKeyHolder, boolean authEnabled, long registrationTimeoutMs) {
        this.conf = conf;
        this.secretKeyHolder = secretKeyHolder;
        this.authEnabled = authEnabled;
        this.registrationTimeoutMs = registrationTimeoutMs;
    }

    protected void checkInit() {
        assert (this.appId != null) : "Called before init()";
    }

    public void init(String appId) {
        this.appId = appId;
        TransportContext context = new TransportContext(this.conf, (RpcHandler)new NoOpRpcHandler(), true, true);
        ArrayList bootstraps = Lists.newArrayList();
        if (this.authEnabled) {
            bootstraps.add(new AuthClientBootstrap(this.conf, appId, this.secretKeyHolder));
        }
        this.clientFactory = context.createClientFactory((List)bootstraps);
    }

    @Override
    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener, DownloadFileManager downloadFileManager) {
        this.checkInit();
        logger.debug("External shuffle fetch from {}:{} (executor id {})", new Object[]{host, port, execId});
        try {
            RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = (blockIds1, listener1) -> {
                if (this.clientFactory != null) {
                    TransportClient client = this.clientFactory.createClient(host, port);
                    new OneForOneBlockFetcher(client, this.appId, execId, blockIds1, listener1, this.conf, downloadFileManager).start();
                } else {
                    logger.info("This clientFactory was closed. Skipping further block fetch retries.");
                }
            };
            int maxRetries = this.conf.maxIORetries();
            if (maxRetries > 0) {
                new RetryingBlockFetcher(this.conf, blockFetchStarter, blockIds, listener).start();
            } else {
                blockFetchStarter.createAndStart(blockIds, listener);
            }
        }
        catch (Exception e) {
            logger.error("Exception while beginning fetchBlocks", (Throwable)e);
            for (String blockId : blockIds) {
                listener.onBlockFetchFailure(blockId, e);
            }
        }
    }

    @Override
    public MetricSet shuffleMetrics() {
        this.checkInit();
        return this.clientFactory.getAllMetrics();
    }

    public void registerWithShuffleServer(String host, int port, String execId, ExecutorShuffleInfo executorInfo) throws IOException, InterruptedException {
        this.checkInit();
        try (TransportClient client = this.clientFactory.createClient(host, port);){
            ByteBuffer registerMessage = new RegisterExecutor(this.appId, execId, executorInfo).toByteBuffer();
            client.sendRpcSync(registerMessage, this.registrationTimeoutMs);
        }
    }

    public Future<Integer> removeBlocks(String host, int port, final String execId, final String[] blockIds) throws IOException, InterruptedException {
        this.checkInit();
        final CompletableFuture<Integer> numRemovedBlocksFuture = new CompletableFuture<Integer>();
        ByteBuffer removeBlocksMessage = new RemoveBlocks(this.appId, execId, blockIds).toByteBuffer();
        final TransportClient client = this.clientFactory.createClient(host, port);
        client.sendRpc(removeBlocksMessage, new RpcResponseCallback(){

            public void onSuccess(ByteBuffer response) {
                try {
                    BlockTransferMessage msgObj = BlockTransferMessage.Decoder.fromByteBuffer(response);
                    numRemovedBlocksFuture.complete(((BlocksRemoved)msgObj).numRemovedBlocks);
                }
                catch (Throwable t) {
                    logger.warn("Error trying to remove RDD blocks " + Arrays.toString(blockIds) + " via external shuffle service from executor: " + execId, t);
                    numRemovedBlocksFuture.complete(0);
                }
                finally {
                    client.close();
                }
            }

            public void onFailure(Throwable e) {
                logger.warn("Error trying to remove RDD blocks " + Arrays.toString(blockIds) + " via external shuffle service from executor: " + execId, e);
                numRemovedBlocksFuture.complete(0);
                client.close();
            }
        });
        return numRemovedBlocksFuture;
    }

    public void getHostLocalDirs(String host, int port, String[] execIds, final CompletableFuture<Map<String, String[]>> hostLocalDirsCompletable) {
        this.checkInit();
        final GetLocalDirsForExecutors getLocalDirsMessage = new GetLocalDirsForExecutors(this.appId, execIds);
        try {
            final TransportClient client = this.clientFactory.createClient(host, port);
            client.sendRpc(getLocalDirsMessage.toByteBuffer(), new RpcResponseCallback(){

                public void onSuccess(ByteBuffer response) {
                    try {
                        BlockTransferMessage msgObj = BlockTransferMessage.Decoder.fromByteBuffer(response);
                        hostLocalDirsCompletable.complete(((LocalDirsForExecutors)msgObj).getLocalDirsByExec());
                    }
                    catch (Throwable t) {
                        logger.warn("Error trying to get the host local dirs for " + Arrays.toString(getLocalDirsMessage.execIds) + " via external shuffle service", t.getCause());
                        hostLocalDirsCompletable.completeExceptionally(t);
                    }
                    finally {
                        client.close();
                    }
                }

                public void onFailure(Throwable t) {
                    logger.warn("Error trying to get the host local dirs for " + Arrays.toString(getLocalDirsMessage.execIds) + " via external shuffle service", t.getCause());
                    hostLocalDirsCompletable.completeExceptionally(t);
                    client.close();
                }
            });
        }
        catch (IOException | InterruptedException e) {
            hostLocalDirsCompletable.completeExceptionally(e);
        }
    }

    @Override
    public void close() {
        this.checkInit();
        if (this.clientFactory != null) {
            this.clientFactory.close();
            this.clientFactory = null;
        }
    }
}

