/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.spi.LimitedValueProxy;
import org.graalvm.compiler.phases.Phase;

public class StrengthenStampsPhase
extends Phase {
    private final boolean parseOnce = SubstrateOptions.parseOnce();

    protected void run(StructuredGraph graph) {
        for (Node n : graph.getNodes()) {
            ObjectStamp newStamp;
            LoadFieldNode node;
            if (n instanceof ValueNode && !(n instanceof LimitedValueProxy) && !(n instanceof PhiNode)) {
                node = (ValueNode)n;
                node.inferStamp();
                newStamp = this.strengthen(node.stamp(NodeView.DEFAULT));
                if (newStamp != null) {
                    assert (!this.parseOnce) : "Must be done by StrengthenGraphs";
                    node.setStamp((Stamp)newStamp);
                }
            }
            if (n instanceof LoadFieldNode) {
                node = (LoadFieldNode)n;
                this.updateStamp((ValueNode)node, this.toHosted(node.field()).getFieldTypeProfile());
                continue;
            }
            if (n instanceof InstanceOfNode) {
                node = (InstanceOfNode)n;
                newStamp = (ObjectStamp)this.strengthen((Stamp)node.getCheckedStamp());
                if (newStamp == null) continue;
                assert (!this.parseOnce) : "Must be done by StrengthenGraphs";
                node.replaceAndDelete(graph.addOrUniqueWithInputs((Node)InstanceOfNode.createHelper((ObjectStamp)newStamp, (ValueNode)node.getValue(), (JavaTypeProfile)node.profile(), (AnchoringNode)node.getAnchor())));
                continue;
            }
            if (!(n instanceof PiNode) || (newStamp = this.strengthen((node = (PiNode)n).piStamp())) == null) continue;
            assert (!this.parseOnce) : "Must be done by StrengthenGraphs";
            node.strengthenPiStamp((Stamp)newStamp);
        }
    }

    private Stamp strengthen(Stamp s) {
        Stamp newStamp;
        if (!(s instanceof AbstractObjectStamp)) {
            return null;
        }
        AbstractObjectStamp stamp = (AbstractObjectStamp)s;
        HostedType originalType = this.toHosted(stamp.type());
        if (originalType == null) {
            return null;
        }
        HostedType strengthenType = originalType.getStrengthenStampType();
        if (originalType.equals(strengthenType)) {
            return null;
        }
        if (strengthenType == null) {
            newStamp = stamp.nonNull() ? StampFactory.empty((JavaKind)JavaKind.Object) : StampFactory.alwaysNull();
        } else if (stamp.isExactType()) {
            newStamp = StampFactory.empty((JavaKind)JavaKind.Object);
        } else {
            ResolvedJavaType targetType = this.toTarget(strengthenType);
            if (targetType == null) {
                return null;
            }
            TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)targetType);
            newStamp = StampFactory.object((TypeReference)typeRef, (boolean)stamp.nonNull());
        }
        return newStamp;
    }

    private void updateStamp(ValueNode node, JavaTypeProfile typeProfile) {
        Stamp newStamp;
        if (node.getStackKind() != JavaKind.Object) {
            return;
        }
        if (typeProfile != null && !(newStamp = this.strengthenStamp(node, typeProfile)).equals(node.stamp(NodeView.DEFAULT))) {
            assert (!this.parseOnce) : "Must be done by StrengthenGraphs";
            node.getDebug().log("STAMP UPDATE  method %s  node %s  old %s  new %s\n", (Object)node.graph().method().format("%H.%n(%p)"), (Object)node, (Object)node.stamp(NodeView.DEFAULT), (Object)newStamp);
            node.setStamp(newStamp);
        }
    }

    private Stamp strengthenStamp(ValueNode node, JavaTypeProfile typeProfile) {
        HostedType baseType;
        ObjectStamp oldStamp = (ObjectStamp)node.stamp(NodeView.DEFAULT);
        HostedType oldType = this.toHosted(oldStamp.type());
        if (oldStamp.alwaysNull()) {
            return oldStamp;
        }
        boolean nonNull = oldStamp.nonNull() || typeProfile.getNullSeen() == TriState.FALSE;
        JavaTypeProfile.ProfiledType[] exactTypes = typeProfile.getTypes();
        if (exactTypes.length == 1) {
            ResolvedJavaType exactType = exactTypes[0].getType();
            assert (oldType == null || oldType.isAssignableFrom(exactType));
            if (!oldStamp.isExactType() || !exactType.equals(oldType) || nonNull != oldStamp.nonNull()) {
                ResolvedJavaType targetType = this.toTarget(exactType);
                if (targetType == null) {
                    return oldStamp;
                }
                TypeReference typeRef = TypeReference.createExactTrusted((ResolvedJavaType)targetType);
                return nonNull ? StampFactory.objectNonNull((TypeReference)typeRef) : StampFactory.object((TypeReference)typeRef);
            }
            return oldStamp;
        }
        if (exactTypes.length == 0) {
            if (!nonNull) {
                return StampFactory.alwaysNull();
            }
            StructuredGraph graph = node.graph();
            Object insertionPoint = node instanceof ParameterNode ? graph.start() : (node instanceof InvokeWithExceptionNode ? ((InvokeWithExceptionNode)node).next() : (FixedWithNextNode)node);
            graph.addAfterFixed((FixedWithNextNode)insertionPoint, (FixedNode)graph.add((Node)new FixedGuardNode((LogicNode)LogicConstantNode.forBoolean((boolean)true, (Graph)graph), DeoptimizationReason.UnreachedCode, DeoptimizationAction.None, true)));
            return oldStamp;
        }
        if (oldStamp.isExactType()) {
            baseType = oldType;
        } else {
            assert (exactTypes.length > 1);
            assert (oldType == null || oldType.isAssignableFrom(exactTypes[0].getType()));
            baseType = exactTypes[0].getType();
            for (int i = 1; i < exactTypes.length; ++i) {
                assert (oldType == null || oldType.isAssignableFrom(exactTypes[i].getType()));
                baseType = baseType.findLeastCommonAncestor(exactTypes[i].getType());
            }
            if (oldType != null && !oldType.isAssignableFrom(baseType)) {
                baseType = oldType;
            }
        }
        if (!baseType.equals(oldType) || nonNull != oldStamp.nonNull()) {
            ResolvedJavaType targetType = this.toTarget(baseType);
            if (targetType == null) {
                return oldStamp;
            }
            TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)targetType);
            return nonNull ? StampFactory.objectNonNull((TypeReference)typeRef) : StampFactory.object((TypeReference)typeRef);
        }
        return oldStamp;
    }

    protected HostedType toHosted(ResolvedJavaType type) {
        return (HostedType)type;
    }

    protected HostedMethod toHosted(ResolvedJavaMethod method) {
        return (HostedMethod)method;
    }

    protected HostedField toHosted(ResolvedJavaField field) {
        return (HostedField)field;
    }

    protected ResolvedJavaType toTarget(ResolvedJavaType type) {
        return type;
    }
}

