/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.UninitializedStaticFieldValueReader;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.EmptyMemoryAcessProvider;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordBase;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisConstantReflectionProvider
extends SharedConstantReflectionProvider {
    private final AnalysisUniverse universe;
    private final MetaAccessProvider metaAccess;
    private final ConstantReflectionProvider originalConstantReflection;
    private final ClassInitializationSupport classInitializationSupport;

    public AnalysisConstantReflectionProvider(AnalysisUniverse universe, MetaAccessProvider metaAccess, ConstantReflectionProvider originalConstantReflection, ClassInitializationSupport classInitializationSupport) {
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.originalConstantReflection = originalConstantReflection;
        this.classInitializationSupport = classInitializationSupport;
    }

    public MemoryAccessProvider getMemoryAccessProvider() {
        return EmptyMemoryAcessProvider.SINGLETON;
    }

    public final JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        return this.readValue(this.metaAccess, (AnalysisField)field, receiver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JavaConstant readValue(MetaAccessProvider suppliedMetaAccess, AnalysisField field, JavaConstant receiver) {
        JavaConstant value;
        if (this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)field.getDeclaringClass())) {
            if (!field.isStatic()) throw VMError.shouldNotReachHere("Cannot read instance field of a class that is initialized at run time: " + field.format("%H.%n"));
            value = this.readUninitializedStaticValue(field);
            return this.interceptValue(field, value);
        } else {
            value = this.universe.lookup(ReadableJavaField.readFieldValue(suppliedMetaAccess, this.originalConstantReflection, field.wrapped, this.universe.toHosted(receiver)));
        }
        return this.interceptValue(field, value);
    }

    public ValueSupplier<JavaConstant> readHostedFieldValue(AnalysisField field, HostedMetaAccess hMetaAccess, JavaConstant receiver) {
        if (this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)field.getDeclaringClass())) {
            if (field.isStatic()) {
                return ValueSupplier.eagerValue((Object)this.readUninitializedStaticValue(field));
            }
            throw VMError.shouldNotReachHere("Cannot read instance field of a class that is initialized at run time: " + field.format("%H.%n"));
        }
        if (field.wrapped instanceof ReadableJavaField) {
            ReadableJavaField readableField = (ReadableJavaField)field.wrapped;
            if (readableField.isValueAvailableBeforeAnalysis()) {
                return ValueSupplier.eagerValue((Object)this.universe.lookup(readableField.readValue(this.metaAccess, receiver)));
            }
            return ValueSupplier.lazyValue(() -> this.universe.lookup(readableField.readValue((MetaAccessProvider)hMetaAccess, receiver)), readableField::isValueAvailable);
        }
        return ValueSupplier.eagerValue((Object)this.universe.lookup(this.originalConstantReflection.readFieldValue(field.wrapped, receiver)));
    }

    public JavaConstant readUninitializedStaticValue(AnalysisField field) {
        assert (this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)field.getDeclaringClass()));
        return UninitializedStaticFieldValueReader.readUninitializedStaticValue((AnalysisField)field, val -> SubstrateObjectConstant.forObject(val));
    }

    public JavaConstant interceptValue(AnalysisField field, JavaConstant value) {
        JavaConstant result = value;
        if (result != null) {
            result = AnalysisConstantReflectionProvider.filterInjectedAccessor(field, result);
            result = this.replaceObject(result);
            result = AnalysisConstantReflectionProvider.interceptAssertionStatus(field, result);
            result = this.interceptWordType(field, result);
        }
        return result;
    }

    private static JavaConstant filterInjectedAccessor(AnalysisField field, JavaConstant value) {
        if (field.getAnnotation(InjectAccessors.class) != null) {
            assert (!field.isAccessed());
            return JavaConstant.defaultForKind((JavaKind)value.getJavaKind());
        }
        return value;
    }

    private JavaConstant replaceObject(JavaConstant value) {
        Object oldObject;
        Object newObject;
        if (value == JavaConstant.NULL_POINTER) {
            return JavaConstant.NULL_POINTER;
        }
        if (value.getJavaKind() == JavaKind.Object && (newObject = this.universe.replaceObject(oldObject = this.universe.getSnippetReflection().asObject(Object.class, value))) != oldObject) {
            return this.universe.getSnippetReflection().forObject(newObject);
        }
        return value;
    }

    private static JavaConstant interceptAssertionStatus(AnalysisField field, JavaConstant value) {
        if (field.isStatic() && field.isSynthetic() && field.getName().startsWith("$assertionsDisabled")) {
            Class clazz = field.getDeclaringClass().getJavaClass();
            boolean assertionsEnabled = RuntimeAssertionsSupport.singleton().desiredAssertionStatus(clazz);
            return JavaConstant.forBoolean((!assertionsEnabled ? 1 : 0) != 0);
        }
        return value;
    }

    private JavaConstant interceptWordType(AnalysisField field, JavaConstant value) {
        if (value.getJavaKind() == JavaKind.Object) {
            Object originalObject = this.universe.getSnippetReflection().asObject(Object.class, value);
            if (this.universe.hostVM().isRelocatedPointer(originalObject)) {
                return value;
            }
            if (originalObject instanceof WordBase) {
                return JavaConstant.forIntegerKind((JavaKind)this.universe.getWordKind(), (long)((WordBase)originalObject).rawValue());
            }
            if (originalObject == null && field.getType().isWordType()) {
                return JavaConstant.forIntegerKind((JavaKind)this.universe.getWordKind(), (long)0L);
            }
        }
        return value;
    }

    public ResolvedJavaType asJavaType(Constant constant) {
        if (constant instanceof SubstrateObjectConstant) {
            Object obj = SubstrateObjectConstant.asObject(constant);
            if (obj instanceof DynamicHub) {
                return this.getHostVM().lookupType((DynamicHub)obj);
            }
            if (obj instanceof Class) {
                return this.metaAccess.lookupJavaType((Class)obj);
            }
        }
        return null;
    }

    public JavaConstant asJavaClass(ResolvedJavaType type) {
        DynamicHub dynamicHub = this.getHostVM().dynamicHub(type);
        AnalysisConstantReflectionProvider.registerAsReachable(this.getHostVM(), dynamicHub);
        assert (dynamicHub != null) : type.toClassName() + " has a null dynamicHub.";
        return SubstrateObjectConstant.forObject(dynamicHub);
    }

    protected static void registerAsReachable(SVMHost hostVM, DynamicHub dynamicHub) {
        assert (dynamicHub != null);
        AnalysisType valueType = hostVM.lookupType(dynamicHub);
        if (!valueType.isReachable() && BuildPhaseProvider.isAnalysisFinished()) {
            throw VMError.shouldNotReachHere("Registering type as reachable after analysis: " + valueType);
        }
        valueType.registerAsReachable();
    }

    private SVMHost getHostVM() {
        return (SVMHost)this.universe.hostVM();
    }
}

