/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import java.io.Closeable;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DeadlockWatchdog
implements Closeable {
    private final int watchdogInterval = SubstrateOptions.DeadlockWatchdogInterval.getValue();
    private final boolean watchdogExitOnTimeout = SubstrateOptions.DeadlockWatchdogExitOnTimeout.getValue();
    private final Thread thread;
    private volatile long nextDeadline;
    private volatile boolean stopped;

    DeadlockWatchdog() {
        if (this.watchdogInterval > 0) {
            this.thread = new Thread(this::watchdogThread);
            this.thread.start();
        } else {
            this.thread = null;
        }
    }

    public void recordActivity() {
        this.nextDeadline = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(this.watchdogInterval);
    }

    @Override
    public void close() {
        this.stopped = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    void watchdogThread() {
        this.recordActivity();
        while (!this.stopped) {
            long now = System.currentTimeMillis();
            if (now >= this.nextDeadline) {
                System.err.println();
                System.err.println("=== Image generator watchdog detected no activity. This can be a sign of a deadlock during image building. Dumping all stack traces. Current time: " + new Date());
                DeadlockWatchdog.threadDump();
                Runtime runtime = Runtime.getRuntime();
                long heapSizeUnit = 0x100000L;
                long usedHeapSize = runtime.totalMemory() / 0x100000L;
                long freeHeapSize = runtime.freeMemory() / 0x100000L;
                long maximumHeapSize = runtime.maxMemory() / 0x100000L;
                System.err.printf("=== Memory statistics (in MB):%n=== Used heap size: %d%n=== Free heap size: %d%n=== Maximum heap size: %d%n", usedHeapSize, freeHeapSize, maximumHeapSize);
                System.err.flush();
                if (this.watchdogExitOnTimeout) {
                    System.err.println("=== Image generator watchdog is aborting image generation. To configure the watchdog, use the options " + SubstrateOptionsParser.commandArgument(SubstrateOptions.DeadlockWatchdogInterval, Integer.toString(this.watchdogInterval), null) + " and " + SubstrateOptionsParser.commandArgument(SubstrateOptions.DeadlockWatchdogExitOnTimeout, "+", null));
                    System.exit(1);
                } else {
                    this.recordActivity();
                }
            }
            try {
                Thread.sleep(Math.max(Math.min(this.nextDeadline - now, TimeUnit.SECONDS.toMillis(1L)), 1L));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void threadDump() {
        for (ThreadInfo ti : ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
            DeadlockWatchdog.printThreadInfo(ti);
            DeadlockWatchdog.printLockInfo(ti.getLockedSynchronizers());
        }
        System.err.println();
    }

    private static void printThreadInfo(ThreadInfo ti) {
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " in " + ti.getThreadState());
        if (ti.getLockName() != null) {
            sb.append(" on lock=" + ti.getLockName());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        System.err.println(sb.toString());
        if (ti.getLockOwnerName() != null) {
            System.err.println("      owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
        }
        StackTraceElement[] stacktrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            System.err.println("    at " + ste.toString());
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                System.err.println("      - locked " + mi);
            }
        }
        System.err.println();
    }

    private static void printLockInfo(LockInfo[] locks) {
        if (locks.length > 0) {
            System.err.println("    Locked synchronizers: count = " + locks.length);
            for (LockInfo li : locks) {
                System.err.println("      - " + li);
            }
            System.err.println();
        }
    }
}

