/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class ClassLoaderFeature
implements InternalFeature {
    private static final NativeImageSystemClassLoader nativeImageSystemClassLoader = NativeImageSystemClassLoader.singleton();

    public static ClassLoader getRuntimeClassLoader(ClassLoader original) {
        if (ClassLoaderFeature.needsReplacement(original)) {
            return ClassLoaderFeature.nativeImageSystemClassLoader.defaultSystemClassLoader;
        }
        return original;
    }

    private static boolean needsReplacement(ClassLoader loader) {
        if (loader == nativeImageSystemClassLoader) {
            return true;
        }
        return nativeImageSystemClassLoader.isNativeImageClassLoader(loader);
    }

    private Object runtimeClassLoaderObjectReplacer(Object replaceCandidate) {
        if (replaceCandidate instanceof ClassLoader) {
            return ClassLoaderFeature.getRuntimeClassLoader((ClassLoader)replaceCandidate);
        }
        return replaceCandidate;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(this::runtimeClassLoaderObjectReplacer);
    }
}

