/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.IsolateAwareObjectConstantEquality;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import org.graalvm.nativeimage.c.function.CEntryPoint;

public abstract class IsolatedObjectProxy<T> {
    protected final ClientHandle<T> handle;
    private int cachedHash = 0;
    private String cachedToString = null;

    protected IsolatedObjectProxy(ClientHandle<T> handle) {
        this.handle = handle;
    }

    public ClientHandle<T> getHandle() {
        return this.handle;
    }

    public boolean equals(Object obj) {
        if (this != obj && obj != null && this.getClass().equals(obj.getClass())) {
            IsolatedObjectProxy other = (IsolatedObjectProxy)obj;
            if (this.cachedHash != 0 && other.cachedHash != 0 && this.cachedHash != other.cachedHash) {
                assert (!this.isEqual(other)) : "Sane hashCode implementation";
                return false;
            }
            return this.isEqual(other);
        }
        return this == obj;
    }

    boolean isEqual(IsolatedObjectProxy<?> other) {
        return IsolateAwareObjectConstantEquality.isolatedConstantHandleTargetsEqual(IsolatedCompileContext.get().getClient(), this.handle, other.handle);
    }

    public int hashCode() {
        if (this.cachedHash == 0) {
            int h = IsolatedObjectProxy.hashCode0(IsolatedCompileContext.get().getClient(), this.handle);
            this.cachedHash = h != 0 ? h : 1;
        }
        return this.cachedHash;
    }

    public String toString() {
        String s = this.cachedToString;
        if (s == null) {
            CompilerHandle<String> h = IsolatedObjectProxy.toString0(IsolatedCompileContext.get().getClient(), this.handle);
            this.cachedToString = s = IsolatedCompileContext.get().unhand(h);
        }
        return s;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static int hashCode0(ClientIsolateThread client, ClientHandle<?> handle) {
        return IsolatedCompileClient.get().unhand(handle).hashCode();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static CompilerHandle<String> toString0(ClientIsolateThread client, ClientHandle<?> handle) {
        Object obj = IsolatedCompileClient.get().unhand(handle);
        String s = "Isolated: " + obj;
        return IsolatedCompileClient.get().createStringInCompiler(s);
    }
}

