/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public class JavaFrameAnchors {
    private static final FastThreadLocalWord<JavaFrameAnchor> lastAnchor = (FastThreadLocalWord)FastThreadLocalFactory.createWord("JavaFrameAnchors.lastAnchor").setMaxOffset(127);

    public static void pushFrameAnchor(JavaFrameAnchor anchor) {
        anchor.setLastJavaIP((CodePointer)WordFactory.nullPointer());
        anchor.setLastJavaSP((Pointer)WordFactory.nullPointer());
        anchor.setPreviousAnchor(lastAnchor.get());
        lastAnchor.set(anchor);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrameAnchor popFrameAnchor() {
        JavaFrameAnchor result = lastAnchor.get();
        lastAnchor.set(result.getPreviousAnchor());
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrameAnchor getFrameAnchor() {
        return lastAnchor.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrameAnchor getFrameAnchor(IsolateThread vmThread) {
        return lastAnchor.get(vmThread);
    }
}

