/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.word.Pointer;

public final class AMD64CGlobalDataLoadAddressOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64CGlobalDataLoadAddressOp> TYPE = LIRInstructionClass.create(AMD64CGlobalDataLoadAddressOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue result;
    private final CGlobalDataInfo dataInfo;

    AMD64CGlobalDataLoadAddressOp(CGlobalDataInfo dataInfo, AllocatableValue result) {
        super(TYPE);
        assert (dataInfo != null);
        this.dataInfo = dataInfo;
        this.result = result;
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (SubstrateUtil.HOSTED) {
            int before = masm.position();
            AMD64Address address = masm.getPlaceholder(before);
            if (this.dataInfo.isSymbolReference()) {
                masm.movq(ValueUtil.asRegister((Value)this.result), address);
            } else {
                masm.leaq(ValueUtil.asRegister((Value)this.result), address);
            }
            crb.compilationResult.recordDataPatch(before, (Reference)new CGlobalDataReference(this.dataInfo));
        } else {
            Pointer globalsBase = CGlobalDataInfo.CGLOBALDATA_RUNTIME_BASE_ADDRESS.get();
            Pointer address = globalsBase.add(this.dataInfo.getOffset());
            masm.movq(ValueUtil.asRegister((Value)this.result), address.rawValue());
            if (this.dataInfo.isSymbolReference()) {
                masm.movq(ValueUtil.asRegister((Value)this.result), new AMD64Address(ValueUtil.asRegister((Value)this.result)));
            }
        }
    }
}

