/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers;

import com.oracle.svm.core.containers.CgroupInfo;
import com.oracle.svm.core.containers.CgroupMetrics;
import com.oracle.svm.core.containers.CgroupSubsystem;
import com.oracle.svm.core.containers.CgroupUtil;
import com.oracle.svm.core.containers.CgroupV1MetricsImpl;
import com.oracle.svm.core.containers.cgroupv1.CgroupV1Subsystem;
import com.oracle.svm.core.containers.cgroupv2.CgroupV2Subsystem;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class CgroupSubsystemFactory {
    private static final String CPU_CTRL = "cpu";
    private static final String CPUACCT_CTRL = "cpuacct";
    private static final String CPUSET_CTRL = "cpuset";
    private static final String BLKIO_CTRL = "blkio";
    private static final String MEMORY_CTRL = "memory";

    static CgroupMetrics create() {
        Optional<CgroupTypeResult> optResult = null;
        try {
            optResult = CgroupSubsystemFactory.determineType("/proc/self/mountinfo", "/proc/cgroups");
        }
        catch (IOException e) {
            return null;
        }
        if (!optResult.isPresent()) {
            return null;
        }
        CgroupTypeResult result = optResult.get();
        if (!result.isAnyControllersEnabled()) {
            return null;
        }
        if (result.isAnyCgroupV1Controllers() && result.isAnyCgroupV2Controllers()) {
            return null;
        }
        if (result.isCgroupV2()) {
            CgroupSubsystem subsystem = CgroupV2Subsystem.getInstance();
            return subsystem != null ? new CgroupMetrics(subsystem) : null;
        }
        CgroupV1Subsystem subsystem = CgroupV1Subsystem.getInstance();
        return subsystem != null ? new CgroupV1MetricsImpl(subsystem) : null;
    }

    public static Optional<CgroupTypeResult> determineType(String mountInfo, String cgroups) throws IOException {
        HashMap<String, CgroupInfo> infos = new HashMap<String, CgroupInfo>();
        List<String> lines = CgroupUtil.readAllLinesPrivileged(Paths.get(cgroups, new String[0]));
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            CgroupInfo info = CgroupInfo.fromCgroupsLine(line);
            switch (info.getName()) {
                case "cpu": {
                    infos.put(CPU_CTRL, info);
                    break;
                }
                case "cpuacct": {
                    infos.put(CPUACCT_CTRL, info);
                    break;
                }
                case "cpuset": {
                    infos.put(CPUSET_CTRL, info);
                    break;
                }
                case "memory": {
                    infos.put(MEMORY_CTRL, info);
                    break;
                }
                case "blkio": {
                    infos.put(BLKIO_CTRL, info);
                }
            }
        }
        boolean isCgroupsV2 = true;
        boolean anyControllersEnabled = false;
        boolean anyCgroupsV2Controller = false;
        boolean anyCgroupsV1Controller = false;
        for (CgroupInfo info : infos.values()) {
            anyCgroupsV1Controller = anyCgroupsV1Controller || info.getHierarchyId() != 0;
            anyCgroupsV2Controller = anyCgroupsV2Controller || info.getHierarchyId() == 0;
            isCgroupsV2 = isCgroupsV2 && info.getHierarchyId() == 0;
            anyControllersEnabled = anyControllersEnabled || info.isEnabled();
        }
        if (isCgroupsV2) {
            boolean anyCgroupMounted = false;
            for (String line : CgroupUtil.readAllLinesPrivileged(Paths.get(mountInfo, new String[0]))) {
                if (!line.contains("cgroup")) continue;
                anyCgroupMounted = true;
                break;
            }
            if (!anyCgroupMounted) {
                return Optional.empty();
            }
        }
        CgroupTypeResult result = new CgroupTypeResult(isCgroupsV2, anyControllersEnabled, anyCgroupsV2Controller, anyCgroupsV1Controller);
        return Optional.of(result);
    }

    public static final class CgroupTypeResult {
        private final boolean isCgroupV2;
        private final boolean anyControllersEnabled;
        private final boolean anyCgroupV2Controllers;
        private final boolean anyCgroupV1Controllers;

        private CgroupTypeResult(boolean isCgroupV2, boolean anyControllersEnabled, boolean anyCgroupV2Controllers, boolean anyCgroupV1Controllers) {
            this.isCgroupV2 = isCgroupV2;
            this.anyControllersEnabled = anyControllersEnabled;
            this.anyCgroupV1Controllers = anyCgroupV1Controllers;
            this.anyCgroupV2Controllers = anyCgroupV2Controllers;
        }

        public boolean isCgroupV2() {
            return this.isCgroupV2;
        }

        public boolean isAnyControllersEnabled() {
            return this.anyControllersEnabled;
        }

        public boolean isAnyCgroupV2Controllers() {
            return this.anyCgroupV2Controllers;
        }

        public boolean isAnyCgroupV1Controllers() {
            return this.anyCgroupV1Controllers;
        }
    }
}

