/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.JavaValue;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class ReservedRegisters {
    protected final Register frameRegister;
    protected final Register threadRegister;
    protected final Register heapBaseRegister;

    @Fold
    public static ReservedRegisters singleton() {
        return (ReservedRegisters)ImageSingletons.lookup(ReservedRegisters.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected ReservedRegisters(Register frameRegister, Register threadRegisterCandidate, Register heapBaseRegisterCandidate) {
        this.frameRegister = frameRegister;
        this.threadRegister = SubstrateOptions.MultiThreaded.getValue() != false ? threadRegisterCandidate : null;
        this.heapBaseRegister = SubstrateOptions.SpawnIsolates.getValue() != false ? heapBaseRegisterCandidate : null;
    }

    public Register getFrameRegister() {
        return this.frameRegister;
    }

    public Register getThreadRegister() {
        return this.threadRegister;
    }

    public Register getHeapBaseRegister() {
        return this.heapBaseRegister;
    }

    public boolean isAllowedInFrameState(JavaValue value) {
        Register register;
        return value instanceof RegisterValue && ((register = ((RegisterValue)value).getRegister()).equals((Object)this.threadRegister) || register.equals((Object)this.heapBaseRegister));
    }
}

