/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.Set;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.RolesCache;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Roles {
    private static final Logger logger = LoggerFactory.getLogger(Roles.class);
    private static final RolesCache cache = new RolesCache(DatabaseDescriptor.getRoleManager());

    public static Set<RoleResource> getRoles(RoleResource primaryRole) {
        return cache.getRoles(primaryRole);
    }

    public static boolean hasSuperuserStatus(RoleResource role) {
        try {
            IRoleManager roleManager = DatabaseDescriptor.getRoleManager();
            for (RoleResource r : cache.getRoles(role)) {
                if (!roleManager.isSuper(r)) continue;
                return true;
            }
            return false;
        }
        catch (RequestExecutionException e) {
            logger.debug("Failed to authorize {} for super-user permission", (Object)role.getRoleName());
            throw new UnauthorizedException("Unable to perform authorization of super-user permission: " + e.getMessage(), e);
        }
    }
}

